/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.servlet.ServletToolboxManager;
import org.apache.velocity.util.SimplePool;

public class VelocityViewServlet
extends HttpServlet {
    public static final String CONTENT_TYPE = "default.contentType";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_OUTPUT_ENCODING = "ISO-8859-1";
    public static final String SERVLET_CONTEXT_KEY = (class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = VelocityViewServlet.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext).getName();
    protected static final String TOOLBOX_KEY = "org.apache.velocity.toolbox";
    protected static final String INIT_PROPS_KEY = "org.apache.velocity.properties";
    private static SimplePool writerPool = new SimplePool(40);
    private String encoding = null;
    private String defaultContentType;
    private ServletToolboxManager toolboxManager = null;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$servlet$ServletLogger;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$servlet$WebappLoader;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initVelocity(servletConfig);
        this.initToolbox(servletConfig);
        this.defaultContentType = RuntimeSingleton.getString((String)CONTENT_TYPE, (String)DEFAULT_CONTENT_TYPE);
        this.encoding = RuntimeSingleton.getString((String)"output.encoding", (String)DEFAULT_OUTPUT_ENCODING);
    }

    protected void initToolbox(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        String string = servletConfig.getInitParameter(TOOLBOX_KEY);
        if (string == null || string.length() == 0) {
            string = servletContext.getInitParameter(TOOLBOX_KEY);
        }
        if (string != null) {
            this.toolboxManager = ServletToolboxManager.getInstance(servletContext, string);
        } else {
            Velocity.info((Object)"No toolbox entry in configuration.");
        }
    }

    protected void initVelocity(ServletConfig servletConfig) throws ServletException {
        Velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.getServletContext());
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)(class$org$apache$velocity$tools$view$servlet$ServletLogger == null ? (class$org$apache$velocity$tools$view$servlet$ServletLogger = VelocityViewServlet.class$("org.apache.velocity.tools.view.servlet.ServletLogger")) : class$org$apache$velocity$tools$view$servlet$ServletLogger).getName());
        Velocity.setProperty((String)"resource.loader", (Object)"webapp");
        Velocity.setProperty((String)"webapp.resource.loader.class", (Object)(class$org$apache$velocity$tools$view$servlet$WebappLoader == null ? (class$org$apache$velocity$tools$view$servlet$WebappLoader = VelocityViewServlet.class$("org.apache.velocity.tools.view.servlet.WebappLoader")) : class$org$apache$velocity$tools$view$servlet$WebappLoader).getName());
        try {
            ExtendedProperties extendedProperties = this.loadConfiguration(servletConfig);
            Velocity.setExtendedProperties((ExtendedProperties)extendedProperties);
        }
        catch (Exception exception) {
            this.getServletContext().log("Unable to read Velocity configuration file: " + exception);
            this.getServletContext().log("Using default Velocity configuration.");
        }
        try {
            Velocity.init();
        }
        catch (Exception exception) {
            this.getServletContext().log("VELOCITY PANIC : unable to init() : " + exception);
            throw new ServletException((Throwable)exception);
        }
    }

    protected ExtendedProperties loadConfiguration(ServletConfig servletConfig) throws IOException {
        ServletContext servletContext = servletConfig.getServletContext();
        String string = servletConfig.getInitParameter(INIT_PROPS_KEY);
        if (string == null || string.length() == 0) {
            string = servletContext.getInitParameter(INIT_PROPS_KEY);
        }
        ExtendedProperties extendedProperties = new ExtendedProperties();
        if (string != null) {
            extendedProperties.load(servletContext.getResourceAsStream(string));
            Velocity.info((Object)("Custom Properties File: " + string));
        } else {
            Velocity.info((Object)"No custom properties found. Using default Velocity configuration.");
        }
        return extendedProperties;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    protected void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            Context context = this.createContext(httpServletRequest, httpServletResponse);
            this.setContentType(httpServletRequest, httpServletResponse);
            Template template = this.handleRequest(httpServletRequest, httpServletResponse, context);
            if (template == null) {
                return;
            }
            this.mergeTemplate(template, context, httpServletResponse);
            this.requestCleanup(httpServletRequest, httpServletResponse, context);
        }
        catch (Exception exception) {
            this.error(httpServletRequest, httpServletResponse, exception);
        }
    }

    protected void requestCleanup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Context context) {
    }

    protected Template handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Context context) throws Exception {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        return this.getTemplate(string);
    }

    protected void setContentType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType(this.defaultContentType);
    }

    protected Context createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ChainedContext chainedContext = new ChainedContext(null, httpServletRequest, httpServletResponse, this.getServletContext());
        if (this.toolboxManager != null) {
            chainedContext.setToolbox(this.toolboxManager.getToolboxContext(chainedContext));
        }
        return chainedContext;
    }

    public Template getTemplate(String string) throws ResourceNotFoundException, ParseErrorException, Exception {
        return RuntimeSingleton.getTemplate((String)string);
    }

    public Template getTemplate(String string, String string2) throws ResourceNotFoundException, ParseErrorException, Exception {
        return RuntimeSingleton.getTemplate((String)string, (String)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeTemplate(Template template, Context context, HttpServletResponse httpServletResponse) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        VelocityWriter velocityWriter = null;
        try {
            velocityWriter = (VelocityWriter)writerPool.get();
            if (velocityWriter == null) {
                velocityWriter = new VelocityWriter((Writer)new OutputStreamWriter((OutputStream)servletOutputStream, this.encoding), 4096, true);
            } else {
                velocityWriter.recycle((Writer)new OutputStreamWriter((OutputStream)servletOutputStream, this.encoding));
            }
            template.merge(context, (Writer)velocityWriter);
        }
        finally {
            try {
                if (velocityWriter != null) {
                    velocityWriter.flush();
                    writerPool.put((Object)velocityWriter);
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws ServletException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<title>Error</title>");
        stringBuffer.append("<body bgcolor=\"#ffffff\">");
        stringBuffer.append("<h2>VelocityViewServlet : Error processing the template</h2>");
        stringBuffer.append("<pre>");
        String string = exception.getMessage();
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("<br>");
        }
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        stringBuffer.append(stringWriter.toString());
        stringBuffer.append("</pre>");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        httpServletResponse.getOutputStream().print(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

