/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.view.DataInfo;
import org.apache.velocity.tools.view.ToolInfo;
import org.apache.velocity.tools.view.ToolboxManager;
import org.apache.velocity.tools.view.ViewToolInfo;
import org.apache.velocity.tools.view.context.ToolboxContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public abstract class XMLToolboxManager
implements ToolboxManager {
    public static final String BASE_NODE = "toolbox";
    public static final String ELEMENT_TOOL = "tool";
    public static final String ELEMENT_DATA = "data";
    public static final String ELEMENT_KEY = "key";
    public static final String ELEMENT_CLASS = "class";
    public static final String ELEMENT_VALUE = "value";
    public static final String ATTRIBUTE_TYPE = "type";
    private List toolinfo = new ArrayList();

    public void addTool(ToolInfo toolInfo) {
        this.toolinfo.add(toolInfo);
    }

    public ToolboxContext getToolboxContext(Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.toolinfo.iterator();
        while (iterator.hasNext()) {
            ToolInfo toolInfo = (ToolInfo)iterator.next();
            hashMap.put(toolInfo.getKey(), toolInfo.getInstance(object));
        }
        return new ToolboxContext(hashMap);
    }

    protected void log(String string) {
        Velocity.info((Object)("XMLToolboxManager - " + string));
    }

    public void load(InputStream inputStream) throws Exception {
        this.log("Loading toolbox...");
        Document document = new SAXReader().read(inputStream);
        List list = document.selectNodes("//toolbox/*");
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!this.readElement(element)) continue;
            ++n;
        }
        this.log("Toolbox loaded.  Read " + n + " elements.");
    }

    protected boolean readElement(Element element) throws Exception {
        String string = element.getName();
        ToolInfo toolInfo = null;
        if (string.equalsIgnoreCase(ELEMENT_TOOL)) {
            toolInfo = this.readToolInfo(element);
        } else if (string.equalsIgnoreCase(ELEMENT_DATA)) {
            toolInfo = this.readDataInfo(element);
        } else {
            this.log("Could not read element: " + string);
            return false;
        }
        this.addTool(toolInfo);
        this.log("Added " + toolInfo.getClassname() + " as " + toolInfo.getKey());
        return true;
    }

    protected ToolInfo readToolInfo(Element element) throws Exception {
        Node node = element.selectSingleNode(ELEMENT_KEY);
        String string = node.getText();
        node = element.selectSingleNode(ELEMENT_CLASS);
        String string2 = node.getText();
        return new ViewToolInfo(string, string2);
    }

    protected ToolInfo readDataInfo(Element element) throws Exception {
        Node node = element.selectSingleNode(ELEMENT_KEY);
        String string = node.getText();
        node = element.selectSingleNode(ELEMENT_VALUE);
        String string2 = node.getText();
        String string3 = element.attributeValue(ATTRIBUTE_TYPE, DataInfo.TYPE_STRING);
        return new DataInfo(string, string3, string2);
    }
}

