/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTool {
    public static final Date getSystemDate() {
        return DateTool.getSystemCalendar().getTime();
    }

    public static final Calendar getSystemCalendar() {
        return Calendar.getInstance();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.getTimeZone(), this.getLocale());
    }

    public String getFormattedDate(String string) {
        return this.format(string, this.getDate());
    }

    public String format(String string, Object object) {
        return DateTool.format(string, object, this.getLocale());
    }

    public static String format(String string, Object object, Locale locale) {
        Date date = DateTool.toDate(object);
        if (date == null || string == null || locale == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        return simpleDateFormat.format(date);
    }

    public static Date toDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        try {
            DateFormat dateFormat = DateFormat.getInstance();
            return dateFormat.parse(String.valueOf(object));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date toDate(String string, Object object) {
        return DateTool.toDate(string, object, this.getLocale());
    }

    public static Date toDate(String string, Object object, Locale locale) {
        Date date = DateTool.toDate(object);
        if (date != null) {
            return date;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
            return simpleDateFormat.parse(String.valueOf(object));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Calendar toCalendar(Object object) {
        return DateTool.toCalendar(object, this.getLocale());
    }

    public static Calendar toCalendar(Object object, Locale locale) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        Date date = DateTool.toDate(object);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.getTime();
        return calendar;
    }

    public String toString() {
        return this.getDate().toString();
    }
}

