/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.struts.taglib.html.SelectTag;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ResponseUtils;

public class OptionTag
extends BodyTagSupport {
    protected static final Locale defaultLocale = Locale.getDefault();
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected String text = null;
    protected String bundle = "org.apache.struts.action.MESSAGE";
    protected boolean disabled = false;
    protected String key = null;
    protected String locale = "org.apache.struts.action.LOCALE";
    private String style = null;
    private String styleClass = null;
    protected String styleId = null;
    protected String value = null;

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int doStartTag() throws JspException {
        this.text = null;
        return 2;
    }

    public int doAfterBody() throws JspException {
        String text;
        if (this.bodyContent != null && (text = this.bodyContent.getString()) != null && (text = text.trim()).length() > 0) {
            this.text = text;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        ResponseUtils.write(this.pageContext, this.renderOptionElement());
        return 6;
    }

    protected String renderOptionElement() throws JspException {
        StringBuffer results = new StringBuffer("<option value=\"");
        results.append(this.value);
        results.append("\"");
        if (this.disabled) {
            results.append(" disabled=\"disabled\"");
        }
        if (this.selectTag().isMatched(this.value)) {
            results.append(" selected=\"selected\"");
        }
        if (this.style != null) {
            results.append(" style=\"");
            results.append(this.style);
            results.append("\"");
        }
        if (this.styleId != null) {
            results.append(" id=\"");
            results.append(this.styleId);
            results.append("\"");
        }
        if (this.styleClass != null) {
            results.append(" class=\"");
            results.append(this.styleClass);
            results.append("\"");
        }
        results.append(">");
        String text = this.text();
        if (text == null) {
            results.append(this.value);
        } else {
            results.append(text);
        }
        results.append("</option>");
        return results.toString();
    }

    private SelectTag selectTag() throws JspException {
        SelectTag selectTag = (SelectTag)((Object)this.pageContext.getAttribute("org.apache.struts.taglib.html.SELECT"));
        if (selectTag == null) {
            JspException e = new JspException(messages.getMessage("optionTag.select"));
            RequestUtils.saveException(this.pageContext, e);
            throw e;
        }
        return selectTag;
    }

    public void release() {
        super.release();
        this.bundle = "org.apache.struts.action.MESSAGE";
        this.disabled = false;
        this.key = null;
        this.locale = "org.apache.struts.action.LOCALE";
        this.style = null;
        this.styleClass = null;
        this.text = null;
        this.value = null;
    }

    protected String text() throws JspException {
        if (this.text != null) {
            return this.text;
        }
        if (this.key != null) {
            return RequestUtils.message(this.pageContext, this.bundle, this.locale, this.key);
        }
        return "";
    }
}

