/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.resources.Message;
import org.apache.commons.resources.MessageList;

public class BasicMessageList
implements Serializable,
MessageList {
    protected HashMap messages = new HashMap();
    private int iCount = 0;
    private String globalMessageKey = "org.apache.commons.resources.GLOBAL_MESSAGE";

    public BasicMessageList() {
    }

    public BasicMessageList(String globalMessageKey) {
        this.setGlobalMessageKey(globalMessageKey);
    }

    public BasicMessageList(MessageList messages) {
        this.add(messages);
    }

    public BasicMessageList(String globalMessageKey, MessageList messages) {
        this.add(messages);
    }

    public String getGlobalMessageKey() {
        return this.globalMessageKey;
    }

    public void setGlobalMessageKey(String globalMessageKey) {
        this.globalMessageKey = globalMessageKey;
    }

    public void add(String property, Message message) {
        MessageItem item = (MessageItem)this.messages.get(property);
        ArrayList<Message> list = null;
        if (item == null) {
            list = new ArrayList<Message>();
            item = new MessageItem(list, this.iCount++);
            this.messages.put(property, item);
        } else {
            list = item.getList();
        }
        list.add(message);
    }

    public void add(Message message) {
        this.add("org.apache.commons.resources.GLOBAL_MESSAGE", message);
    }

    public void add(MessageList messages) {
        Iterator props = messages.properties();
        while (props.hasNext()) {
            String property = (String)props.next();
            Iterator msgs = messages.get(property);
            while (msgs.hasNext()) {
                Message msg = (Message)msgs.next();
                this.add(property, msg);
            }
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public Iterator get() {
        if (this.messages.size() == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList results = new ArrayList();
        ArrayList actionItems = new ArrayList();
        Iterator i = this.messages.values().iterator();
        while (i.hasNext()) {
            actionItems.add(i.next());
        }
        Collections.sort(actionItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((MessageItem)o1).getOrder() - ((MessageItem)o2).getOrder();
            }
        });
        Iterator i2 = actionItems.iterator();
        while (i2.hasNext()) {
            MessageItem ami = (MessageItem)i2.next();
            Iterator messages = ami.getList().iterator();
            while (messages.hasNext()) {
                results.add(messages.next());
            }
        }
        return results.iterator();
    }

    public Iterator get(String property) {
        MessageItem item = (MessageItem)this.messages.get(property);
        if (item == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return item.getList().iterator();
    }

    public Iterator properties() {
        return this.messages.keySet().iterator();
    }

    public int size() {
        int total = 0;
        Iterator i = this.messages.values().iterator();
        while (i.hasNext()) {
            MessageItem ami = (MessageItem)i.next();
            total += ami.getList().size();
        }
        return total;
    }

    public int size(String property) {
        MessageItem ami = (MessageItem)this.messages.get(property);
        if (ami == null) {
            return 0;
        }
        return ami.getList().size();
    }

    protected static class MessageItem
    implements Serializable {
        List list = null;
        int iOrder = 0;

        public MessageItem(List list, int iOrder) {
            this.list = list;
            this.iOrder = iOrder;
        }

        public List getList() {
            return this.list;
        }

        public void setList(List list) {
            this.list = list;
        }

        public int getOrder() {
            return this.iOrder;
        }

        public void setOrder(int iOrder) {
            this.iOrder = iOrder;
        }
    }
}

