'''
Created on 2010/06/27

@author: katsuhiro Inagaki
'''

from django import forms
from django.forms.models import InlineForeignKeyHiddenInput
from django.utils.translation import ugettext_lazy as _

from djanction.item.models import Item
from djanction.rating.models import FeedbackLog
from djanction.appauth.models import User

class FeedbackForm(forms.ModelForm):
    user = forms.ModelChoiceField(queryset=User.objects.all(), widget=InlineForeignKeyHiddenInput, required=False)
    item = forms.ModelChoiceField(queryset=Item.objects.all(), widget=InlineForeignKeyHiddenInput, required=False)
    item_name = forms.CharField(widget=forms.HiddenInput, required=False)
    class Meta:
        model = FeedbackLog
