'''
Created on 2010/07/20

@author: tachibana_masashi
'''
from django.test import TestCase

class ItemTestCase(TestCase):

    fixtures = ['item',]

    def test_item_list(self):
        c = self.client
        c.login(username='admin', password='admin')
        response = c.get('/', {'is_complete':'True'})

        self.failUnlessEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'item/item_list.html')
        page = response.context['page']
        # test selected data
        self.assertEquals(len(page.object_list),10)
        self.assertEquals(page.object_list[0].id, 1)
        self.assertEquals(page.object_list[1].id, 9)
        self.assertEquals(page.object_list[2].id, 28)
        self.assertEquals(page.object_list[3].id, 29)
        self.assertEquals(page.object_list[4].id, 5)
        self.assertEquals(page.object_list[5].id, 3)
        self.assertEquals(page.object_list[6].id, 11)
        self.assertEquals(page.object_list[7].id, 13)
        self.assertEquals(page.object_list[8].id, 20)
        self.assertEquals(page.object_list[9].id, 16)


    def test_item_detail(self):
        c = self.client
        c.login(username='admin', password='admin')
        response = c.get('/items/1/', {'is_complete':'False'})

        self.failUnlessEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'item/item_detail.html')
        form = response.context['form']
        # test selected data
        self.assertEquals(form.instance.id, 1)
        self.assertEquals(form.instance.user.id, 2)
        self.assertEquals(form.instance.current_price, 100000)
        self.assertEquals(form.instance.is_complete, False)
        self.assertEquals(form.instance.start_price, 100)
        self.assertEquals(form.instance.prompt_price, 150000)


    def test__add_form(self):
        c = self.client
        c.login(username='admin', password='admin')
        response = c.get('/items/form/')

        self.failUnlessEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'item/form.html')
        form = response.context['form']
        # test selected data
        self.assertFalse(form.is_bound)