'''
Created on 2010/04/29

@author: katsuhiro Inagaki
'''
from django.db import models
from django.utils.translation import ugettext_lazy as _
from djanction.appauth.models import User

class Category(models.Model):
    category_name = models.CharField(_('category name'), max_length=255, unique=True)
    inner_category_name = models.CharField(_('inner category name'), max_length=128, unique=True)
    sort_order = models.IntegerField(_('sort order'), max_length=3)

    def __unicode__(self):
        return self.category_name

    class Meta:
        verbose_name = _('category')
        verbose_name_plural = _('categories')
        ordering = ['sort_order', 'category_name']


class Item(models.Model):
    COMMENT_TYPE_CHOICES = (
        ('P', 'Plain'),
        ('H', 'HTML'),
        ('W', 'Wiki'),
    )
    version = models.IntegerField(max_length=5, default=0)
    user = models.ForeignKey(User, related_name='item_user')
    category = models.ForeignKey(Category)
    item_name = models.CharField(_('item title'), max_length=255)
    comment = models.TextField(_('item comment'), max_length=10000)
    comment_type = models.CharField(_('type'), max_length=1, choices=COMMENT_TYPE_CHOICES, default='P')
    start_date = models.DateTimeField(_('start date'), auto_now=True)
    end_date = models.DateTimeField(_('end date'), )
    start_price = models.IntegerField(_('start price'), max_length=12, default=0)
    current_price = models.IntegerField(_('current price'), max_length=12, blank=True, null=True)
    prompt_price = models.IntegerField(_('prompt price'), max_length=12, blank=True, null=True)
    contract_price = models.IntegerField(_('contract price'), max_length=12, blank=True, null=True)
    is_complete = models.BooleanField(_('is complete'), default=False)
    search_text = models.CharField(_('search text'), max_length=255, blank=True, null=True)
    highest_bidder = models.ForeignKey(User, related_name='item_bidder', blank=True, null=True)
    is_auto_reopen = models.BooleanField(_('is auto reopen'), default=True)

    def __unicode__(self):
        return self.item_name

    class Meta:
        verbose_name = _('item')
        verbose_name_plural = _('items')


class ItemModifyLog(models.Model):
    item = models.ForeignKey(Item)
    mod_date = models.DateTimeField(_('mod date'), auto_now=True)
    comment = models.TextField(_('item comment'), max_length=1024)

    class Meta:
        verbose_name = _('item modfy log')
        verbose_name_plural = _('item modify logs')


class QA(models.Model):
    item = models.ForeignKey(Item)
    post_user = models.ForeignKey(User)
    post_date = models.DateTimeField(_('post date'), auto_now=True)
    comment = models.CharField(_('qa comment'), max_length=512)

    class Meta:
        verbose_name = _('QA')
        verbose_name_plural = _('QAs')


class ContactMessage(models.Model):
    item = models.ForeignKey(Item)
    post_user = models.ForeignKey(User)
    title = models.CharField(_('title'), max_length=256)
    comment = models.TextField(_('message'), max_length=4096)
    post_date = models.DateTimeField(_('post date'), auto_now=True)

    class Meta:
        verbose_name = _('contact message')
        verbose_name_plural = _('contact messages')

class BidLog(models.Model):
    BID_KIND_CHOICES = (
        ('0', _('Normal')),
    )
    item = models.ForeignKey(Item)
    user = models.ForeignKey(User)
    bid_date = models.DateTimeField(auto_now=True)
    bid_price = models.IntegerField(max_length=12)
    bid_kind = models.CharField(max_length=1, choices=BID_KIND_CHOICES, default='0')
    comment = models.CharField(max_length=256, null=True)

    def __unicode__(self):
        return str(self.bid_date)

    class Meta:
        verbose_name = _('bid log')
        verbose_name_plural = _('bid logs')

