'''
Created on 2010/04/25

@author: katsuhiro Inagaki
'''
import datetime
import os
from django.conf import settings
from django.contrib.auth import models as djauthmodel
from django.db import models
from django.utils.translation import ugettext_lazy as _

class UserManager(djauthmodel.UserManager):
    def create_djanctionuser(self, username, email, password=None):
        now = datetime.datetime.now()
        user = self.model(None, username=username, email=email.strip().lower(), is_staff=False, is_active=True, is_superuser=False, last_login=now, date_joined=now)
        if password:
            user.set_password(password)
        else:
            user.set_unusable_password()
        user.save()
        return user


class User(djauthmodel.User):
    zip_code = models.CharField(_('zip code'), max_length=7, blank=True)
    prefecture = models.CharField(_('prefecture'), max_length=4, blank=True)
    city = models.CharField(_('city'), max_length=20, blank=True)
    town = models.CharField(_('town'), max_length=128, blank=True)
    building = models.CharField(_('building'), max_length=128, blank=True)
    tel_no = models.CharField(_('tel no'), max_length=11, blank=True)
    birthday = models.DateField(_('birthday'), blank=True, null=True)
    rank = models.IntegerField(_('rank'), default=0)
    point = models.IntegerField(_('point'), default=0)
    total_assessment = models.IntegerField(_('total assessment'), default=0)
    secession_date = models.DateField(_('secession date'), blank=True, null=True)
    objects = UserManager()

    class Meta:
        verbose_name = _('user')
        verbose_name_plural = _('users')


class LoginLog(models.Model):
    session_id = models.CharField(max_length=32)
    user = models.ForeignKey('User')
    login_date = models.DateTimeField()
    ip_address = models.IPAddressField(null=True)
    is_success = models.BooleanField()
    user_agent = models.CharField(max_length=255, null=True)
