/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class CommandElement
extends QuickAccessElement {
    private static final String separator = " - ";
    private ParameterizedCommand command;
    private String id;

    CommandElement(ParameterizedCommand command, String id, CommandProvider commandProvider) {
        super(commandProvider);
        this.id = id;
        this.command = command;
    }

    @Override
    public void execute() {
        CommandProvider provider;
        QuickAccessProvider o = this.getProvider();
        if (o instanceof CommandProvider && (provider = (CommandProvider)o).getHandlerService() != null) {
            try {
                provider.getHandlerService().executeCommandInContext(this.command, null, provider.getContextSnapshot());
            }
            catch (Exception ex) {
                StatusUtil.handleStatus(ex, 3);
            }
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IHandlerService handlerService = (IHandlerService)window.getWorkbench().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(this.command, null);
            }
            catch (Exception ex) {
                StatusUtil.handleStatus(ex, 3);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getLabel() {
        try {
            Command nestedCommand = this.command.getCommand();
            if (nestedCommand != null && nestedCommand.getDescription() != null && nestedCommand.getDescription().length() != 0) {
                return String.valueOf(this.command.getName()) + separator + nestedCommand.getDescription();
            }
            return this.command.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return this.command.toString();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandElement other = (CommandElement)obj;
        return !(this.command == null ? other.command != null : !this.command.equals((Object)other.command));
    }
}

