/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import java.net.Authenticator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.ProxyChangeEvent;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyType;
import org.eclipse.core.internal.net.StringMatcher;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProxyManager
implements IProxyService,
IEclipsePreferences.IPreferenceChangeListener {
    private static final String PREF_HAS_MIGRATED = "org.eclipse.core.net.hasMigrated";
    private static String HTTP_PROXY_HOST = "org.eclipse.update.core.proxy.host";
    private static String HTTP_PROXY_PORT = "org.eclipse.update.core.proxy.port";
    private static String HTTP_PROXY_ENABLE = "org.eclipse.update.core.proxy.enable";
    private static final String PREF_NON_PROXIED_HOSTS = "nonProxiedHosts";
    private static final String PREF_ENABLED = "proxiesEnabled";
    private static final String PREF_OS = "systemProxiesEnabled";
    private static IProxyService proxyManager;
    private AbstractProxyProvider nativeProxyProvider;
    ListenerList listeners = new ListenerList(1);
    private String[] nonProxiedHosts;
    private final ProxyType[] proxies = new ProxyType[]{new ProxyType("HTTP"), new ProxyType("HTTPS"), new ProxyType("SOCKS")};
    private boolean migrated = false;

    private ProxyManager() {
        try {
            this.nativeProxyProvider = (AbstractProxyProvider)Class.forName("org.eclipse.core.net.ProxyProvider").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            Activator.logInfo("Problems occured during the proxy provider initialization.", e);
        }
    }

    public static synchronized IProxyService getProxyManager() {
        if (proxyManager == null) {
            proxyManager = new ProxyManager();
        }
        return proxyManager;
    }

    @Override
    public void addProxyChangeListener(IProxyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeProxyChangeListener(IProxyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireChange(final IProxyChangeEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            final IProxyChangeListener listener = (IProxyChangeListener)l[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.proxyInfoChanged(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }

    @Override
    public synchronized String[] getNonProxiedHosts() {
        this.checkMigrated();
        if (this.nonProxiedHosts == null) {
            String prop = Activator.getInstance().getPreferences().get(PREF_NON_PROXIED_HOSTS, "localhost|127.0.0.1");
            this.nonProxiedHosts = ProxyType.convertPropertyStringToHosts(prop);
        }
        if (this.nonProxiedHosts.length == 0) {
            return this.nonProxiedHosts;
        }
        String[] result = new String[this.nonProxiedHosts.length];
        System.arraycopy(this.nonProxiedHosts, 0, result, 0, this.nonProxiedHosts.length);
        return result;
    }

    @Override
    public void setNonProxiedHosts(String[] hosts) {
        this.checkMigrated();
        Assert.isNotNull((Object)hosts);
        int i = 0;
        while (i < hosts.length) {
            String host = hosts[i];
            Assert.isNotNull((Object)host);
            Assert.isTrue((host.length() > 0 ? 1 : 0) != 0);
            ++i;
        }
        String[] oldHosts = this.nonProxiedHosts;
        this.nonProxiedHosts = hosts;
        Activator.getInstance().getPreferences().put(PREF_NON_PROXIED_HOSTS, ProxyType.convertHostsToPropertyString(this.nonProxiedHosts));
        try {
            Activator.getInstance().getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("An error occurred while writing out the non-proxied hosts list", e);
        }
        IProxyData[] data = this.getProxyData();
        ProxyChangeEvent event = new ProxyChangeEvent(1, oldHosts, this.getNonProxiedHosts(), data, new IProxyData[0]);
        this.fireChange(event);
    }

    @Override
    public IProxyData[] getProxyData() {
        this.checkMigrated();
        IProxyData[] result = new IProxyData[this.proxies.length];
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            result[i] = type.getProxyData(ProxyType.VERIFY_EQUAL);
            ++i;
        }
        return result;
    }

    @Override
    public void setProxyData(IProxyData[] proxies) {
        this.checkMigrated();
        this.doSetProxyData(proxies);
    }

    private void doSetProxyData(IProxyData[] proxyDatas) {
        IProxyData[] oldData = this.getProxyData();
        String[] hosts = this.getNonProxiedHosts();
        IProxyData[] changedProxies = this.internalSetProxyData(proxyDatas);
        if (changedProxies.length > 0) {
            ProxyChangeEvent event = new ProxyChangeEvent(3, hosts, hosts, oldData, changedProxies);
            this.fireChange(event);
        }
    }

    private IProxyData[] internalSetProxyData(IProxyData[] proxyDatas) {
        ArrayList<IProxyData> result = new ArrayList<IProxyData>();
        int i = 0;
        while (i < proxyDatas.length) {
            IProxyData proxyData = proxyDatas[i];
            ProxyType type = this.getType(proxyData);
            if (type != null && type.setProxyData(proxyData, this.internalIsProxiesEnabled())) {
                result.add(proxyData);
            }
            ++i;
        }
        return result.toArray(new IProxyData[result.size()]);
    }

    private ProxyType getType(IProxyData proxyData) {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            if (type.getName().equals(proxyData.getType())) {
                return type;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isProxiesEnabled() {
        this.checkMigrated();
        return this.internalIsProxiesEnabled() && (!this.isSystemProxiesEnabled() || this.isSystemProxiesEnabled() && this.hasSystemProxies());
    }

    private boolean internalIsProxiesEnabled() {
        return Activator.getInstance().getPreferences().getBoolean(PREF_ENABLED, false);
    }

    @Override
    public void setProxiesEnabled(boolean enabled) {
        this.checkMigrated();
        boolean current = this.internalIsProxiesEnabled();
        if (current == enabled) {
            return;
        }
        Activator.getInstance().getPreferences().putBoolean(PREF_ENABLED, enabled);
    }

    private void internalSetEnabled(boolean enabled, boolean systemEnabled) {
        Properties sysProps = System.getProperties();
        sysProps.put("proxySet", enabled ? "true" : "false");
        sysProps.put("systemProxySet", systemEnabled ? "true" : "false");
        this.updateSystemProperties();
        try {
            Activator.getInstance().getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("An error occurred while writing out the enablement state", e);
        }
        String[] hosts = this.getNonProxiedHosts();
        IProxyData[] data = this.getProxyData();
        ProxyChangeEvent event = new ProxyChangeEvent(2, hosts, hosts, data, data);
        this.fireChange(event);
    }

    private void updateSystemProperties() {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            type.updateSystemProperties(this.internalGetProxyData(type.getName(), ProxyType.DO_NOT_VERIFY), this.internalIsProxiesEnabled());
            ++i;
        }
    }

    public void initialize() {
        this.checkMigrated();
        ((IEclipsePreferences)Activator.getInstance().getPreferences()).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            type.initialize(this.internalIsProxiesEnabled());
            ++i;
        }
        this.registerAuthenticator();
    }

    @Override
    public IProxyData getProxyData(String type) {
        this.checkMigrated();
        return this.internalGetProxyData(type, ProxyType.VERIFY_EQUAL);
    }

    private IProxyData internalGetProxyData(String type, int verifySystemProperties) {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType pt = this.proxies[i];
            if (pt.getName().equals(type)) {
                return pt.getProxyData(verifySystemProperties);
            }
            ++i;
        }
        return null;
    }

    @Override
    public IProxyData[] getProxyDataForHost(String host) {
        this.checkMigrated();
        if (this.hasSystemProxies() && this.isSystemProxiesEnabled()) {
            try {
                return this.nativeProxyProvider.select(new URI(host));
            }
            catch (URISyntaxException uRISyntaxException) {
                return new IProxyData[0];
            }
        }
        if (this.isHostFiltered(host)) {
            return new IProxyData[0];
        }
        IProxyData[] data = this.getProxyData();
        ArrayList<IProxyData> result = new ArrayList<IProxyData>();
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            if (proxyData.getHost() != null) {
                result.add(proxyData);
            }
            ++i;
        }
        return result.toArray(new IProxyData[result.size()]);
    }

    private boolean isHostFiltered(String host) {
        String[] filters = this.getNonProxiedHosts();
        int i = 0;
        while (i < filters.length) {
            String filter = filters[i];
            if (this.matchesFilter(host, filter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matchesFilter(String host, String filter) {
        StringMatcher matcher = new StringMatcher(filter, false, false);
        return matcher.match(host);
    }

    @Override
    public IProxyData getProxyDataForHost(String host, String type) {
        this.checkMigrated();
        if (this.hasSystemProxies() && this.isSystemProxiesEnabled()) {
            try {
                URI uri = new URI(type, "//" + host, null);
                IProxyData[] proxyDatas = this.nativeProxyProvider.select(uri);
                return proxyDatas.length > 0 ? this.nativeProxyProvider.select(uri)[0] : null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        IProxyData[] data = this.getProxyDataForHost(host);
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            if (proxyData.getType().equals(type) && proxyData.getHost() != null) {
                return proxyData;
            }
            ++i;
        }
        return null;
    }

    private void registerAuthenticator() {
        Authenticator a = this.getPluggedInAuthenticator();
        if (a != null) {
            Authenticator.setDefault(a);
        }
    }

    private Authenticator getPluggedInAuthenticator() {
        IExtension[] extensions = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.net", "authenticator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            Activator.log(4, NLS.bind((String)"Authenticator {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (Authenticator)config.createExecutableExtension("class");
        }
        catch (CoreException ex) {
            Activator.log(4, NLS.bind((String)"Unable to instantiate authenticator {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    private synchronized void checkMigrated() {
        if (this.migrated || !Activator.getInstance().instanceLocationAvailable()) {
            return;
        }
        this.migrated = true;
        if (Activator.getInstance().getPreferences().getBoolean(PREF_HAS_MIGRATED, false)) {
            return;
        }
        Activator.getInstance().getPreferences().putBoolean(PREF_HAS_MIGRATED, true);
        this.migrateInstanceScopePreferences((Preferences)new InstanceScope().getNode(""), (Preferences)new ConfigurationScope().getNode(""), true);
    }

    void migrateInstanceScopePreferences(Preferences instanceNode, Preferences configurationNode, boolean isInitialize) {
        String instanceNonProxiedHosts;
        String instanceEnabled;
        this.migrateUpdateHttpProxy(instanceNode, isInitialize);
        Preferences netInstancePrefs = instanceNode.node("org.eclipse.core.net");
        Preferences netConfigurationPrefs = configurationNode.node("org.eclipse.core.net");
        if (netConfigurationPrefs.get(PREF_ENABLED, null) == null && (instanceEnabled = netInstancePrefs.get(PREF_ENABLED, null)) != null) {
            netConfigurationPrefs.put(PREF_ENABLED, instanceEnabled);
        }
        if (netConfigurationPrefs.get(PREF_OS, null) == null && (instanceEnabled = netInstancePrefs.get(PREF_OS, null)) != null) {
            netConfigurationPrefs.put(PREF_OS, instanceEnabled);
        }
        if (netConfigurationPrefs.get(PREF_NON_PROXIED_HOSTS, null) == null && (instanceNonProxiedHosts = netInstancePrefs.get(PREF_NON_PROXIED_HOSTS, null)) != null) {
            netConfigurationPrefs.put(PREF_NON_PROXIED_HOSTS, instanceNonProxiedHosts);
            this.nonProxiedHosts = null;
        }
        boolean proxiesEnabled = netConfigurationPrefs.getBoolean(PREF_ENABLED, false);
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType instanceType;
            IProxyData instanceData;
            ProxyType type = this.proxies[i];
            IProxyData data = type.getProxyData(ProxyType.DO_NOT_VERIFY);
            if (data.getHost() == null && (instanceData = (instanceType = new ProxyType(type.getName(), netInstancePrefs)).getProxyData(ProxyType.DO_NOT_VERIFY)).getHost() != null) {
                type.setProxyData(instanceData, proxiesEnabled);
            }
            ++i;
        }
        if (!isInitialize) {
            try {
                netInstancePrefs.removeNode();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private void migrateUpdateHttpProxy(Preferences node, boolean isInitialize) {
        Preferences netPrefs = node.node("org.eclipse.core.net");
        if (!netPrefs.getBoolean(PREF_HAS_MIGRATED, false)) {
            if (isInitialize) {
                netPrefs.putBoolean(PREF_HAS_MIGRATED, true);
            }
            Preferences updatePrefs = node.node("org.eclipse.update.core");
            String httpProxyHost = this.getHostToMigrate(updatePrefs, isInitialize);
            int port = this.getPortToMigrate(updatePrefs, isInitialize);
            boolean httpProxyEnable = this.getEnablementToMigrate(updatePrefs, isInitialize);
            if (httpProxyHost != null) {
                ProxyData proxyData = new ProxyData("HTTP", httpProxyHost, port, false);
                ProxyType type = this.getType(proxyData);
                type.updatePreferencesIfMissing(netPrefs, proxyData);
                if (httpProxyEnable) {
                    netPrefs.putBoolean(PREF_ENABLED, true);
                }
            }
        }
    }

    private boolean getEnablementToMigrate(Preferences updatePrefs, boolean checkSystemProperties) {
        boolean httpProxyEnable = false;
        if (checkSystemProperties && updatePrefs.get(HTTP_PROXY_ENABLE, null) == null) {
            httpProxyEnable = Boolean.getBoolean("http.proxySet");
        } else {
            httpProxyEnable = updatePrefs.getBoolean(HTTP_PROXY_ENABLE, false);
            updatePrefs.remove(HTTP_PROXY_ENABLE);
        }
        return httpProxyEnable;
    }

    private int getPortToMigrate(Preferences updatePrefs, boolean checkSystemProperties) {
        String httpProxyPort = updatePrefs.get(HTTP_PROXY_PORT, "");
        if (checkSystemProperties && "".equals(httpProxyPort)) {
            httpProxyPort = System.getProperty("http.proxyPort", "");
        }
        updatePrefs.remove(HTTP_PROXY_PORT);
        int port = -1;
        if (httpProxyPort != null && !"".equals(httpProxyPort)) {
            try {
                port = Integer.parseInt(httpProxyPort);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return port;
    }

    private String getHostToMigrate(Preferences updatePrefs, boolean checkSystemProperties) {
        String httpProxyHost = updatePrefs.get(HTTP_PROXY_HOST, "");
        if (checkSystemProperties && "".equals(httpProxyHost)) {
            httpProxyHost = System.getProperty("http.proxyHost", "");
        }
        if ("".equals(httpProxyHost)) {
            httpProxyHost = null;
        }
        updatePrefs.remove(HTTP_PROXY_HOST);
        return httpProxyHost;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(PREF_ENABLED) || event.getKey().equals(PREF_OS)) {
            this.checkMigrated();
            this.internalSetEnabled(Activator.getInstance().getPreferences().getBoolean(PREF_ENABLED, false), Activator.getInstance().getPreferences().getBoolean(PREF_OS, false));
        }
    }

    @Override
    public boolean hasSystemProxies() {
        return this.nativeProxyProvider != null;
    }

    @Override
    public boolean isSystemProxiesEnabled() {
        this.checkMigrated();
        return Activator.getInstance().getPreferences().getBoolean(PREF_OS, false);
    }

    @Override
    public void setSystemProxiesEnabled(boolean enabled) {
        this.checkMigrated();
        boolean current = this.isSystemProxiesEnabled();
        if (current == enabled) {
            return;
        }
        Activator.getInstance().getPreferences().putBoolean(PREF_OS, enabled);
    }
}

