/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ImportPackageSpecificationImpl
extends VersionConstraintImpl
implements ImportPackageSpecification {
    private String resolution = "static";
    private String symbolicName;
    private VersionRange bundleVersionRange;
    private Map attributes;

    @Override
    public Map getDirectives() {
        HashMap<String, String> result = new HashMap<String, String>(5);
        if (this.resolution != null) {
            result.put("resolution", this.resolution);
        }
        return result;
    }

    @Override
    public Object getDirective(String key) {
        if (key.equals("resolution")) {
            return this.resolution;
        }
        return null;
    }

    public Object setDirective(String key, Object value) {
        if (key.equals("resolution")) {
            this.resolution = (String)value;
            return this.resolution;
        }
        return null;
    }

    public void setDirectives(Map directives) {
        if (directives == null) {
            return;
        }
        this.resolution = (String)directives.get("resolution");
    }

    @Override
    public String getBundleSymbolicName() {
        if ("system.bundle".equals(this.symbolicName)) {
            StateImpl state = (StateImpl)this.getBundle().getContainingState();
            return state == null ? Constants.getInternalSymbolicName() : state.getSystemBundle();
        }
        return this.symbolicName;
    }

    @Override
    public VersionRange getBundleVersionRange() {
        if (this.bundleVersionRange == null) {
            return VersionRange.emptyRange;
        }
        return this.bundleVersionRange;
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription supplier) {
        String[] mandatory;
        String name;
        String exporterSymbolicName;
        if (!(supplier instanceof ExportPackageDescription)) {
            return false;
        }
        ExportPackageDescriptionImpl pkgDes = (ExportPackageDescriptionImpl)supplier;
        String[] friends = (String[])pkgDes.getDirective("x-friends");
        Boolean internal = (Boolean)pkgDes.getDirective("x-internal");
        if (internal.booleanValue() || friends != null) {
            boolean strict;
            StateImpl state = (StateImpl)this.getBundle().getContainingState();
            boolean bl = strict = state == null ? false : state.inStrictMode();
            if (strict) {
                if (internal.booleanValue()) {
                    return false;
                }
                boolean found = false;
                if (friends != null && this.getBundle().getSymbolicName() != null) {
                    int i = 0;
                    while (i < friends.length) {
                        if (this.getBundle().getSymbolicName().equals(friends[i])) {
                            found = true;
                        }
                        ++i;
                    }
                }
                if (!found) {
                    return false;
                }
            }
        }
        if ((exporterSymbolicName = this.getBundleSymbolicName()) != null) {
            BundleDescription exporter = pkgDes.getExporter();
            if (!exporterSymbolicName.equals(exporter.getSymbolicName())) {
                return false;
            }
            if (this.getBundleVersionRange() != null && !this.getBundleVersionRange().isIncluded(exporter.getVersion())) {
                return false;
            }
        }
        if (!("*".equals(name = this.getName()) || name.endsWith(".*") && pkgDes.getName().startsWith(name.substring(0, name.length() - 1)) || pkgDes.getName().equals(name))) {
            return false;
        }
        if (this.getVersionRange() != null && !this.getVersionRange().isIncluded(pkgDes.getVersion())) {
            return false;
        }
        Map importAttrs = this.getAttributes();
        if (importAttrs != null) {
            Map exportAttrs = pkgDes.getAttributes();
            if (exportAttrs == null) {
                return false;
            }
            for (String importKey : importAttrs.keySet()) {
                Object importValue = importAttrs.get(importKey);
                Object exportValue = exportAttrs.get(importKey);
                if (exportValue != null && importValue.equals(exportValue)) continue;
                return false;
            }
        }
        if ((mandatory = (String[])pkgDes.getDirective("mandatory")) != null) {
            int i = 0;
            while (i < mandatory.length) {
                if ("bundle-symbolic-name".equals(mandatory[i])) {
                    if (exporterSymbolicName == null) {
                        return false;
                    }
                } else if ("bundle-version".equals(mandatory[i])) {
                    if (this.bundleVersionRange == null) {
                        return false;
                    }
                } else if ("specification-version".equals(mandatory[i]) || "version".equals(mandatory[i])) {
                    if (this.getVersionRange() == null) {
                        return false;
                    }
                } else {
                    if (importAttrs == null) {
                        return false;
                    }
                    if (importAttrs.get(mandatory[i]) == null) {
                        return false;
                    }
                }
                ++i;
            }
        }
        if (((BundleDescriptionImpl)this.getBundle()).getEquinoxEE() < 0) {
            return true;
        }
        int eeIndex = (Integer)pkgDes.getDirective("x-equinox-ee");
        return eeIndex < 0 || eeIndex == ((BundleDescriptionImpl)this.getBundle()).getEquinoxEE();
    }

    protected void setBundleSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void setBundleVersionRange(VersionRange bundleVersionRange) {
        this.bundleVersionRange = bundleVersionRange;
    }

    protected void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return "Import-Package: " + this.getName() + "; version=\"" + this.getVersionRange() + "\"";
    }
}

