/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class FilteredServiceListener
implements ServiceListener {
    private final FilterImpl filter;
    private final ServiceListener listener;
    private final BundleContextImpl context;
    private final boolean allservices;
    private final String objectClass;

    protected FilteredServiceListener(String filterstring, ServiceListener listener, BundleContextImpl context) throws InvalidSyntaxException {
        if (filterstring == null) {
            this.filter = null;
            this.objectClass = null;
        } else {
            FilterImpl filterImpl = new FilterImpl(filterstring);
            String clazz = filterImpl.getRequiredObjectClass();
            if (clazz == null) {
                this.objectClass = null;
                this.filter = filterImpl;
            } else {
                this.objectClass = clazz.intern();
                String objectClassFilter = FilterImpl.getObjectClassFilterString(this.objectClass);
                this.filter = objectClassFilter.equals(filterstring) ? null : filterImpl;
            }
        }
        this.listener = listener;
        this.context = context;
        this.allservices = listener instanceof AllServiceListener;
    }

    @Override
    public void serviceChanged(ServiceEvent event) {
        String listenerName;
        ServiceReferenceImpl reference;
        block7: {
            reference = (ServiceReferenceImpl)event.getServiceReference();
            if (this.objectClass != null) {
                String[] classes = reference.getClasses();
                int size = classes.length;
                int i = 0;
                while (i < size) {
                    if (classes[i] != this.objectClass) {
                        ++i;
                        continue;
                    }
                    break block7;
                }
                return;
            }
        }
        if (!this.context.hasListenServicePermission(event)) {
            return;
        }
        if (Debug.DEBUG_EVENTS) {
            listenerName = String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this));
            Debug.println("filterServiceEvent(" + listenerName + ", \"" + this.filter + "\", " + reference.registration.getProperties() + ")");
        }
        if ((this.filter == null || this.filter.match(reference)) && (this.allservices || this.context.isAssignableTo(reference))) {
            if (Debug.DEBUG_EVENTS) {
                listenerName = String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this.listener));
                Debug.println("dispatchFilteredServiceEvent(" + listenerName + ")");
            }
            this.listener.serviceChanged(event);
        }
    }

    public String toString() {
        return this.filter == null ? this.listener.toString() : this.filter.toString();
    }
}

