/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleHost
extends AbstractBundle {
    private BundleLoaderProxy proxy;
    protected BundleContextImpl context = null;
    protected BundleFragment[] fragments = null;

    public BundleHost(BundleData bundledata, Framework framework) throws BundleException {
        super(bundledata, framework);
    }

    @Override
    protected void load() {
        SecurityManager sm;
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.load called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.proxy != null) {
                Debug.println("Bundle.load called when proxy != null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        if (this.framework.isActive() && (sm = System.getSecurityManager()) != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        this.proxy = null;
    }

    @Override
    protected boolean reload(AbstractBundle newBundle) {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy = this.getLoaderProxy();
                exporting = curProxy.inUse();
                if (exporting) {
                    curProxy.getBundleLoader().createClassLoader();
                } else {
                    BundleHost.closeBundleLoader(this.proxy);
                }
                this.state = 2;
                this.proxy = null;
                this.fragments = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        return exporting;
    }

    @Override
    protected void refresh() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.reload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            BundleHost.closeBundleLoader(this.proxy);
            this.proxy = null;
            this.fragments = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    @Override
    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive() && this.state == 4) {
            BundleLoaderProxy curProxy = this.getLoaderProxy();
            exporting = curProxy.inUse();
            if (exporting) {
                curProxy.getBundleLoader().createClassLoader();
            } else {
                BundleHost.closeBundleLoader(this.proxy);
            }
            this.state = 2;
            this.proxy = null;
            this.fragments = null;
            this.domain = null;
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    private BundleLoader checkLoader() {
        BundleLoader loader;
        this.checkValid();
        if (!this.isResolved() && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
            return null;
        }
        if (Debug.DEBUG_GENERAL && (this.state & 0x3C) == 0) {
            Debug.println("Bundle.checkLoader() called when state != STARTING | ACTIVE | STOPPING | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if ((loader = this.getBundleLoader()) == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.checkLoader() called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return loader;
    }

    @Override
    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        BundleLoader loader;
        if (checkPermission) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException();
            }
        }
        if ((loader = this.checkLoader()) == null) {
            throw new ClassNotFoundException(NLS.bind(Msg.BUNDLE_CNFE_NOT_RESOLVED, name, this.getBundleData().getLocation()));
        }
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (!(e instanceof StatusException) && (this.bundledata.getStatus() & 2) != 0 && !this.testStateChanging(Thread.currentThread())) {
                try {
                    this.framework.secureAction.start(this, 1);
                }
                catch (BundleException be) {
                    this.framework.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, be.getMessage(), 0, be, null));
                }
            }
            throw e;
        }
    }

    @Override
    public URL getResource(String name) {
        BundleLoader loader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        loader = this.checkLoader();
        if (loader == null) {
            return null;
        }
        return loader.findResource(name);
    }

    @Override
    public Enumeration getResources(String name) throws IOException {
        BundleLoader loader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        loader = this.checkLoader();
        if (loader == null) {
            return null;
        }
        Enumeration result = loader.getResources(name);
        if (result != null && result.hasMoreElements()) {
            return result;
        }
        return null;
    }

    @Override
    protected void startWorker(int options) throws BundleException {
        if ((options & 1) == 0) {
            this.setStatus(1, true);
            this.setStatus(4, (options & 2) != 0);
            if (Debug.MONITOR_ACTIVATION) {
                new Exception("A persistent start has been called on bundle: " + this.getBundleData()).printStackTrace();
            }
        }
        if (!this.framework.active || (this.state & 0x20) != 0) {
            return;
        }
        if (this.state == 2 && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
            throw new BundleException(this.getResolutionFailureMessage());
        }
        if (this.getStartLevel() > this.framework.startLevelManager.getStartLevel()) {
            if ((options & 1) != 0) {
                String msg = NLS.bind(Msg.BUNDLE_TRANSIENT_START_ERROR, this);
                throw new BundleException(msg, new AbstractBundle.BundleStatusException(msg, 4, this));
            }
            return;
        }
        if ((options & 2) != 0 && (this.bundledata.getStatus() & 2) != 0) {
            if ((this.state & 4) != 0) {
                this.state = 8;
                this.framework.publishBundleEvent(512, this);
            }
            return;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Bundle: Active sl = " + this.framework.startLevelManager.getStartLevel() + "; Bundle " + this.getBundleId() + " sl = " + this.getStartLevel());
        }
        this.state = 8;
        this.framework.publishBundleEvent(128, this);
        this.context = this.getContext();
        long start = 0L;
        BundleWatcher bundleStats = this.framework.adaptor.getBundleWatcher();
        if (bundleStats != null) {
            bundleStats.watchBundle(this, 4);
        }
        if (Debug.DEBUG_BUNDLE_TIME) {
            start = System.currentTimeMillis();
            System.out.println("Starting " + this.getSymbolicName());
        }
        try {
            try {
                this.context.start();
                if (this.framework.active) {
                    this.state = 32;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("->started " + this);
                    }
                    this.framework.publishBundleEvent(2, this);
                }
            }
            catch (BundleException e) {
                this.state = 16;
                this.framework.publishBundleEvent(256, this);
                this.context.close();
                this.context = null;
                this.state = 4;
                this.framework.publishBundleEvent(4, this);
                throw e;
            }
        }
        finally {
            BundleWatcher bundleStats2 = this.framework.adaptor.getBundleWatcher();
            if (bundleStats2 != null) {
                bundleStats2.watchBundle(this, 8);
            }
            if (Debug.DEBUG_BUNDLE_TIME) {
                System.out.println("End starting " + this.getSymbolicName() + " " + (System.currentTimeMillis() - start));
            }
        }
        if (this.state == 1) {
            this.context.close();
            this.context = null;
            throw new BundleException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
    }

    @Override
    protected boolean readyToResume() {
        if (this.getStartLevel() > this.framework.startLevelManager.getStartLevel()) {
            return false;
        }
        int status = this.bundledata.getStatus();
        if ((status & 1) == 0) {
            return false;
        }
        if ((status & 4) == 0 || (status & 2) == 0) {
            return true;
        }
        if (!this.isResolved()) {
            return false;
        }
        this.state = 8;
        this.framework.publishBundleEvent(512, this);
        return false;
    }

    protected BundleContextImpl createContext() {
        return new BundleContextImpl(this);
    }

    @Override
    protected synchronized BundleContextImpl getContext() {
        if (this.context == null && (this.state & 0x38) != 0) {
            this.context = this.createContext();
        }
        return this.context;
    }

    @Override
    protected void stopWorker(int options) throws BundleException {
        if ((options & 1) == 0) {
            this.setStatus(1, false);
            this.setStatus(4, false);
            if (Debug.MONITOR_ACTIVATION) {
                new Exception("A persistent start has been called on bundle: " + this.getBundleData()).printStackTrace();
            }
        }
        if (this.framework.active) {
            if ((this.state & 0x16) != 0) {
                return;
            }
            BundleWatcher bundleStats = this.framework.adaptor.getBundleWatcher();
            if (bundleStats != null) {
                bundleStats.watchBundle(this, 16);
            }
            this.state = 16;
            this.framework.publishBundleEvent(256, this);
            try {
                if (this.context != null) {
                    this.context.stop();
                }
            }
            finally {
                if (this.context != null) {
                    this.context.close();
                    this.context = null;
                }
                this.checkValid();
                this.state = 4;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("->stopped " + this);
                }
                this.framework.publishBundleEvent(4, this);
                BundleWatcher bundleStats2 = this.framework.adaptor.getBundleWatcher();
                if (bundleStats2 != null) {
                    bundleStats2.watchBundle(this, 32);
                }
            }
        }
    }

    @Override
    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getRegisteredServices();
    }

    @Override
    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getServicesInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Bundle[] getFragments() {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            block4: {
                if (this.fragments != null) break block4;
                return null;
            }
            Bundle[] result = new Bundle[this.fragments.length];
            System.arraycopy(this.fragments, 0, result, 0, result.length);
            return result;
        }
    }

    protected void attachFragment(BundleFragment fragment) throws BundleException {
        BundleLoader loader = this.getLoaderProxy().getBasicBundleLoader();
        if (loader != null) {
            loader.attachFragment(fragment);
        }
        if (this.fragments == null) {
            this.fragments = new BundleFragment[]{fragment};
        } else {
            boolean inserted = false;
            BundleFragment[] newFragments = new BundleFragment[this.fragments.length + 1];
            int i = 0;
            while (i < this.fragments.length) {
                if (fragment == this.fragments[i]) {
                    return;
                }
                if (!inserted && fragment.getBundleId() < this.fragments[i].getBundleId()) {
                    if (loader != null) {
                        throw new BundleException(NLS.bind(Msg.BUNDLE_LOADER_ATTACHMENT_ERROR, this.fragments[i].getSymbolicName(), this.getSymbolicName()));
                    }
                    newFragments[i] = fragment;
                    inserted = true;
                }
                newFragments[inserted ? i + 1 : i] = this.fragments[i];
                ++i;
            }
            if (!inserted) {
                newFragments[newFragments.length - 1] = fragment;
            }
            this.fragments = newFragments;
        }
        this.manifestLocalization = null;
    }

    @Override
    protected BundleLoader getBundleLoader() {
        BundleLoaderProxy curProxy = this.getLoaderProxy();
        return curProxy == null ? null : curProxy.getBundleLoader();
    }

    protected synchronized BundleLoaderProxy getLoaderProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return null;
        }
        this.proxy = new BundleLoaderProxy(this, bundleDescription);
        bundleDescription.setUserObject(this.proxy);
        return this.proxy;
    }

    static void closeBundleLoader(BundleLoaderProxy proxy) {
        if (proxy == null) {
            return;
        }
        BundleLoader loader = proxy.getBasicBundleLoader();
        if (loader != null) {
            loader.close();
        }
        proxy.setStale();
        BundleDescription description = proxy.getBundleDescription();
        description.setUserObject(null);
    }
}

