/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.database.xindice;

import java.util.ArrayList;
import jp.sourceforge.concierge.database.CommonBuffer;
import jp.sourceforge.concierge.database.DOMPacket;
import jp.sourceforge.concierge.database.IDatabaseAdapter;
import jp.sourceforge.concierge.database.cache.DomCache;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateType;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.mdocument.IDocumentService;
import org.apache.xindice.client.xmldb.services.CollectionManager;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XindiceAdapter
implements IDatabaseAdapter,
IDocumentService,
Runnable {
    private Object sLock = new Object();
    private Thread thread = null;
    private Collection collection = null;
    private DomCache cache = null;
    private CommonBuffer combuf = new CommonBuffer();
    private ArrayList<ICCGUpdateListener> listeners = new ArrayList();
    private boolean threadon = true;
    private static /* synthetic */ int[] $SWITCH_TABLE$jp$sourceforge$concierge$event$CCGUpdateType;

    public XindiceAdapter(Collection col) {
        this.collection = col;
        this.cache = new DomCache();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public String getCollectionName() {
        try {
            return this.collection.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection getCollection() {
        return this.collection;
    }

    private void appendNoCache(ArrayList<Document> docs) throws Exception {
        int i = 0;
        while (i < docs.size()) {
            Document cdoc = docs.get(i);
            XMLResource document = (XMLResource)this.collection.createResource(null, "XMLResource");
            document.setContentAsDOM((Node)cdoc);
            this.collection.storeResource((Resource)document);
            String docid = document.getDocumentId();
            cdoc.getDocumentElement().setAttribute("ccgkey", docid);
            this.cache.add(docid, (Object)cdoc);
            ++i;
        }
    }

    private void updateNoCache(ArrayList<Document> docs) throws Exception {
        int i = 0;
        while (i < docs.size()) {
            Document cdoc = docs.get(i);
            String docid = cdoc.getDocumentElement().getAttribute("ccgkey");
            if (docid != null && docid.length() > 0) {
                this.collection.removeResource(this.collection.getResource(docid));
                this.cache.delete(docid);
            }
            XMLResource document = (XMLResource)this.collection.createResource(null, "XMLResource");
            document.setContentAsDOM((Node)cdoc);
            this.collection.storeResource((Resource)document);
            String ndocid = document.getDocumentId();
            cdoc.getDocumentElement().setAttribute("ccgkey", document.getDocumentId());
            this.cache.add(ndocid, (Object)cdoc);
            ++i;
        }
    }

    private void deleteNoCache(ArrayList<Document> docs) throws Exception {
        int i = 0;
        while (i < docs.size()) {
            String docid = docs.get(i).getDocumentElement().getAttribute("ccgkey");
            if (docid != null && docid.length() != 0) {
                this.collection.removeResource(this.collection.getResource(docid));
                this.cache.delete(docid);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<XMLResource> queryNoCache(String xpath) {
        try {
            XPathQueryService service = (XPathQueryService)this.collection.getService("XPathQueryService", "1.0");
            ArrayList<XMLResource> list = null;
            Object object = this.sLock;
            synchronized (object) {
                ResourceSet resultSet = service.query(xpath);
                list = new ArrayList<XMLResource>((int)resultSet.getSize());
                ResourceIterator results = resultSet.getIterator();
                while (results.hasMoreResources()) {
                    XMLResource res = (XMLResource)results.nextResource();
                    res = (XMLResource)this.collection.getResource(res.getDocumentId());
                    list.add(res);
                }
            }
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(ArrayList<Document> documents, Object sender) {
        try {
            Object object = this.sLock;
            synchronized (object) {
                ArrayList<DOMPacket> plist = new ArrayList<DOMPacket>();
                plist.add(new DOMPacket(documents, CCGUpdateType.ADD_DOCUMENT, sender));
                this.combuf.setObjects(plist);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(ArrayList<Document> documents, Object sender) {
        try {
            Object object = this.sLock;
            synchronized (object) {
                ArrayList<DOMPacket> plist = new ArrayList<DOMPacket>();
                plist.add(new DOMPacket(documents, CCGUpdateType.DEL_DOCUMENT, sender));
                this.combuf.setObjects(plist);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ArrayList<Document> documents, Object sender) {
        try {
            Object object = this.sLock;
            synchronized (object) {
                ArrayList<DOMPacket> plist = new ArrayList<DOMPacket>();
                plist.add(new DOMPacket(documents, CCGUpdateType.UPD_DOCUMENT, sender));
                this.combuf.setObjects(plist);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Document> query(String xpath) {
        ArrayList<Document> list = null;
        try {
            Object object = this.sLock;
            synchronized (object) {
                ArrayList<XMLResource> xrl = this.queryNoCache(xpath);
                list = new ArrayList<Document>(xrl.size());
                int i = 0;
                while (i < xrl.size()) {
                    XMLResource xr = xrl.get(i);
                    String rid = xr.getDocumentId();
                    Document doc = (Document)this.cache.query(rid);
                    if (doc == null) {
                        doc = this.convertFromData(xr);
                        this.cache.add(rid, (Object)doc);
                    }
                    list.add(doc);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return list;
    }

    public boolean documentExists(long id) {
        ArrayList<XMLResource> list = this.queryNoCache("/*[@id='" + id + "']");
        return list.size() > 0;
    }

    public void close() {
        block4: {
            try {
                this.threadon = false;
                this.thread.join();
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) break block4;
                System.err.println(msg);
            }
        }
        try {
            this.collection.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        col = this.getCollectionName();
        while (this.threadon || this.combuf.getCount() > 0) {
            packets = this.combuf.getAllOjects();
            if (packets == null) continue;
            i = 0;
            while (i < packets.size()) {
                block12: {
                    dp = (DOMPacket)packets.get(i);
                    try {
                        switch (XindiceAdapter.$SWITCH_TABLE$jp$sourceforge$concierge$event$CCGUpdateType()[dp.type.ordinal()]) {
                            case 1: {
                                this.appendNoCache(dp.documents);
                                break;
                            }
                            case 2: {
                                this.deleteNoCache(dp.documents);
                                break;
                            }
                            case 3: {
                                this.updateNoCache(dp.documents);
                            }
                        }
                        j = 0;
                        while (j < this.listeners.size()) {
                            this.listeners.get(j).updated(new CCGUpdateEvent(dp.type, Boolean.valueOf(true), dp.sender, col, dp.documents));
                            ++j;
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        j = 0;
                        ** while (j < this.listeners.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.listeners.get(j).updated(new CCGUpdateEvent(dp.type, Boolean.valueOf(false), dp.sender, col, dp.documents));
                        ++j;
                        continue;
                    }
lbl30:
                    // 1 sources

                    msg = e.getMessage();
                    if (msg != null) {
                        System.err.println(msg);
                    }
                }
                ++i;
            }
            if (packets.size() <= 0) continue;
            System.err.print("Auto save:");
            System.err.println(String.valueOf(new Integer(packets.size()).toString()) + "items");
        }
    }

    public void addListener(ICCGUpdateListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ICCGUpdateListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public Document convertFromData(Object obj) {
        XMLResource res = (XMLResource)obj;
        try {
            Document doc = (Document)res.getContentAsDOM();
            doc.getDocumentElement().setAttribute("ccgkey", res.getDocumentId());
            return doc;
        }
        catch (XMLDBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object convertToData(Document doc) {
        try {
            XMLResource document = (XMLResource)this.collection.createResource(null, "XMLResource");
            document.setContentAsDOM((Node)doc);
            return document;
        }
        catch (XMLDBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addIndex(String name, String pattern) {
        try {
            CollectionManager cm = (CollectionManager)this.collection.getService("CollectionManager", "1.0");
            String[] ids = cm.listIndexers();
            int i = 0;
            while (i < ids.length) {
                if (ids[i].compareTo(name) == 0) {
                    return;
                }
                ++i;
            }
            DocumentImpl doc = new DocumentImpl();
            Element top = doc.createElement("index");
            top.setAttribute("class", "org.apache.xindice.core.indexer.ValueIndexer");
            top.setAttribute("name", name);
            top.setAttribute("pattern", pattern);
            doc.appendChild(top);
            cm.createIndexer((Document)doc);
        }
        catch (XMLDBException e) {
            System.err.println(e.getMessage());
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$jp$sourceforge$concierge$event$CCGUpdateType() {
        if ($SWITCH_TABLE$jp$sourceforge$concierge$event$CCGUpdateType != null) {
            return $SWITCH_TABLE$jp$sourceforge$concierge$event$CCGUpdateType;
        }
        int[] nArray = new int[CCGUpdateType.values().length];
        try {
            nArray[CCGUpdateType.ADD_DOCUMENT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CCGUpdateType.DEL_DOCUMENT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CCGUpdateType.UPD_DOCUMENT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$jp$sourceforge$concierge$event$CCGUpdateType = nArray;
        return nArray;
    }
}

