/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api.sdk.modules;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.sdk.modules.BaseResource;
import org.xmldb.api.sdk.modules.SetContentHandler;

public abstract class SimpleXMLResource
extends BaseResource
implements XMLResource {
    protected String content = null;
    protected String documentID = null;
    protected XMLReader xmlReader;

    public SimpleXMLResource(Collection collection, String string, String string2) {
        this(collection, string, string2, null);
    }

    public SimpleXMLResource(Collection collection, String string, String string2, String string3) {
        super(collection, string);
        this.content = string3;
        this.documentID = string2;
    }

    public String getDocumentId() throws XMLDBException {
        return this.documentID;
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    public Object getContent() throws XMLDBException {
        return this.content;
    }

    public void setContent(Object object) throws XMLDBException {
        if (!(object instanceof String)) {
            throw new XMLDBException(3);
        }
        this.content = (String)object;
    }

    public Node getContentAsDOM() throws XMLDBException {
        if (this.content == null) {
            throw new XMLDBException(301);
        }
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(new InputSource(new StringReader(this.content)));
            return dOMParser.getDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setContentAsDOM(Node node) throws XMLDBException {
        try {
            OutputFormat outputFormat = new OutputFormat();
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            switch (node.getNodeType()) {
                case 9: {
                    xMLSerializer.serialize((Document)node);
                    break;
                }
                case 1: {
                    xMLSerializer.serialize((Element)node);
                    break;
                }
                case 11: {
                    xMLSerializer.serialize((DocumentFragment)node);
                }
            }
            this.content = stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void getContentAsSAX(ContentHandler contentHandler) throws XMLDBException {
        try {
            XMLReader xMLReader = this.getSAXParser();
            xMLReader.setContentHandler(contentHandler);
            xMLReader.setErrorHandler((ErrorHandler)((Object)contentHandler));
            if (this.content != null) {
                xMLReader.parse(new InputSource(new StringReader(this.content)));
            }
        }
        catch (Exception exception) {
            throw new XMLDBException(0, (Throwable)exception);
        }
    }

    private XMLReader getSAXParser() {
        if (this.xmlReader == null) {
            this.xmlReader = new SAXParser();
        }
        return this.xmlReader;
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        return new SetContentHandler(this);
    }

    public void setSAXFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        XMLReader xMLReader = this.getSAXParser();
        xMLReader.setFeature(string, bl);
    }

    public boolean getSAXFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        XMLReader xMLReader = this.getSAXParser();
        return xMLReader.getFeature(string);
    }
}

