/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.introspection;

import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.introspection.Collection;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends ExtensionPoint {
    private String title;
    List<Collection> collections = new ArrayList<Collection>();

    public Workspace(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(1);
        arrayList.add(new XmlWriter.Attribute("title", this.title));
        xmlWriter.startElement(Namespaces.atomPubNs, "workspace", arrayList, null);
        xmlWriter.startRepeatingElement();
        for (Collection collection : this.collections) {
            collection.generate(xmlWriter, extensionProfile);
        }
        xmlWriter.endRepeatingElement();
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.atomPubNs, "workspace");
    }

    public void processEndElement() throws ParseException {
        if (this.collections.size() == 0) {
            throw new ParseException("Workspace must contain at least one collection");
        }
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extensionProfile) throws IOException {
            super(extensionProfile, Workspace.class);
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (string.equals("http://purl.org/atom/app#")) {
                if (string2.equals("collection")) {
                    String string3 = attributes.getValue("", "href");
                    if (string3 == null) {
                        throw new ParseException("href missing for app:collection element");
                    }
                    Collection collection = new Collection(string3);
                    Workspace.this.collections.add(collection);
                    Collection collection2 = collection;
                    collection2.getClass();
                    return collection2.new Collection.Handler(this.extProfile);
                }
                throw new ParseException("Unrecognized element: namespace: " + string + ",localName: " + string2);
            }
            return super.getChildHandler(string, string2, attributes);
        }
    }
}

