/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ValidatingExtension;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlNamespace;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.base.Pair;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionPoint {
    private Map<Class, Extension> nonRepeatingExtensionMap = new HashMap<Class, Extension>();
    private Map<Class, List<Extension>> repeatingExtensionMap = new HashMap<Class, List<Extension>>();
    protected XmlBlob xmlBlob = new XmlBlob();
    private Manifest manifest;

    public ExtensionPoint() {
    }

    protected ExtensionPoint(ExtensionPoint extensionPoint) {
        this.nonRepeatingExtensionMap = extensionPoint.nonRepeatingExtensionMap;
        this.repeatingExtensionMap = extensionPoint.repeatingExtensionMap;
        this.xmlBlob = extensionPoint.xmlBlob;
        this.manifest = extensionPoint.manifest;
    }

    public void declareExtensions(ExtensionProfile extensionProfile) {
    }

    public <T extends Extension> T getExtension(Class<T> clazz) {
        return (T)this.nonRepeatingExtensionMap.get(clazz);
    }

    public <T extends Extension> List<T> getRepeatingExtension(Class<T> clazz) {
        List<Extension> list = this.repeatingExtensionMap.get(clazz);
        if (list == null) {
            list = new ArrayList<Extension>();
            this.repeatingExtensionMap.put(clazz, list);
        }
        return list;
    }

    private boolean addExtension(Extension extension, Class clazz) {
        if (this.nonRepeatingExtensionMap.containsKey(clazz)) {
            return false;
        }
        this.nonRepeatingExtensionMap.put(clazz, extension);
        return true;
    }

    public void addExtension(Extension extension) {
        this.addExtension(extension, extension.getClass());
    }

    public void setExtension(Extension extension) {
        this.nonRepeatingExtensionMap.remove(extension.getClass());
        this.addExtension(extension, extension.getClass());
    }

    private void addRepeatingExtension(Extension extension, Class clazz) {
        List<Extension> list = this.repeatingExtensionMap.get(clazz);
        if (list == null) {
            list = new ArrayList<Extension>();
        }
        list.add(extension);
        this.repeatingExtensionMap.put(clazz, list);
    }

    public void addRepeatingExtension(Extension extension) {
        this.addRepeatingExtension(extension, extension.getClass());
    }

    public void removeExtension(Extension extension) {
        this.nonRepeatingExtensionMap.remove(extension.getClass());
    }

    public void removeExtension(Class clazz) {
        this.nonRepeatingExtensionMap.remove(clazz);
    }

    public void removeRepeatingExtension(Extension extension) {
        List<Extension> list = this.repeatingExtensionMap.get(extension.getClass());
        if (list == null) {
            return;
        }
        list.remove(extension);
    }

    public XmlBlob getXmlBlob() {
        return this.xmlBlob;
    }

    public void setXmlBlob(XmlBlob xmlBlob) {
        this.xmlBlob = xmlBlob;
    }

    public XmlBlob generateCumulativeXmlBlob(ExtensionProfile extensionProfile) throws IOException {
        XmlBlob xmlBlob = new XmlBlob();
        List<XmlNamespace> list = xmlBlob.getNamespaces();
        StringWriter stringWriter = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(stringWriter);
        if (this.xmlBlob != null) {
            xmlBlob.setLang(this.xmlBlob.getLang());
            xmlBlob.setBase(this.xmlBlob.getBase());
            list.addAll(this.xmlBlob.getNamespaces());
            stringWriter.write(this.xmlBlob.getBlob());
        }
        if (this.manifest != null) {
            for (XmlWriter.Namespace object2 : this.manifest.getNamespaceDecls()) {
                XmlNamespace xmlNamespace = new XmlNamespace(object2.getAlias(), object2.getUri());
                if (list.contains(xmlNamespace)) continue;
                list.add(xmlNamespace);
            }
        }
        for (Extension extension : this.nonRepeatingExtensionMap.values()) {
            extension.generate(xmlWriter, extensionProfile);
        }
        for (List list2 : this.repeatingExtensionMap.values()) {
            xmlWriter.startRepeatingElement();
            for (Extension extension : list2) {
                extension.generate(xmlWriter, extensionProfile);
            }
            xmlWriter.endRepeatingElement();
        }
        xmlBlob.setBlob(stringWriter.toString());
        return xmlBlob;
    }

    public void parseCumulativeXmlBlob(XmlBlob xmlBlob, ExtensionProfile extensionProfile, Class clazz) throws IOException, ParseException {
        this.xmlBlob = new XmlBlob();
        this.nonRepeatingExtensionMap.clear();
        this.repeatingExtensionMap.clear();
        StringWriter stringWriter = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(stringWriter);
        XmlBlob.startElement(xmlWriter, null, "CUMULATIVE_BLOB", xmlBlob, null, null);
        XmlBlob.endElement(xmlWriter, null, "CUMULATIVE_BLOB", xmlBlob);
        StringReader stringReader = new StringReader(stringWriter.toString());
        XmlParser xmlParser = new XmlParser();
        xmlParser.parse(stringReader, (XmlParser.ElementHandler)new CumulativeBlobHandler(extensionProfile, clazz), "", "CUMULATIVE_BLOB");
    }

    protected Manifest getManifest(ExtensionProfile extensionProfile, Class<? extends ExtensionPoint> clazz) {
        if (this.manifest == null) {
            this.manifest = extensionProfile.getManifest(clazz);
        }
        return this.manifest;
    }

    protected void generateStartElement(XmlWriter xmlWriter, XmlWriter.Namespace namespace, String string, Collection<XmlWriter.Attribute> collection, Collection<XmlWriter.Namespace> collection2) throws IOException {
        XmlBlob.startElement(xmlWriter, namespace, string, this.xmlBlob, collection, collection2);
    }

    protected void generateExtensions(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        for (Extension object : this.nonRepeatingExtensionMap.values()) {
            object.generate(xmlWriter, extensionProfile);
        }
        for (List list : this.repeatingExtensionMap.values()) {
            xmlWriter.startRepeatingElement();
            for (Extension extension : list) {
                extension.generate(xmlWriter, extensionProfile);
            }
            xmlWriter.endRepeatingElement();
        }
        if (this.xmlBlob != null) {
            xmlWriter.innerXml(this.xmlBlob.getBlob());
        }
    }

    protected void initializeArbitraryXml(ExtensionProfile extensionProfile, Class clazz, XmlParser.ElementHandler elementHandler) throws IOException {
        Manifest manifest = this.getManifest(extensionProfile, clazz);
        if (manifest != null && manifest.arbitraryXml) {
            elementHandler.initializeXmlBlob(this.xmlBlob, false, false);
        }
    }

    protected XmlParser.ElementHandler getExtensionHandler(ExtensionProfile extensionProfile, Class clazz, String string, String string2, Attributes attributes) throws ParseException, IOException {
        Manifest manifest = this.getManifest(extensionProfile, clazz);
        if (manifest == null) {
            return null;
        }
        ExtensionDescription extensionDescription = manifest.supportedExtensions.get(new Pair<String, String>(string, string2));
        if (extensionDescription == null && (extensionDescription = manifest.supportedExtensions.get(new Pair<String, String>(string, "*"))) == null) {
            return null;
        }
        Class<? extends Extension> clazz2 = extensionDescription.getExtensionClass();
        if (clazz2 == null) {
            return null;
        }
        Extension extension = null;
        if (extensionDescription.isAggregate()) {
            extension = this.getExtension(clazz2);
        }
        boolean bl = true;
        if (extension == null) {
            try {
                extension = clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ParseException("Unable to create extension", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ParseException("Unable to create extension", illegalAccessException);
            }
        } else {
            bl = false;
        }
        XmlParser.ElementHandler elementHandler = extension.getHandler(extensionProfile, string, string2, attributes);
        if (bl) {
            if (extensionDescription.isRepeatable()) {
                this.addRepeatingExtension(extension, clazz2);
            } else {
                boolean bl2 = this.addExtension(extension, clazz2);
                if (!bl2) {
                    throw new ParseException("Duplicate extension element " + string + ":" + string2);
                }
            }
        }
        return elementHandler;
    }

    protected void checkRequiredExtensions(Manifest manifest) throws ParseException {
        for (ExtensionDescription extensionDescription : manifest.supportedExtensions.values()) {
            boolean bl;
            Class<? extends Extension> clazz = extensionDescription.getExtensionClass();
            if (!extensionDescription.isRequired() || (bl = extensionDescription.isRepeatable() ? this.repeatingExtensionMap.containsKey(clazz) : this.nonRepeatingExtensionMap.containsKey(clazz))) continue;
            throw new ParseException("Required extension element " + extensionDescription.getNamespace().getAlias() + ":" + extensionDescription.getNamespace().getUri() + " not found.");
        }
    }

    public class ExtensionHandler
    extends XmlParser.ElementHandler {
        protected ExtensionProfile extProfile;
        protected Class extendedClass;
        protected boolean hasExtensions;

        public ExtensionHandler(ExtensionProfile extensionProfile, Class clazz) throws IOException {
            this.extProfile = extensionProfile;
            this.extendedClass = clazz;
            Manifest manifest = extensionProfile.getManifest(clazz);
            if (manifest != null) {
                this.hasExtensions = true;
                if (manifest.arbitraryXml) {
                    ExtensionPoint.this.initializeArbitraryXml(this.extProfile, clazz, this);
                }
            }
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            XmlParser.ElementHandler elementHandler;
            if (this.hasExtensions && (elementHandler = ExtensionPoint.this.getExtensionHandler(this.extProfile, this.extendedClass, string, string2, attributes)) != null) {
                return elementHandler;
            }
            return super.getChildHandler(string, string2, attributes);
        }

        public void processEndElement() throws ParseException {
            super.processEndElement();
            for (Object object : ExtensionPoint.this.nonRepeatingExtensionMap.values()) {
                if (!(object instanceof ValidatingExtension)) continue;
                ((ValidatingExtension)object).validate(ExtensionPoint.this);
            }
            for (Object object : ExtensionPoint.this.repeatingExtensionMap.values()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Extension extension = (Extension)iterator.next();
                    if (!(extension instanceof ValidatingExtension)) continue;
                    ((ValidatingExtension)extension).validate(ExtensionPoint.this);
                }
            }
        }
    }

    public class CumulativeBlobHandler
    extends XmlParser.ElementHandler {
        private final ExtensionProfile extProfile;
        private final Class extendedClass;

        public CumulativeBlobHandler(ExtensionProfile extensionProfile, Class clazz) throws IOException {
            this.extProfile = extensionProfile;
            this.extendedClass = clazz;
            ExtensionPoint.this.initializeArbitraryXml(extensionProfile, clazz, this);
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            XmlParser.ElementHandler elementHandler = ExtensionPoint.this.getExtensionHandler(this.extProfile, this.extendedClass, string, string2, attributes);
            if (elementHandler != null) {
                return elementHandler;
            }
            return super.getChildHandler(string, string2, attributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Manifest {
        final Map<Pair<String, String>, ExtensionDescription> supportedExtensions = new HashMap<Pair<String, String>, ExtensionDescription>();
        boolean arbitraryXml = false;

        public Map<Pair<String, String>, ExtensionDescription> getSupportedExtensions() {
            return Collections.unmodifiableMap(this.supportedExtensions);
        }

        Collection<XmlWriter.Namespace> getNamespaceDecls() {
            HashSet<XmlWriter.Namespace> hashSet = new HashSet<XmlWriter.Namespace>();
            for (ExtensionDescription extensionDescription : this.supportedExtensions.values()) {
                hashSet.add(extensionDescription.getNamespace());
            }
            return hashSet;
        }
    }
}

