/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.http;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.RedirectRequiredException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleGDataRequest
extends HttpGDataRequest {
    private static final Logger logger = Logger.getLogger(GoogleGDataRequest.class.getName());
    public static final String DISABLE_COOKIE_HANDLER_PROPERTY = "com.google.gdata.DisableCookieHandler";
    private static final ThreadLocal<GoogleService> activeService = new ThreadLocal();
    private static final GoogleCookieHandler googleCookieHandler = new GoogleCookieHandler();
    private GoogleService service;

    protected GoogleGDataRequest(Service.GDataRequest.RequestType requestType, URL uRL, ContentType contentType, HttpGDataRequest.AuthToken authToken, Map<String, String> map, Map<String, String> map2) throws IOException {
        super(requestType, uRL, contentType, authToken, map, map2);
    }

    public void setService(GoogleService googleService) {
        this.service = googleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServiceException {
        try {
            activeService.set(this.service);
            this.httpConn.setInstanceFollowRedirects(false);
            super.execute();
        }
        finally {
            activeService.set(null);
        }
    }

    @Override
    protected void handleErrorResponse() throws IOException, ServiceException {
        try {
            switch (this.httpConn.getResponseCode()) {
                case 301: 
                case 302: {
                    throw new RedirectRequiredException(this.httpConn);
                }
            }
            super.handleErrorResponse();
        }
        catch (AuthenticationException authenticationException) {
            if (authenticationException.getMessage().contains("Token expired")) {
                GoogleService.SessionExpiredException sessionExpiredException = new GoogleService.SessionExpiredException(authenticationException.getMessage());
                sessionExpiredException.setResponseContentType(authenticationException.getResponseContentType());
                sessionExpiredException.setResponseBody(authenticationException.getResponseBody());
                throw sessionExpiredException;
            }
            throw authenticationException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GoogleCookieHandler
    extends CookieHandler {
        private CookieHandler nextHandler;

        private GoogleCookieHandler() {
            if (!Boolean.getBoolean(GoogleGDataRequest.DISABLE_COOKIE_HANDLER_PROPERTY)) {
                logger.fine("Installing GoogleCookieHandler");
                this.nextHandler = CookieHandler.getDefault();
                CookieHandler.setDefault(this);
            }
        }

        @Override
        public Map<String, List<String>> get(URI uRI, Map<String, List<String>> map) throws IOException {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            GoogleService googleService = (GoogleService)activeService.get();
            if (googleService != null && googleService.handlesCookies()) {
                Set<GoogleCookie> set = googleService.getCookies();
                StringBuilder stringBuilder = new StringBuilder();
                for (GoogleCookie googleCookie : set) {
                    if (!googleCookie.matches(uRI)) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append(googleCookie.getHeaderValue());
                    logger.fine("Setting cookie: " + googleCookie);
                }
                if (stringBuilder.length() != 0) {
                    hashMap.put("Cookie", Collections.singletonList(stringBuilder.toString()));
                }
            } else if (this.nextHandler != null) {
                return this.nextHandler.get(uRI, map);
            }
            return Collections.unmodifiableMap(hashMap);
        }

        @Override
        public void put(URI uRI, Map<String, List<String>> map) throws IOException {
            GoogleService googleService = (GoogleService)activeService.get();
            if (googleService != null && googleService.handlesCookies()) {
                List<String> list = map.get("Set-Cookie");
                if (list != null && list.size() > 0) {
                    for (String string : list) {
                        GoogleCookie googleCookie = new GoogleCookie(uRI, string);
                        googleService.addCookie(googleCookie);
                        logger.fine("Adding cookie:" + googleCookie);
                    }
                }
            } else if (this.nextHandler != null) {
                this.nextHandler.get(uRI, map);
            }
        }
    }

    public static class GoogleCookie {
        private String domain;
        private String path;
        private String name;
        private String value;
        private Date expires;
        private static DateFormat expiresFormat1 = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'", Locale.US);
        private static DateFormat expiresFormat2 = new SimpleDateFormat("E, dd MMM yyyy k:m:s 'GMT'", Locale.US);

        public String getDomain() {
            return this.domain;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        public Date getExpires() {
            return this.expires;
        }

        public GoogleCookie(URI uRI, String string) {
            String[] stringArray = string.split(";");
            String string2 = stringArray[0].trim();
            int n = string2.indexOf(61);
            if (n < 0) {
                throw new IllegalArgumentException("Cookie is not a name/value pair");
            }
            this.name = string2.substring(0, n);
            this.value = string2.substring(n + 1);
            this.path = "/";
            this.domain = uRI.getHost();
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = stringArray[i].trim();
                n = string2.indexOf(61);
                if (n == -1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (string3.equalsIgnoreCase("domain")) {
                    String string5 = uRI.getHost();
                    if (string5.equals(string4)) {
                        this.domain = string4;
                    } else if (!this.matchDomain(string5, string4)) {
                        throw new IllegalArgumentException("Trying to set foreign cookie");
                    }
                    this.domain = string4;
                    continue;
                }
                if (string3.equalsIgnoreCase("path")) {
                    this.path = string4;
                    continue;
                }
                if (!string3.equalsIgnoreCase("expires")) continue;
                try {
                    this.expires = expiresFormat1.parse(string4);
                    continue;
                }
                catch (ParseException parseException) {
                    try {
                        this.expires = expiresFormat2.parse(string4);
                        continue;
                    }
                    catch (ParseException parseException2) {
                        throw new IllegalArgumentException("Bad date format in header: " + string4);
                    }
                }
            }
        }

        private boolean matchDomain(String string, String string2) {
            if (!string.endsWith(string2)) {
                return false;
            }
            if (string.length() == string2.length()) {
                return true;
            }
            if (string2.charAt(0) == '.') {
                return true;
            }
            return string.charAt(string.length() - string2.length() - 1) == '.';
        }

        public boolean hasExpired() {
            if (this.expires == null) {
                return false;
            }
            Date date = new Date();
            return date.after(this.expires);
        }

        public boolean matches(URI uRI) {
            if (this.hasExpired()) {
                return false;
            }
            String string = uRI.getHost();
            if (!this.matchDomain(string, this.domain)) {
                return false;
            }
            String string2 = uRI.getPath();
            if (string2 == null) {
                string2 = "/";
            }
            return string2.startsWith(this.path);
        }

        String getHeaderValue() {
            StringBuilder stringBuilder = new StringBuilder(this.name);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof GoogleCookie)) {
                return false;
            }
            GoogleCookie googleCookie = (GoogleCookie)object;
            if (!this.name.equals(googleCookie.name) || !this.domain.equals(googleCookie.domain)) {
                return false;
            }
            if (this.path == null && googleCookie.path != null) {
                return false;
            }
            return this.path.equals(googleCookie.path);
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.name.hashCode();
            n = 37 * n + this.domain.hashCode();
            n = 37 * n + (this.path != null ? this.path.hashCode() : 0);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("GoogleCookie(");
            stringBuilder.append(this.domain);
            stringBuilder.append(this.path);
            stringBuilder.append("[");
            stringBuilder.append(this.name);
            stringBuilder.append("]");
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    public static class Factory
    extends HttpGDataRequest.Factory {
        public Service.GDataRequest getRequest(Service.GDataRequest.RequestType requestType, URL uRL, ContentType contentType) throws IOException, ServiceException {
            return new GoogleGDataRequest(requestType, uRL, contentType, this.authToken, this.headerMap, this.privateHeaderMap);
        }
    }
}

