/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.unittests;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xmldb.xupdate.lexus.XUpdateQueryImpl;
import org.xmldb.xupdate.unittests.XhiveNodeMatcher;

public class LexusTestCase
extends TestCase {
    private static Document updates;
    private static DocumentBuilderFactory factory;
    static final String RESOURCE_LOCATION = "org/xmldb/xupdate/unittests/";
    static final String XPATHQUERYFACTORY = "org.xmldb.common.xml.queries.xalan2.XPathQueryFactoryImpl";

    public LexusTestCase(String string) {
        super(string);
    }

    public void mainTest(String string) throws Exception {
        if (updates == null) {
            updates = this.parseInputFile("org/xmldb/xupdate/unittests/tests.xml");
        }
        Node node = XPathAPI.selectSingleNode((Node)updates, (String)("/tests/test[@name='" + string + "']/xupdate/*"), (Node)updates);
        String string2 = this.serialize((Element)node);
        Document document = this.getDocument(updates, "/tests/input[@name=/tests/test[@name='" + string + "']/@input]/*");
        XUpdateQueryImpl xUpdateQueryImpl = new XUpdateQueryImpl();
        xUpdateQueryImpl.setQString(string2);
        System.setProperty("org.xmldb.common.xml.queries.XPathQueryFactory", XPATHQUERYFACTORY);
        xUpdateQueryImpl.execute(document);
        this.removeWhiteSpace(document);
        Document document2 = this.getDocument(updates, "/tests/test[@name='" + string + "']/result/*");
        this.removeWhiteSpace(document2);
        new XhiveNodeMatcher();
        XhiveNodeMatcher.compareNodes(document2, document, true, true);
    }

    private Document parseInputFile(String string) throws Exception {
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        return documentBuilder.parse(string);
    }

    private String serialize(Element element) throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.getSerializer(stringWriter).serialize(element);
        return stringWriter.toString();
    }

    private String serialize(Document document) throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.getSerializer(stringWriter).serialize(document);
        return stringWriter.toString();
    }

    private DOMSerializer getSerializer(StringWriter stringWriter) throws Exception {
        OutputFormat outputFormat = new OutputFormat("xml", "UTF-8", true);
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        return xMLSerializer.asDOMSerializer();
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder;
    }

    private Document getDocument(Node node, String string) throws Exception {
        Node node2 = XPathAPI.selectSingleNode((Node)node, (String)string, (Node)node);
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        node2 = document.importNode(node2, true);
        document.appendChild(node2);
        return document;
    }

    private void removeWhiteSpace(Node node) {
        DocumentTraversal documentTraversal = node instanceof Document ? (DocumentTraversal)((Object)node) : (DocumentTraversal)((Object)node.getOwnerDocument());
        NodeIterator nodeIterator = documentTraversal.createNodeIterator(node, 4, null, true);
        Node node2 = nodeIterator.nextNode();
        while (node2 != null) {
            if (node2.getNodeValue().trim().compareTo("") == 0) {
                node2.getParentNode().removeChild(node2);
            }
            node2 = nodeIterator.nextNode();
        }
    }

    static {
        factory = DocumentBuilderFactory.newInstance();
    }
}

