/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.calendar;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Link;
import com.google.gdata.data.calendar.CalendarEventEntry;
import com.google.gdata.data.calendar.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class WebContent
implements Extension {
    public static final String REL = "http://schemas.google.com/gCal/2005/webContent";
    private static final String TYPE = "webContent";
    private static final ExtensionDescription EXTENSION_DESCRIPTION;
    private String width = null;
    private String height = null;
    private String url = null;
    private Link webContentLink;

    public WebContent() {
        this.setLink(new Link(REL, null, null));
    }

    public static ExtensionDescription getDefaultDescription() {
        return EXTENSION_DESCRIPTION;
    }

    public static void updateWebContent(CalendarEventEntry calendarEventEntry) throws ParseException {
        Link link = calendarEventEntry.getWebContentLink();
        if (link == null) {
            calendarEventEntry.setWebContent(null);
        } else {
            WebContent webContent = calendarEventEntry.getWebContent();
            webContent.setLink(link);
            calendarEventEntry.setWebContent(webContent);
        }
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        if (this.getWidth() != null) {
            arrayList.add(new XmlWriter.Attribute("width", this.getWidth()));
        }
        if (this.getHeight() != null) {
            arrayList.add(new XmlWriter.Attribute("height", this.getHeight()));
        }
        if (this.getUrl() != null) {
            arrayList.add(new XmlWriter.Attribute("url", this.getUrl()));
        }
        if (arrayList.size() != 0) {
            xmlWriter.simpleElement(Namespaces.gCalNs, TYPE, arrayList, null);
        }
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new Handler();
    }

    Link getLink() {
        return this.webContentLink;
    }

    void setLink(Link link) {
        if (this.webContentLink != null) {
            this.webContentLink.removeExtension(WebContent.class);
        }
        this.webContentLink = link;
        this.webContentLink.setExtension(this);
    }

    public String getIcon() {
        return this.webContentLink.getHref();
    }

    public void setIcon(String string) {
        this.webContentLink.setHref(string);
    }

    public String getTitle() {
        return this.webContentLink.getTitle();
    }

    public void setTitle(String string) {
        this.webContentLink.setTitle(string);
    }

    public String getType() {
        return this.webContentLink.getType();
    }

    public void setType(String string) {
        this.webContentLink.setType(string);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public String toString() {
        return "icon=" + this.getIcon() + ",title=" + this.getTitle() + ",type=" + this.getType() + ",width=" + this.getWidth() + ",height=" + this.getHeight() + ",url=" + this.getUrl();
    }

    static {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(WebContent.class);
        extensionDescription.setNamespace(Namespaces.gCalNs);
        extensionDescription.setLocalName(TYPE);
        extensionDescription.setRepeatable(false);
        EXTENSION_DESCRIPTION = extensionDescription;
    }

    class Handler
    extends XmlParser.ElementHandler {
        public Handler() {
            WebContent.this.width = null;
            WebContent.this.height = null;
            WebContent.this.url = null;
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (!string.equals("")) {
                return;
            }
            if (string2.equals("width")) {
                WebContent.this.setWidth(string3);
            } else if (string2.equals("height")) {
                WebContent.this.setHeight(string3);
            } else if (string2.equals("url")) {
                WebContent.this.setUrl(string3);
            }
        }
    }
}

