/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiEditorInput;
import org.eclipse.ui.themes.ITheme;

public abstract class MultiEditor
extends EditorPart {
    private int activeEditorIndex;
    private IEditorPart[] innerEditors;
    private IPartListener2 propagationListener;

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.innerEditors.length) {
            IEditorPart e = this.innerEditors[i];
            e.doSave(monitor);
            ++i;
        }
    }

    public Composite createInnerPartControl(Composite parent, final IEditorPart e) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new FillLayout());
        e.createPartControl(content);
        parent.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    MultiEditor.this.activateEditor(e);
                }
            }
        });
        return content;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.init(site, (MultiEditorInput)input);
    }

    public void init(IEditorSite site, MultiEditorInput input) throws PartInitException {
        this.setInput(input);
        this.setSite(site);
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
        this.setupEvents();
    }

    public boolean isDirty() {
        int i = 0;
        while (i < this.innerEditors.length) {
            IEditorPart e = this.innerEditors[i];
            if (e.isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.innerEditors[this.activeEditorIndex].setFocus();
        this.updateGradient(this.innerEditors[this.activeEditorIndex]);
    }

    public final IEditorPart getActiveEditor() {
        return this.innerEditors[this.activeEditorIndex];
    }

    public final IEditorPart[] getInnerEditors() {
        return this.innerEditors;
    }

    public final void setChildren(IEditorPart[] children) {
        this.innerEditors = children;
        this.activeEditorIndex = 0;
    }

    protected void activateEditor(IEditorPart part) {
        IEditorPart oldEditor = this.getActiveEditor();
        this.activeEditorIndex = this.getIndex(part);
        IEditorPart e = this.getActiveEditor();
        EditorSite innerSite = (EditorSite)e.getEditorSite();
        ((WorkbenchPage)innerSite.getPage()).requestActivation(e);
        this.updateGradient(oldEditor);
    }

    protected int getIndex(IEditorPart editor) {
        int i = 0;
        while (i < this.innerEditors.length) {
            if (this.innerEditors[i] == editor) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void updateGradient(IEditorPart editor) {
        boolean activeEditor = editor == this.getSite().getPage().getActiveEditor();
        boolean activePart = editor == this.getSite().getPage().getActivePart();
        ITheme theme = editor.getEditorSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme();
        Gradient g = new Gradient();
        ColorRegistry colorRegistry = theme.getColorRegistry();
        if (activePart) {
            g.fgColor = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
            g.bgColors = new Color[2];
            g.bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            g.bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        } else if (activeEditor) {
            g.fgColor = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
            g.bgColors = new Color[2];
            g.bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            g.bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        } else {
            g.fgColor = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR");
            g.bgColors = new Color[2];
            g.bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
            g.bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END");
        }
        g.bgPercents = new int[]{theme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT")};
        this.drawGradient(editor, g);
    }

    protected abstract void drawGradient(IEditorPart var1, Gradient var2);

    protected boolean getShellActivated() {
        WorkbenchWindow window = (WorkbenchWindow)this.getSite().getPage().getWorkbenchWindow();
        return window.getShellActivated();
    }

    private void setupEvents() {
        this.propagationListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part == MultiEditor.this && MultiEditor.this.innerEditors != null) {
                    PartService partService = ((WorkbenchPage)MultiEditor.this.getSite().getPage()).getPartService();
                    int i = 0;
                    while (i < MultiEditor.this.innerEditors.length) {
                        IEditorPart editor = MultiEditor.this.innerEditors[i];
                        IWorkbenchPartReference innerRef = ((PartSite)editor.getSite()).getPartReference();
                        partService.firePartClosed(innerRef);
                        ++i;
                    }
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part == MultiEditor.this && MultiEditor.this.innerEditors != null) {
                    PartService partService = ((WorkbenchPage)MultiEditor.this.getSite().getPage()).getPartService();
                    int i = 0;
                    while (i < MultiEditor.this.innerEditors.length) {
                        IEditorPart editor = MultiEditor.this.innerEditors[i];
                        IWorkbenchPartReference innerRef = ((PartSite)editor.getSite()).getPartReference();
                        partService.firePartOpened(innerRef);
                        ++i;
                    }
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getSite().getPage().addPartListener(this.propagationListener);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.propagationListener);
        super.dispose();
    }

    public static class Gradient {
        public Color fgColor;
        public Color[] bgColors;
        public int[] bgPercents;
    }
}

