/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class When
extends ExtensionPoint
implements Extension {
    protected DateTime startTime;
    protected DateTime endTime;
    protected String valueString;

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.startTime = dateTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime dateTime) {
        this.endTime = dateTime;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String string) {
        this.valueString = string;
    }

    public static ExtensionDescription getDefaultDescription(boolean bl) {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(When.class);
        extensionDescription.setNamespace(Namespaces.gNs);
        extensionDescription.setLocalName("when");
        extensionDescription.setRepeatable(bl);
        return extensionDescription;
    }

    public static ExtensionDescription getDefaultDescription() {
        return When.getDefaultDescription(true);
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        if (this.startTime != null) {
            arrayList.add(new XmlWriter.Attribute("startTime", this.startTime.toString()));
        }
        if (this.endTime != null) {
            arrayList.add(new XmlWriter.Attribute("endTime", this.endTime.toString()));
        }
        if (this.valueString != null) {
            arrayList.add(new XmlWriter.Attribute("valueString", this.valueString));
        }
        this.generateStartElement(xmlWriter, Namespaces.gNs, "when", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.gNs, "when");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new Handler(extensionProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        private boolean wholeDays;
        private boolean wholeDaysKnown;

        public Handler(ExtensionProfile extensionProfile) throws ParseException, IOException {
            super(extensionProfile, When.class);
            this.wholeDays = false;
            this.wholeDaysKnown = false;
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("")) {
                if (string2.equals("startTime")) {
                    When.this.startTime = this.parseDateTime(string3);
                } else if (string2.equals("endTime")) {
                    When.this.endTime = this.parseDateTime(string3);
                } else if (string2.equals("valueString")) {
                    When.this.valueString = string3;
                }
            }
        }

        private DateTime parseDateTime(String string) throws ParseException {
            DateTime dateTime;
            try {
                dateTime = DateTime.parseDateTimeChoice(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid date/time value.", numberFormatException);
            }
            if (this.wholeDaysKnown && dateTime.isDateOnly() != this.wholeDays) {
                if (this.wholeDays) {
                    throw new ParseException("Date value expected.");
                }
                throw new ParseException("Date/time value expected.");
            }
            this.wholeDaysKnown = true;
            this.wholeDays = dateTime.isDateOnly();
            return dateTime;
        }

        public void processEndElement() throws ParseException {
            if (When.this.startTime == null) {
                throw new ParseException("g:when/@startTime is required.");
            }
            if (When.this.startTime != null && When.this.endTime != null && When.this.startTime.compareTo(When.this.endTime) > 0) {
                throw new ParseException("g:when/@startTime must be less than or equal to g:when/@endTime.");
            }
            super.processEndElement();
        }
    }
}

