/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class BatchInterrupted
extends ExtensionPoint
implements Extension {
    private String reason;
    private int totalCount;
    private int successCount;
    private int errorCount;
    private String content;
    private ContentType contentType;

    public BatchInterrupted(String string, int n, int n2, int n3) {
        this.reason = string;
        this.totalCount = n;
        this.successCount = n2;
        this.errorCount = n3;
        if (n < n2 - n3) {
            throw new IllegalArgumentException("total < success + error. total = " + n + " success=" + n2 + " error=" + n3);
        }
    }

    public BatchInterrupted() {
    }

    public BatchInterrupted(Throwable throwable, int n, int n2, int n3) {
        this(BatchInterrupted.getReasonFromException(throwable), n, n2, n3);
        if (throwable instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)throwable;
            this.content = serviceException.getResponseBody();
            this.contentType = serviceException.getResponseContentType();
        }
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(BatchInterrupted.class);
        extensionDescription.setNamespace(Namespaces.batchNs);
        extensionDescription.setLocalName("interrupted");
        extensionDescription.setRepeatable(false);
        return extensionDescription;
    }

    private static String getReasonFromException(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            return "Unexpected error";
        }
        return string;
    }

    public String getReason() {
        return this.reason;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(6);
        if (this.reason != null) {
            arrayList.add(new XmlWriter.Attribute("reason", this.reason));
        }
        arrayList.add(new XmlWriter.Attribute("parsed", Integer.toString(this.totalCount)));
        arrayList.add(new XmlWriter.Attribute("success", Integer.toString(this.successCount)));
        arrayList.add(new XmlWriter.Attribute("error", Integer.toString(this.errorCount)));
        int n = this.totalCount - (this.successCount + this.errorCount);
        arrayList.add(new XmlWriter.Attribute("unprocessed", Integer.toString(n)));
        if (this.contentType != null) {
            this.contentType.getAttributes().remove("charset");
            arrayList.add(new XmlWriter.Attribute("content-type", this.contentType.toString()));
        }
        this.generateStartElement(xmlWriter, Namespaces.batchNs, "interrupted", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        if (this.content != null) {
            xmlWriter.characters(this.content);
        }
        xmlWriter.endElement(Namespaces.batchNs, "interrupted");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws IOException, ParseException {
        return new BatchInterruptedElementHandler(extensionProfile, attributes);
    }

    private static int getIntegerAttribute(Attributes attributes, String string, int n) throws ParseException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid integer in value of attribute " + string + ": '" + string2 + "'", numberFormatException);
        }
    }

    private class BatchInterruptedElementHandler
    extends ExtensionPoint.ExtensionHandler {
        public BatchInterruptedElementHandler(ExtensionProfile extensionProfile, Attributes attributes) throws IOException, ParseException {
            super(extensionProfile, BatchInterrupted.class);
            BatchInterrupted.this.totalCount = BatchInterrupted.getIntegerAttribute(attributes, "parsed", 0);
            BatchInterrupted.this.successCount = BatchInterrupted.getIntegerAttribute(attributes, "success", 0);
            BatchInterrupted.this.errorCount = BatchInterrupted.getIntegerAttribute(attributes, "error", 0);
            BatchInterrupted.this.reason = attributes.getValue("reason");
            String string = attributes.getValue("content-type");
            if (string != null) {
                try {
                    BatchInterrupted.this.contentType = new ContentType(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException("Invalid content type: '" + string + "'", illegalArgumentException);
                }
            }
        }

        public void processEndElement() throws ParseException {
            BatchInterrupted.this.content = this.value;
        }
    }
}

