/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.Category;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Generator;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.Person;
import com.google.gdata.data.Rfc3339Handler;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Source
extends ExtensionPoint {
    protected SourceState srcState;

    public Source() {
        this.srcState = new SourceState();
    }

    protected Source(Source source) {
        super(source);
        this.srcState = source.srcState;
    }

    public String getId() {
        return this.srcState.id;
    }

    public void setId(String string) {
        this.srcState.id = string;
    }

    public DateTime getUpdated() {
        return this.srcState.updated;
    }

    public void setUpdated(DateTime dateTime) {
        this.srcState.updated = dateTime;
    }

    public Set<Category> getCategories() {
        return this.srcState.categories;
    }

    public TextConstruct getTitle() {
        return this.srcState.title;
    }

    public void setTitle(TextConstruct textConstruct) {
        this.srcState.title = textConstruct;
    }

    public TextConstruct getSubtitle() {
        return this.srcState.subtitle;
    }

    public void setSubtitle(TextConstruct textConstruct) {
        this.srcState.subtitle = textConstruct;
    }

    public TextConstruct getRights() {
        return this.srcState.rights;
    }

    public void setRights(TextConstruct textConstruct) {
        this.srcState.rights = textConstruct;
    }

    public String getIcon() {
        return this.srcState.icon;
    }

    public void setIcon(String string) {
        this.srcState.icon = string;
    }

    public String getLogo() {
        return this.srcState.logo;
    }

    public void setLogo(String string) {
        this.srcState.logo = string;
    }

    public List<Link> getLinks() {
        return this.srcState.links;
    }

    public List<Person> getAuthors() {
        return this.srcState.authors;
    }

    public List<Person> getContributors() {
        return this.srcState.contributors;
    }

    public Generator getGenerator() {
        return this.srcState.generator;
    }

    public void setGenerator(Generator generator) {
        this.srcState.generator = generator;
    }

    public Link getLink(String string, String string2) {
        for (Link link : this.srcState.links) {
            String string3 = link.getRel();
            String string4 = link.getType();
            if (string != null && (string3 == null || !string3.equals(string)) || string2 != null && (string4 == null || !string4.equals(string2))) continue;
            return link;
        }
        return null;
    }

    public void addHtmlLink(String string, String string2, String string3) {
        Link link = new Link();
        link.setRel("alternate");
        link.setType("text/html");
        link.setHref(string);
        if (string2 != null) {
            link.setHrefLang(string2);
        }
        if (string3 != null) {
            link.setTitle(string3);
        }
        this.srcState.links.add(link);
    }

    public Link getHtmlLink() {
        Link link = this.getLink("alternate", "text/html");
        return link;
    }

    public void generateAtom(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        this.generateStartElement(xmlWriter, Namespaces.atomNs, "source", null, null);
        this.generateInnerAtom(xmlWriter, extensionProfile);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.atomNs, "source");
    }

    protected void generateInnerAtom(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        if (this.srcState.id != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "id", null, this.srcState.id);
        }
        if (this.srcState.updated != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "updated", null, this.srcState.updated.toString());
        }
        xmlWriter.startRepeatingElement();
        for (Category object : this.srcState.categories) {
            object.generateAtom(xmlWriter);
        }
        xmlWriter.endRepeatingElement();
        if (this.srcState.title != null) {
            this.srcState.title.generateAtom(xmlWriter, "title");
        }
        if (this.srcState.subtitle != null) {
            this.srcState.subtitle.generateAtom(xmlWriter, "subtitle");
        }
        if (this.srcState.rights != null) {
            this.srcState.rights.generateAtom(xmlWriter, "rights");
        }
        if (this.srcState.icon != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "icon", null, this.srcState.icon);
        }
        if (this.srcState.logo != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "logo", null, this.srcState.logo);
        }
        xmlWriter.startRepeatingElement();
        for (Link link : this.srcState.links) {
            link.generateAtom(xmlWriter, extensionProfile);
        }
        xmlWriter.endRepeatingElement();
        xmlWriter.startRepeatingElement();
        for (Person person : this.srcState.authors) {
            person.generateAtom(extensionProfile, xmlWriter, "author");
        }
        xmlWriter.endRepeatingElement();
        xmlWriter.startRepeatingElement();
        for (Person person : this.srcState.contributors) {
            person.generateAtom(extensionProfile, xmlWriter, "contributor");
        }
        xmlWriter.endRepeatingElement();
        if (this.srcState.generator != null) {
            this.srcState.generator.generateAtom(xmlWriter);
        }
    }

    public void parseAtom(ExtensionProfile extensionProfile, InputStream inputStream) throws IOException, ParseException {
        SourceHandler sourceHandler = new SourceHandler(extensionProfile);
        new XmlParser().parse(inputStream, (XmlParser.ElementHandler)sourceHandler, "http://www.w3.org/2005/Atom", "source");
    }

    public void parseAtom(ExtensionProfile extensionProfile, Reader reader) throws IOException, ParseException {
        SourceHandler sourceHandler = new SourceHandler(extensionProfile);
        new XmlParser().parse(reader, (XmlParser.ElementHandler)sourceHandler, "http://www.w3.org/2005/Atom", "source");
    }

    public class SourceHandler
    extends ExtensionPoint.ExtensionHandler {
        public SourceHandler(ExtensionProfile extensionProfile) throws IOException {
            super(extensionProfile, Source.class);
        }

        protected SourceHandler(ExtensionProfile extensionProfile, Class clazz) throws IOException {
            super(extensionProfile, clazz);
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (string.equals("http://www.w3.org/2005/Atom")) {
                if (string2.equals("id")) {
                    return new IdHandler();
                }
                if (string2.equals("updated")) {
                    return new UpdatedHandler();
                }
                if (string2.equals("category")) {
                    Category category = new Category();
                    Kind.Adaptable adaptable = Source.this instanceof Kind.Adaptable ? (Kind.Adaptable)((Object)Source.this) : null;
                    Category category2 = category;
                    category2.getClass();
                    return category2.new Category.AtomHandler(this.extProfile, Source.this.srcState.categories, adaptable);
                }
                if (string2.equals("title")) {
                    TextConstruct.ChildHandlerInfo childHandlerInfo = TextConstruct.getChildHandler(attributes);
                    if (Source.this.srcState.title != null) {
                        throw new ParseException("Duplicate title.");
                    }
                    Source.this.srcState.title = childHandlerInfo.textConstruct;
                    return childHandlerInfo.handler;
                }
                if (string2.equals("subtitle")) {
                    TextConstruct.ChildHandlerInfo childHandlerInfo = TextConstruct.getChildHandler(attributes);
                    if (Source.this.srcState.subtitle != null) {
                        throw new ParseException("Duplicate subtitle.");
                    }
                    Source.this.srcState.subtitle = childHandlerInfo.textConstruct;
                    return childHandlerInfo.handler;
                }
                if (string2.equals("rights")) {
                    TextConstruct.ChildHandlerInfo childHandlerInfo = TextConstruct.getChildHandler(attributes);
                    if (Source.this.srcState.rights != null) {
                        throw new ParseException("Duplicate rights.");
                    }
                    Source.this.srcState.rights = childHandlerInfo.textConstruct;
                    return childHandlerInfo.handler;
                }
                if (string2.equals("icon")) {
                    return new IconHandler();
                }
                if (string2.equals("logo")) {
                    return new LogoHandler();
                }
                if (string2.equals("link")) {
                    Link link = new Link();
                    Source.this.srcState.links.add(link);
                    Link link2 = link;
                    link2.getClass();
                    return link2.new Link.AtomHandler(this.extProfile);
                }
                if (string2.equals("author")) {
                    Person person = new Person();
                    Source.this.srcState.authors.add(person);
                    Person person2 = person;
                    person2.getClass();
                    return person2.new Person.AtomHandler(this.extProfile);
                }
                if (string2.equals("contributor")) {
                    Person person = new Person();
                    Source.this.srcState.contributors.add(person);
                    Person person3 = person;
                    person3.getClass();
                    return person3.new Person.AtomHandler(this.extProfile);
                }
                if (string2.equals("generator")) {
                    if (Source.this.srcState.generator != null) {
                        throw new ParseException("Duplicate generator.");
                    }
                    Source.this.srcState.generator = new Generator();
                    return Source.this.srcState.generator.new Generator.AtomHandler();
                }
            } else {
                return super.getChildHandler(string, string2, attributes);
            }
            return null;
        }

        private class LogoHandler
        extends XmlParser.ElementHandler {
            private LogoHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Source.this.srcState.logo != null) {
                    throw new ParseException("Duplicate logo.");
                }
                if (this.value == null) {
                    throw new ParseException("logo must have a value.");
                }
                Source.this.srcState.logo = this.value;
            }
        }

        private class IconHandler
        extends XmlParser.ElementHandler {
            private IconHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Source.this.srcState.icon != null) {
                    throw new ParseException("Duplicate icon.");
                }
                if (this.value == null) {
                    throw new ParseException("icon must have a value.");
                }
                Source.this.srcState.icon = this.value;
            }
        }

        class UpdatedHandler
        extends Rfc3339Handler {
            UpdatedHandler() {
            }

            public void processEndElement() throws ParseException {
                super.processEndElement();
                Source.this.srcState.updated = this.getDateTime();
            }
        }

        private class IdHandler
        extends XmlParser.ElementHandler {
            private IdHandler() {
            }

            public void processEndElement() throws ParseException {
                if (Source.this.srcState.id != null) {
                    throw new ParseException("Duplicate feed ID.");
                }
                if (this.value == null) {
                    throw new ParseException("ID must have a value.");
                }
                Source.this.srcState.id = this.value;
            }
        }
    }

    protected static class SourceState {
        public String id;
        public DateTime updated;
        public HashSet<Category> categories = new HashSet();
        public TextConstruct title;
        public TextConstruct subtitle;
        public TextConstruct rights;
        public String icon;
        public String logo;
        public LinkedList<Link> links = new LinkedList();
        public LinkedList<Person> authors = new LinkedList();
        public LinkedList<Person> contributors = new LinkedList();
        public Generator generator;

        protected SourceState() {
        }
    }
}

