/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb.services;

import org.apache.xindice.client.xmldb.CommonConfigurable;
import org.apache.xindice.client.xmldb.XindiceCollection;
import org.apache.xindice.client.xmldb.services.CollectionManager;
import org.apache.xindice.client.xmldb.services.DatabaseInstanceManager;
import org.apache.xindice.core.FaultCodes;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class CollectionManagementServiceImpl
extends CommonConfigurable
implements CollectionManagementService,
CollectionManager,
DatabaseInstanceManager {
    private Collection coll = null;
    private static final String SERVICE_VERSION = "1.0";
    private static final String SERVICE_NAME = "CollectionManagementService";

    public String getVersion() throws XMLDBException {
        return SERVICE_VERSION;
    }

    public Collection createCollection(String childCollName) throws XMLDBException {
        if (this.coll == null) {
            throw new XMLDBException(201, "Must set collection for this service");
        }
        return ((XindiceCollection)this.coll).createCollection(childCollName);
    }

    public void removeCollection(String childCollName) throws XMLDBException {
        if (this.coll == null) {
            throw new XMLDBException(201, "Must set collection for this service");
        }
        ((XindiceCollection)this.coll).removeCollection(childCollName);
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public void setCollection(Collection collection) {
        this.coll = collection;
    }

    public String getCollectionName() throws XMLDBException {
        try {
            return this.coll.getName();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public String getCanonicalName() throws XMLDBException {
        try {
            return ((XindiceCollection)this.coll).getCanonicalName();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public Collection createCollection(String path, Document configuration) throws XMLDBException {
        if (this.coll == null) {
            throw new XMLDBException(201, "Must set collection for this service");
        }
        return ((XindiceCollection)this.coll).createCollection(path, configuration);
    }

    public void dropCollection(String name) throws XMLDBException {
        this.removeCollection(name);
    }

    public String[] listIndexers() throws XMLDBException {
        try {
            return ((XindiceCollection)this.coll).listIndexers();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void createIndexer(Document configuration) throws XMLDBException {
        try {
            ((XindiceCollection)this.coll).createIndexer(configuration);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void dropIndexer(String name) throws XMLDBException {
        try {
            ((XindiceCollection)this.coll).dropIndexer(name);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void shutdown() throws XMLDBException {
        ((XindiceCollection)this.coll).shutdown();
    }

    public String[] listXMLObjects() throws XMLDBException {
        return null;
    }

    public void createXMLObject(Document configuration) throws XMLDBException {
    }

    public void dropXMLObject(String name) throws XMLDBException {
    }
}

