/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.NodeSource;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.dom.AttrImpl;
import org.apache.xindice.xml.dom.CDATASectionImpl;
import org.apache.xindice.xml.dom.CommentImpl;
import org.apache.xindice.xml.dom.CompressedDocument;
import org.apache.xindice.xml.dom.ContainerNodeImpl;
import org.apache.xindice.xml.dom.DBDocument;
import org.apache.xindice.xml.dom.DOMCompressor;
import org.apache.xindice.xml.dom.DOMImplementationImpl;
import org.apache.xindice.xml.dom.DocumentFragmentImpl;
import org.apache.xindice.xml.dom.ElementImpl;
import org.apache.xindice.xml.dom.EntityReferenceImpl;
import org.apache.xindice.xml.dom.NodeImpl;
import org.apache.xindice.xml.dom.ProcessingInstructionImpl;
import org.apache.xindice.xml.dom.TextImpl;
import org.apache.xindice.xml.dom.traversal.TreeWalkerImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public final class DocumentImpl
extends ContainerNodeImpl
implements CompressedDocument,
DBDocument,
DocumentTraversal,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$dom$DocumentImpl == null ? (class$org$apache$xindice$xml$dom$DocumentImpl = DocumentImpl.class$("org.apache.xindice.xml.dom.DocumentImpl")) : class$org$apache$xindice$xml$dom$DocumentImpl));
    private DocumentType docType = null;
    private String version = null;
    private String actualEncoding = null;
    private String encoding = null;
    private boolean standalone = false;
    private boolean strictErrorChecking = false;
    private SymbolTable symbols = null;
    private boolean readOnly = false;
    static /* synthetic */ Class class$org$apache$xindice$xml$dom$DocumentImpl;

    public DocumentImpl() {
        super(null, true);
    }

    public DocumentImpl(byte[] data, int pos, int len) {
        super(null, data, pos, len);
    }

    public DocumentImpl(byte[] data) {
        this(data, 0, data.length);
    }

    public DocumentImpl(byte[] data, SymbolTable symbols, NodeSource source) {
        this(data);
        this.symbols = symbols;
        this.source = source;
    }

    public DocumentImpl(Document doc) throws XindiceException {
        super(null, true);
        boolean compress = true;
        if (doc instanceof CompressedDocument) {
            CompressedDocument c = (CompressedDocument)doc;
            this.symbols = c.getSymbols();
            if (!c.isDirty()) {
                this.data = c.getDataBytes();
                this.pos = c.getDataPos();
                this.len = c.getDataLen();
                compress = false;
            }
        }
        if (compress) {
            if (this.symbols == null) {
                this.symbols = new SymbolTable();
            }
            this.data = DOMCompressor.Compress(doc, this.symbols);
            this.pos = 0;
            this.len = this.data.length;
        }
        if (doc instanceof DBDocument) {
            DBDocument d = (DBDocument)doc;
            this.source = d.getSource();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void checkLoaded() {
        block4: {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            try {
                if (this.data != null) {
                    this.loadChildren(this.symbols);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public boolean isCaching() {
        String cache = "cache";
        int size = this.childNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = this.childNodes.item(i);
            if (n.getNodeType() != 7 || !n.getNodeName().equals("xindice-cache")) continue;
            cache = n.getNodeValue().trim();
            break;
        }
        return cache != null && cache.equals("cache");
    }

    public void setCaching(boolean caching) {
        int size = this.childNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = this.childNodes.item(i);
            if (n.getNodeType() != 7 || !n.getNodeName().equals("xindice-cache")) continue;
            n.setNodeValue(caching ? "cache" : "no-cache");
            return;
        }
        ProcessingInstruction pi = this.createProcessingInstruction("xindice-cache", caching ? "cache" : "no-cache");
        this.insertBefore(pi, this.getDocumentElement());
    }

    public SymbolTable getSymbols() {
        return this.symbols;
    }

    public void setSymbols(SymbolTable symbols) {
        this.symbols = symbols;
    }

    public void expandSource() {
        ElementImpl e = (ElementImpl)this.getDocumentElement();
        if (e != null) {
            e.expandSource();
        }
    }

    public Node getNodeAtPos(int pos) {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public DocumentType getDoctype() {
        return this.docType;
    }

    public void setDoctype(DocumentType docType) {
        this.docType = docType;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getInstance();
    }

    public Text createTextNode(String data) {
        return new TextImpl((NodeImpl)this, data);
    }

    public Element getDocumentElement() {
        this.checkLoaded();
        Iterator iterator = this.childNodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl((NodeImpl)this, data);
    }

    public Element createElement(String tagName) throws DOMException {
        return new ElementImpl((NodeImpl)this, tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Attr createAttribute(String name) throws DOMException {
        return new AttrImpl((NodeImpl)this, name);
    }

    public Comment createComment(String data) {
        return new CommentImpl((NodeImpl)this, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return new ProcessingInstructionImpl(this, target, data);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return new EntityReferenceImpl((NodeImpl)this, name);
    }

    private void importNamespaces(Node source, Node target) {
        if (target.getNodeType() == 1) {
            HashSet<String> set = new HashSet<String>();
            Node n = source;
            Element elem = (Element)target;
            while (n != null) {
                NamedNodeMap nm = n.getAttributes();
                for (int i = 0; i < nm.getLength(); ++i) {
                    Attr a = (Attr)nm.item(i);
                    String name = a.getNodeName();
                    if (!name.startsWith("xmlns:") && !name.equals("xmlns") || set.contains(name)) continue;
                    set.add(name);
                    elem.setAttribute(name, a.getValue());
                }
                if ((n = n.getParentNode()).getNodeType() != 9 && n.getNodeType() != 11) continue;
                n = null;
            }
        }
    }

    public Node importNode(Node importedNode, boolean deep) {
        return this.importNode(importedNode, deep, true);
    }

    private Node importNode(Node importedNode, boolean deep, boolean importNamespaces) {
        try {
            NodeImpl impl;
            DocumentImpl docImpl;
            if (importedNode instanceof NodeImpl && (docImpl = (DocumentImpl)(impl = (NodeImpl)importedNode).getOwnerDocument()).getSymbols() != null && docImpl.getSymbols() == this.symbols) {
                NodeImpl clone = (NodeImpl)impl.cloneNode(deep);
                clone.setParentNode(this);
                if (importNamespaces) {
                    this.importNamespaces(importedNode, clone);
                }
                return clone;
            }
            Node result = null;
            switch (importedNode.getNodeType()) {
                case 2: {
                    result = this.createAttribute(importedNode.getNodeName());
                    break;
                }
                case 4: {
                    result = this.createCDATASection(importedNode.getNodeValue());
                    break;
                }
                case 8: {
                    result = this.createComment(importedNode.getNodeValue());
                    break;
                }
                case 1: {
                    Element selem = (Element)importedNode;
                    Element elem = this.createElement(selem.getTagName());
                    NamedNodeMap attrs = selem.getAttributes();
                    int size = attrs.getLength();
                    for (int i = 0; i < size; ++i) {
                        Attr a = (Attr)attrs.item(i);
                        Attr ai = this.createAttribute(a.getName());
                        ai.setValue(a.getValue());
                        elem.setAttributeNode(ai);
                    }
                    result = elem;
                    if (!importNamespaces) break;
                    this.importNamespaces(importedNode, result);
                    break;
                }
                case 5: {
                    result = this.createEntityReference(importedNode.getNodeValue());
                    break;
                }
                case 7: {
                    result = this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
                    break;
                }
                case 3: {
                    result = this.createTextNode(importedNode.getNodeValue());
                    break;
                }
            }
            if (deep && result != null) {
                NodeList list = importedNode.getChildNodes();
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    Node n = list.item(i);
                    result.appendChild(this.importNode(n, deep, false));
                }
            }
            return result;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"ignored exception", (Throwable)e);
            }
            return null;
        }
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        return new ElementImpl((NodeImpl)this, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        return new AttrImpl((NodeImpl)this, qualifiedName);
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        return new TreeWalkerImpl(root, whatToShow, filter, entityReferenceExpansion);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        return new TreeWalkerImpl(root, whatToShow, filter, entityReferenceExpansion);
    }

    public Node adoptNode(Node src) {
        NodeImpl impl;
        DocumentImpl docImpl;
        if (src instanceof NodeImpl && ((docImpl = (DocumentImpl)(impl = (NodeImpl)src).getOwnerDocument()).getSymbols() == null || docImpl.getSymbols() == this.symbols)) {
            impl.getParentNode().removeChild(impl);
            impl.setParentNode(this);
            return impl;
        }
        return this.importNode(src, true);
    }

    public String getActualEncoding() {
        this.checkLoaded();
        return this.actualEncoding;
    }

    public void setActualEncoding(String actualEncoding) {
        this.checkReadOnly();
        this.checkLoaded();
        this.actualEncoding = actualEncoding;
    }

    public String getEncoding() {
        this.checkLoaded();
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.checkReadOnly();
        this.checkLoaded();
        this.encoding = encoding;
    }

    public String getVersion() {
        this.checkLoaded();
        return this.version;
    }

    public void setVersion(String version) {
        this.checkReadOnly();
        this.checkLoaded();
        this.version = version;
    }

    public boolean getStandalone() {
        this.checkLoaded();
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.checkReadOnly();
        this.checkLoaded();
        this.standalone = standalone;
    }

    public boolean getStrictErrorChecking() {
        this.checkLoaded();
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.checkReadOnly();
        this.checkLoaded();
        this.strictErrorChecking = strictErrorChecking;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

