/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.meta.inline;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.meta.inline.InlineHeaderBuilder;
import org.apache.xindice.core.meta.inline.InlineMetaException;
import org.apache.xindice.core.meta.inline.InlineMetaMap;
import org.apache.xindice.core.meta.inline.InlineMetaReader;
import org.apache.xindice.core.meta.inline.InlineMetaWriter;
import org.apache.xindice.core.meta.inline.NullReader;
import org.apache.xindice.core.meta.inline.ResourceTypeReader;
import org.apache.xindice.core.meta.inline.ResourceTypeWriter;

public class InlineMetaService {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$meta$inline$InlineMetaService == null ? (class$org$apache$xindice$core$meta$inline$InlineMetaService = InlineMetaService.class$("org.apache.xindice.core.meta.inline.InlineMetaService")) : class$org$apache$xindice$core$meta$inline$InlineMetaService));
    public static final InlineMetaReader[] readerByVersion = new InlineMetaReader[]{new NullReader(), new ResourceTypeReader()};
    public static final InlineMetaWriter currentWriter = new ResourceTypeWriter();
    public static final Class currentMapClass = class$org$apache$xindice$core$meta$inline$ResourceTypeReader$ResourceTypeMap == null ? (class$org$apache$xindice$core$meta$inline$ResourceTypeReader$ResourceTypeMap = InlineMetaService.class$("org.apache.xindice.core.meta.inline.ResourceTypeReader$ResourceTypeMap")) : class$org$apache$xindice$core$meta$inline$ResourceTypeReader$ResourceTypeMap;
    static /* synthetic */ Class class$org$apache$xindice$core$meta$inline$InlineMetaService;
    static /* synthetic */ Class class$org$apache$xindice$core$meta$inline$ResourceTypeReader$ResourceTypeMap;

    public InlineMetaMap getEmptyMap() {
        try {
            return (InlineMetaMap)currentMapClass.newInstance();
        }
        catch (Exception e) {
            String msg = "unable to create instance of current inline metadata map class '" + currentMapClass.getName() + "'";
            if (log.isFatalEnabled()) {
                log.fatal((Object)msg, (Throwable)e);
            }
            throw new IllegalStateException(msg);
        }
    }

    public Value createValue(InlineMetaMap map, byte[] data, int offset, int length) throws InlineMetaException {
        byte[] metadata = currentWriter.getMetadata(map);
        return InlineHeaderBuilder.createValue(currentWriter.getVersion(), metadata, data, offset, length);
    }

    public boolean haveReaderForVersion(int version) {
        return version < readerByVersion.length;
    }

    public DatabaseEntry readDatabaseEntry(Value rawValue) throws InlineMetaException {
        byte version;
        byte[] rawData = rawValue.getData();
        if (log.isDebugEnabled()) {
            log.debug((Object)("readDatabaseEntry: rawData: length=" + rawData.length + " byte 0: " + rawData[0] + " byte 1: " + rawData[1]));
        }
        if (!this.haveReaderForVersion(version = rawData[1])) {
            throw new InlineMetaException(70, "No inline metadata reader available for version " + version);
        }
        InlineMetaReader reader = readerByVersion[version];
        InlineMetaMap map = reader.read(rawData, 2, rawData[0] - 2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("readDatabaseEntry: map: type=" + map.get("type")));
        }
        Value value = new Value(rawData, rawData[0], rawData.length - rawData[0]);
        return new DatabaseEntry(map, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DatabaseEntry {
        public final InlineMetaMap map;
        public final Value value;

        public DatabaseEntry(InlineMetaMap map, Value value) {
            this.map = map;
            this.value = value;
        }
    }
}

