/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.filer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.core.filer.FilerException;
import org.apache.xindice.core.filer.Paged;

public final class HashFiler
extends Paged
implements Filer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$filer$HashFiler == null ? (class$org$apache$xindice$core$filer$HashFiler = HashFiler.class$("org.apache.xindice.core.filer.HashFiler")) : class$org$apache$xindice$core$filer$HashFiler));
    protected static final byte RECORD = 1;
    private static final String PAGECOUNT = "pagecount";
    private HashFileHeader fileHeader = (HashFileHeader)this.getFileHeader();
    static /* synthetic */ Class class$org$apache$xindice$core$filer$HashFiler;

    public void setLocation(File root, String location) {
        this.setFile(new File(root, location + ".tbl"));
    }

    public String getName() {
        return "HashFiler";
    }

    public boolean create() throws DBException {
        this.fileHeader.setPageCount(this.getConfig().getLongAttribute(PAGECOUNT, this.fileHeader.getPageCount()));
        return super.create();
    }

    private Paged.Page seekRecordPage(Key key) throws IOException {
        Paged.Page p;
        int hash = key.getHash();
        long pageNum = (long)hash % this.fileHeader.getPageCount();
        Paged.Page page = p = this.getPage(pageNum);
        synchronized (page) {
            HashPageHeader ph = null;
            while (true) {
                if ((ph = (HashPageHeader)p.getPageHeader()).getStatus() == 1 && ph.getKeyHash() == key.getHash() && p.getKey().equals(key)) {
                    return p;
                }
                pageNum = ph.getNextCollision();
                if (pageNum == -1L) {
                    return null;
                }
                p = this.getPage(pageNum);
            }
        }
    }

    public Record readRecord(Key key) throws DBException {
        block4: {
            if (key == null || key.getLength() == 0) {
                return null;
            }
            this.checkOpened();
            try {
                Paged.Page startPage = this.seekRecordPage(key);
                if (startPage != null) {
                    Value v = this.readValue(startPage);
                    HashPageHeader sph = (HashPageHeader)startPage.getPageHeader();
                    HashMap<String, Long> meta = new HashMap<String, Long>(2);
                    meta.put("created", new Long(sph.getCreated()));
                    meta.put("modified", new Long(sph.getModified()));
                    return new Record(key, v, meta);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Paged.Page seekInsertionPage(Key key) throws IOException {
        Paged.Page p;
        int hash = key.getHash();
        long pageNum = (long)hash % this.fileHeader.getPageCount();
        Paged.Page page = p = this.getPage(pageNum);
        synchronized (page) {
            HashPageHeader ph;
            while (!((ph = (HashPageHeader)p.getPageHeader()).getStatus() == 0 || ph.getStatus() == 127 || ph.getStatus() == 1 && ph.getKeyHash() == key.getHash() && p.getKey().equals(key))) {
                pageNum = ph.getNextCollision();
                if (pageNum == -1L) {
                    Paged.Page np = this.getFreePage();
                    ph.setNextCollision(np.getPageNum());
                    p.write();
                    p = np;
                    ph = (HashPageHeader)p.getPageHeader();
                    ph.setNextCollision(-1L);
                    break;
                }
                p = this.getPage(pageNum);
            }
            long t = System.currentTimeMillis();
            if (ph.getStatus() == 0 || ph.getStatus() == 127) {
                this.fileHeader.incRecordCount();
                ph.setCreated(t);
            }
            ph.setModified(t);
            ph.setStatus((byte)1);
            p.write();
        }
        return p;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeRecord(Key key, Value value) throws DBException {
        block9: {
            if (key == null) throw new FilerException(571, "Invalid key: '" + key + "'");
            if (key.getLength() == 0) throw new FilerException(571, "Invalid key: '" + key + "'");
            if (key.getLength() > this.fileHeader.getPageSize() - this.fileHeader.getPageHeaderSize()) {
                throw new FilerException(571, "Invalid key: '" + key + "'");
            }
            if (value == null) {
                throw new FilerException(571, "Invalid null value");
            }
            this.checkOpened();
            Paged.Page p = null;
            try {
                try {
                    p = this.seekInsertionPage(key);
                    p.setKey(key);
                    this.writeValue(p, value);
                    p = null;
                }
                catch (Exception e) {
                    throw new FilerException(571, "Exception: " + e);
                }
                Object var6_4 = null;
                if (p == null) break block9;
                p.getPageHeader().setStatus((byte)127);
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (p == null) throw throwable;
                p.getPageHeader().setStatus((byte)127);
                try {
                    p.write();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            p.write();
        }
        this.flush();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return false;
        }
        this.checkOpened();
        try {
            Paged.Page page;
            int hash = key.getHash();
            long pageNum = (long)hash % this.fileHeader.getPageCount();
            Paged.Page page2 = page = this.getPage(pageNum);
            synchronized (page2) {
                HashPageHeader prevHead = null;
                HashPageHeader pageHead = null;
                Paged.Page prev = null;
                while ((pageHead = (HashPageHeader)page.getPageHeader()).getStatus() != 1 || pageHead.getKeyHash() != key.getHash() || !page.getKey().equals(key)) {
                    pageNum = pageHead.getNextCollision();
                    if (pageNum == -1L) {
                        return false;
                    }
                    prev = page;
                    prevHead = pageHead;
                    page = this.getPage(pageNum);
                }
                if (prev != null) {
                    prevHead.setNextCollision(pageHead.nextCollision);
                    pageHead.setNextCollision(-1L);
                    prev.write();
                }
                this.unlinkPages(page);
            }
            this.fileHeader.decRecordCount();
            this.flush();
            return true;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"ignored exception", (Throwable)e);
            }
            return false;
        }
    }

    public long getRecordCount() throws DBException {
        this.checkOpened();
        return this.fileHeader.getRecordCount();
    }

    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new HashFilerRecordSet();
    }

    public void flush() throws DBException {
        super.flush();
    }

    public Paged.FileHeader createFileHeader() {
        return new HashFileHeader();
    }

    public Paged.FileHeader createFileHeader(boolean read) throws IOException {
        return new HashFileHeader(read);
    }

    public Paged.FileHeader createFileHeader(long pageCount) {
        return new HashFileHeader(pageCount);
    }

    public Paged.FileHeader createFileHeader(long pageCount, int pageSize) {
        return new HashFileHeader(pageCount, pageSize);
    }

    public Paged.PageHeader createPageHeader() {
        return new HashPageHeader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class HashPageHeader
    extends Paged.PageHeader {
        private long created = 0L;
        private long modified = 0L;
        private long nextCollision = -1L;

        public HashPageHeader() {
        }

        public HashPageHeader(DataInput dis) throws IOException {
            super(dis);
        }

        public synchronized void read(DataInput dis) throws IOException {
            super.read(dis);
            if (this.getStatus() == 0) {
                return;
            }
            this.created = dis.readLong();
            this.modified = dis.readLong();
            this.nextCollision = dis.readLong();
        }

        public synchronized void write(DataOutput dos) throws IOException {
            super.write(dos);
            dos.writeLong(this.created);
            dos.writeLong(this.modified);
            dos.writeLong(this.nextCollision);
        }

        public synchronized void setRecordLen(int recordLen) {
            HashFiler.this.fileHeader.setTotalBytes(HashFiler.this.fileHeader.totalBytes - (long)this.getRecordLen() + (long)recordLen);
            super.setRecordLen(recordLen);
        }

        public synchronized void setCreated(long created) {
            this.created = created;
            this.setDirty();
        }

        public synchronized long getCreated() {
            return this.created;
        }

        public synchronized void setModified(long modified) {
            this.modified = modified;
            this.setDirty();
        }

        public synchronized long getModified() {
            return this.modified;
        }

        public synchronized void setNextCollision(long nextCollision) {
            this.nextCollision = nextCollision;
            this.setDirty();
        }

        public synchronized long getNextCollision() {
            return this.nextCollision;
        }
    }

    private final class HashFileHeader
    extends Paged.FileHeader {
        private long totalBytes = 0L;

        public HashFileHeader() {
            super(HashFiler.this);
        }

        public HashFileHeader(long pageCount) {
            super((Paged)HashFiler.this, pageCount);
        }

        public HashFileHeader(long pageCount, int pageSize) {
            super(HashFiler.this, pageCount, pageSize);
        }

        public HashFileHeader(boolean read) throws IOException {
            super((Paged)HashFiler.this, read);
        }

        public synchronized void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.totalBytes = raf.readLong();
        }

        public synchronized void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeLong(this.totalBytes);
        }

        public synchronized void setTotalBytes(long totalBytes) {
            this.totalBytes = totalBytes;
            this.setDirty();
        }

        public synchronized long getTotalBytes() {
            return this.totalBytes;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class HashFilerRecordSet
    implements RecordSet {
        private List keys;
        private Iterator enum;

        public HashFilerRecordSet() {
            block3: {
                this.keys = new ArrayList();
                try {
                    Paged.Page p = null;
                    HashPageHeader ph = null;
                    for (long pageNum = 0L; pageNum < HashFiler.this.fileHeader.getTotalCount(); ++pageNum) {
                        p = HashFiler.this.getPage(pageNum);
                        ph = (HashPageHeader)p.getPageHeader();
                        if (ph.getStatus() != 1) continue;
                        this.keys.add(p.getKey());
                    }
                    this.enum = this.keys.iterator();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }

        public synchronized Key getNextKey() {
            return (Key)this.enum.next();
        }

        public synchronized Record getNextRecord() throws DBException {
            return HashFiler.this.readRecord((Key)this.enum.next());
        }

        public synchronized Value getNextValue() throws DBException {
            return this.getNextRecord().getValue();
        }

        public synchronized boolean hasMoreRecords() {
            return this.enum.hasNext();
        }
    }
}

