/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.CollectionManager;
import org.apache.xindice.core.Container;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.DBObject;
import org.apache.xindice.core.DBObserver;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.DocumentCache;
import org.apache.xindice.core.MetaSystemCollection;
import org.apache.xindice.core.SystemCollection;
import org.apache.xindice.core.data.DocumentSet;
import org.apache.xindice.core.data.EmptyDocumentSet;
import org.apache.xindice.core.data.EmptyNodeSet;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.core.indexer.IndexManager;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.core.meta.MetaData;
import org.apache.xindice.core.meta.inline.InlineMetaMap;
import org.apache.xindice.core.meta.inline.InlineMetaService;
import org.apache.xindice.core.meta.inline.ResourceTypeReader;
import org.apache.xindice.core.query.QueryEngine;
import org.apache.xindice.util.Configurable;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.Named;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.NodeSource;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.TextWriter;
import org.apache.xindice.xml.XMLSerializable;
import org.apache.xindice.xml.dom.DBDocument;
import org.apache.xindice.xml.dom.DOMCompressor;
import org.apache.xindice.xml.dom.DOMParser;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class Collection
extends CollectionManager
implements Named,
DBObject,
Configurable {
    private static final Log log;
    private static final String CACHE = "cache";
    private static final String CLASS = "class";
    private static final String CLASSNAME = "xindice-class";
    private static final String COMPRESSED = "compressed";
    private static final String FILER = "filer";
    private static final String INDEXES = "indexes";
    private static final String INLINE_METADATA = "inline-metadata";
    private static final String NAME = "name";
    private static final String SYMBOLS = "symbols";
    private static final DocumentSet EMPTY_DOCUMENTSET;
    private static final NodeSet EMPTY_NODESET;
    private static final String[] EMPTY_STRING_ARRAY;
    private static int host_id;
    private String canonicalName;
    private int collectionId;
    private File collectionRoot;
    private boolean compressed;
    private long documentId = System.currentTimeMillis();
    private DocumentCache documentCache;
    private Filer filer;
    private IndexManager indexManager;
    private InlineMetaService inlineMetaService;
    private boolean internalSymbols;
    private String name;
    private final Object oidMutex = new Object();
    private String oidTemplate;
    private Collection parent;
    private SymbolTable symbols;
    static /* synthetic */ Class class$org$apache$xindice$core$Collection;

    protected Collection() {
    }

    public Collection(Collection parentCollection) {
        this.parent = parentCollection;
    }

    private void checkFiler(int faultCode) throws DBException {
        if (this.filer == null) {
            throw new DBException(faultCode, "Collection '" + this.name + "' cannot store resources (no filer)");
        }
    }

    public boolean close() throws DBException {
        if (this.filer != null) {
            this.indexManager.close();
            this.filer.close();
        }
        super.close();
        return true;
    }

    public boolean create() throws DBException {
        this.updateCollectionMeta();
        DBObserver.getInstance().createCollection(this);
        return true;
    }

    public final Collection createCollection(String path, Configuration config) throws DBException {
        Collection col = super.createCollection(path, config);
        this.getDatabase().flushConfig();
        return col;
    }

    public final Indexer createIndexer(Configuration config) throws DBException {
        this.checkFiler(242);
        Indexer idx = this.indexManager.create(config);
        this.getDatabase().flushConfig();
        return idx;
    }

    protected final Key createNewKey(Object key) {
        if (key == null) {
            return this.createNewOID();
        }
        if (key instanceof Key) {
            return (Key)key;
        }
        return new Key(key.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Key createNewOID() {
        long ct = System.currentTimeMillis();
        Object object = this.oidMutex;
        synchronized (object) {
            if (ct <= this.documentId) {
                ct = this.documentId + 1L;
            }
            this.documentId = ct;
        }
        StringBuffer sb = new StringBuffer(this.oidTemplate);
        String document = Long.toString(this.documentId, 16);
        sb.insert(32 - document.length(), document);
        sb.setLength(32);
        return new Key(sb.toString());
    }

    private String debugHeader() {
        return "[" + Thread.currentThread().getName() + "] '" + (this.parent != null ? this.parent.getCanonicalName() : "") + "/" + this.name + "' ";
    }

    public boolean drop() throws DBException {
        if (this == this.getDatabase()) {
            throw new DBException(570, "You cannot drop the database");
        }
        DBObserver.getInstance().dropCollection(this);
        if (this.isMetaEnabled()) {
            this.getMetaSystemCollection().dropCollectionMeta(this);
        }
        String[] cols = this.listCollections();
        for (int i = 0; i < cols.length; ++i) {
            this.dropCollection(this.getCollection(cols[i]));
        }
        if (this.filer != null) {
            this.indexManager.drop();
            this.filer.drop();
        }
        this.getCollectionRoot().delete();
        if (!this.internalSymbols) {
            this.getSystemCollection().dropSymbols(this);
        }
        this.getDatabase().flushConfig();
        return true;
    }

    public final boolean dropCollection(Collection collection) throws DBException {
        boolean success = super.dropCollection(collection);
        this.getDatabase().flushConfig();
        return success;
    }

    public final boolean dropIndexer(Indexer index) throws DBException {
        this.checkFiler(242);
        if (index == null) {
            throw new DBException(301, "Index value is null");
        }
        boolean success = this.indexManager.drop(index.getName());
        this.getDatabase().flushConfig();
        return success;
    }

    public boolean exists() throws DBException {
        return true;
    }

    public final void flushSymbolTable() throws DBException {
        if (this.symbols.isDirty() && !this.internalSymbols) {
            this.getSystemCollection().saveSymbols(this, this.symbols);
        }
    }

    public final byte[] getBinary(Object key) throws DBException {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.debugHeader() + "Get binary: " + key));
        }
        if (this.inlineMetaService == null) {
            throw new DBException(201, "Collection '" + this.getCanonicalName() + "' has no binary resources (inline metadata is not enabled)");
        }
        Object entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        if (!(entry instanceof byte[])) {
            throw new DBException(277, "Resource '" + key + "' in collection '" + this.getCanonicalName() + "' is not a binary resource");
        }
        return (byte[])entry;
    }

    public final String getCanonicalDocumentName(Key key) {
        return this.getCanonicalDocumentName(key.toString());
    }

    public final String getCanonicalDocumentName(String key) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.canonicalName);
        sb.append('/');
        sb.append(key);
        return sb.toString();
    }

    public final String getCanonicalName() {
        return this.canonicalName;
    }

    public MetaData getCollectionMeta() throws DBException {
        if (!this.isMetaEnabled()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Meta information requested but not enabled in config!");
            }
            return null;
        }
        MetaSystemCollection metacol = this.getMetaSystemCollection();
        MetaData meta = metacol.getCollectionMeta(this);
        if (null == meta) {
            long now = System.currentTimeMillis();
            meta = new MetaData(1, this.getCanonicalName(), now, now);
            metacol.setCollectionMeta(this, meta);
        }
        return meta;
    }

    public final File getCollectionRoot() {
        return this.collectionRoot;
    }

    public final Container getContainer(Object docKey) throws DBException {
        Key key = this.createNewKey(docKey);
        Document doc = this.getDocument(key);
        return doc != null ? new ColContainer(key, doc) : null;
    }

    public Database getDatabase() {
        return this.parent.getDatabase();
    }

    public final Document getDocument(Object key) throws DBException {
        Object entry;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.debugHeader() + "Get document: " + key));
        }
        if ((entry = this.getEntry(key)) == null) {
            return null;
        }
        if (!(entry instanceof Document)) {
            throw new DBException(277, "Resource '" + key + "' in collection '" + this.getCanonicalName() + "' is not a document");
        }
        return (Document)entry;
    }

    public final long getDocumentCount() throws DBException {
        return null == this.filer ? 0L : this.filer.getRecordCount();
    }

    public MetaData getDocumentMeta(String id) throws DBException {
        if (!this.isMetaEnabled()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Meta information requested but not enabled in config!");
            }
            return null;
        }
        if (null == this.getEntry(id)) {
            throw new DBException(201, "Resource '" + id + "' does not exist in '" + this.getCanonicalName() + "'");
        }
        MetaSystemCollection metacol = this.getMetaSystemCollection();
        MetaData meta = metacol.getDocumentMeta(this, id);
        long now = System.currentTimeMillis();
        if (null == meta) {
            meta = new MetaData(2, this.getCanonicalDocumentName(id), now, now);
            metacol.setDocumentMeta(this, id, meta);
        } else if (!meta.hasContext()) {
            meta.setContext(now, now);
        }
        return meta;
    }

    public final DocumentSet getDocumentSet() throws DBException {
        return null == this.filer ? EMPTY_DOCUMENTSET : new ColDocumentSet(this.filer.getRecordSet());
    }

    public final Object getEntry(Object docKey) throws DBException {
        Value value;
        Document document;
        if (docKey == null) {
            return null;
        }
        String localDebugHeader = null;
        if (log.isTraceEnabled()) {
            localDebugHeader = this.debugHeader() + "getEntry: docKey=<" + docKey + ">: ";
            log.trace((Object)localDebugHeader);
        }
        this.checkFiler(242);
        Key key = this.createNewKey(docKey);
        if (this.documentCache != null && (document = this.documentCache.getDocument(this, key)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(localDebugHeader + "Returning cached: " + document));
            }
            return document;
        }
        Record record = this.filer.readRecord(key);
        if (record == null) {
            return null;
        }
        InlineMetaMap metaMap = null;
        if (this.inlineMetaService == null) {
            value = record.getValue();
            if (log.isTraceEnabled()) {
                log.trace((Object)(localDebugHeader + "Type is not available, Length=" + value.getLength()));
            }
        } else {
            InlineMetaService.DatabaseEntry databaseEntry = this.inlineMetaService.readDatabaseEntry(record.getValue());
            metaMap = databaseEntry.map;
            value = databaseEntry.value;
            if (log.isTraceEnabled()) {
                log.trace((Object)(localDebugHeader + "Type=" + metaMap.get("type") + ", Length=" + value.getLength()));
            }
        }
        if (this.inlineMetaService == null || metaMap.get("type").equals(ResourceTypeReader.XML)) {
            Document document2;
            if (this.compressed) {
                document2 = new DocumentImpl(value.getData(), this.symbols, new NodeSource(this, key));
                this.flushSymbolTable();
                if (log.isTraceEnabled()) {
                    log.trace((Object)(localDebugHeader + "Compressed XML document=<" + TextWriter.toString(document2) + ">"));
                }
                if (this.documentCache != null) {
                    this.documentCache.putDocument(this, key, value.getData());
                }
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(localDebugHeader + "Pre parseDocument(): value=<" + value + ">"));
                }
                document2 = this.parseDocument(key, value.toString());
            }
            DBObserver.getInstance().loadDocument(this, record, document2);
            return document2;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(localDebugHeader + "Binary document"));
        }
        return value.getData();
    }

    public final Filer getFiler() {
        return this.filer;
    }

    public final Indexer getIndexer(String name) throws DBException {
        this.checkFiler(242);
        return this.indexManager.get(name);
    }

    public final IndexManager getIndexManager() throws DBException {
        this.checkFiler(242);
        return this.indexManager;
    }

    private MetaSystemCollection getMetaSystemCollection() {
        return this.getDatabase().getMetaSystemCollection();
    }

    public final String getName() {
        return this.name;
    }

    public final XMLSerializable getObject(Object key) throws DBException {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.debugHeader() + "Get object: " + key));
            }
            String className = null;
            Document doc = this.getDocument(key);
            if (doc != null) {
                NodeList childNodes = doc.getChildNodes();
                int size = childNodes.getLength();
                for (int i = 0; i < size; ++i) {
                    Node n = childNodes.item(i);
                    if (n.getNodeType() != 7 || !n.getNodeName().equals(CLASSNAME)) continue;
                    className = n.getNodeValue().trim();
                    break;
                }
                if (className != null) {
                    try {
                        XMLSerializable obj = (XMLSerializable)Class.forName(className).newInstance();
                        obj.streamFromXML(doc.getDocumentElement());
                        return obj;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block6;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public final Collection getParentCollection() throws DBException {
        return this.parent;
    }

    public QueryEngine getQueryEngine() throws DBException {
        return this.getDatabase().getQueryEngine();
    }

    public final SymbolTable getSymbols() throws DBException {
        return this.symbols;
    }

    public SystemCollection getSystemCollection() throws DBException {
        return this.getDatabase().getSystemCollection();
    }

    public Key insertBinary(byte[] bytes) throws DBException {
        return this.insertBinary(null, bytes);
    }

    public Key insertBinary(Object docKey, byte[] bytes) throws DBException {
        if (this.inlineMetaService == null) {
            throw new DBException(244, "Cannot insert a binary resource in '" + this.getCanonicalName() + "' (inline-metadata is not enabled)");
        }
        Key key = this.createNewKey(docKey);
        if (log.isInfoEnabled()) {
            log.info((Object)(this.debugHeader() + "Insert binary: " + key));
        }
        this.putBinary(key, bytes, true);
        this.updateCollectionMeta();
        return key;
    }

    public final Key insertDocument(Document document) throws DBException {
        return this.insertDocument(null, document);
    }

    public final Key insertDocument(Object docKey, Document document) throws DBException {
        Key key = this.createNewKey(docKey);
        if (log.isInfoEnabled()) {
            log.info((Object)(this.debugHeader() + "Insert document: " + key));
        }
        this.putDocument(key, document);
        this.updateCollectionMeta();
        return key;
    }

    public final Key insertObject(XMLSerializable obj) throws DBException {
        return this.insertObject(null, obj);
    }

    public final Key insertObject(String objKey, XMLSerializable obj) throws DBException {
        Key key = this.createNewKey(objKey);
        if (log.isInfoEnabled()) {
            log.info((Object)(this.debugHeader() + "Insert object: " + key));
        }
        this.putObject(key, obj);
        this.updateCollectionMeta();
        return key;
    }

    public boolean isMetaEnabled() {
        return this.getDatabase().isMetaEnabled();
    }

    public boolean isOpened() throws DBException {
        return true;
    }

    public final String[] listDocuments() throws DBException {
        if (null == this.filer) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> temp = new ArrayList<String>((int)this.filer.getRecordCount());
        RecordSet set = this.filer.getRecordSet();
        while (set.hasMoreRecords()) {
            Key key = set.getNextKey();
            temp.add(key.toString());
        }
        return temp.toArray(new String[0]);
    }

    public final String[] listIndexers() throws DBException {
        this.checkFiler(242);
        return this.indexManager.list();
    }

    public final boolean open() throws DBException {
        return true;
    }

    private Document parseDocument(Key key, String xml) throws DBException {
        Document doc = null;
        try {
            doc = DOMParser.toDocument(xml);
            byte[] b = DOMCompressor.Compress(doc, this.symbols);
            doc = new DocumentImpl(b, this.symbols, new NodeSource(this, key));
            if (this.documentCache != null) {
                this.documentCache.putDocument(this, key, b);
            }
        }
        catch (Exception e) {
            throw new DBException(243, "Unable to parse document '" + key + "' in '" + this.getCanonicalName() + "'", e);
        }
        return doc;
    }

    private void putBinary(Key key, byte[] bytes, boolean create) throws DBException {
        byte[] storedBytes;
        if (!create && (storedBytes = this.getBinary(key)) == null) {
            throw new DBException(244, "Error storing binary resource '" + key + "' in '" + this.getCanonicalName() + "': the 'create' flag is false and the key is already in database");
        }
        InlineMetaMap map = this.inlineMetaService.getEmptyMap();
        map.put("type", ResourceTypeReader.BINARY);
        Value value = this.inlineMetaService.createValue(map, bytes, 0, bytes.length);
        this.filer.writeRecord(key, value);
        this.updateDocumentMeta(key.toString());
    }

    /*
     * Unable to fully structure code
     */
    private void putDocument(Key key, Document document) throws DBException {
        localDebugHeader = this.debugHeader() + "putDocument: docKey=<" + key + ">: ";
        if (Collection.log.isTraceEnabled()) {
            Collection.log.trace((Object)(localDebugHeader + "document=<" + TextWriter.toString(document) + ">"));
        }
        this.checkFiler(242);
        if (document instanceof DBDocument && (dbDoc = (DBDocument)document).getSource() == null) {
            dbDoc.setSource(new NodeSource(this, key));
        }
        documentBytes = null;
        if (this.compressed) {
            try {
                documentBytes = DOMCompressor.Compress(document, this.symbols);
                if (Collection.log.isTraceEnabled()) {
                    Collection.log.trace((Object)(localDebugHeader + "length=" + documentBytes.length));
                }
                document = new DocumentImpl(documentBytes, this.symbols, new NodeSource(this, key));
                if (!Collection.log.isTraceEnabled()) ** GOTO lbl26
                Collection.log.trace((Object)(localDebugHeader + "packedDocument: length=" + documentBytes.length + " document=<" + TextWriter.toString(document) + ">"));
            }
            catch (Exception e) {
                throw new DBException(244, localDebugHeader + "Error compressing Document '" + key + "'", e);
            }
        } else {
            try {
                documentBytes = TextWriter.toString(document).getBytes("utf-8");
                if (Collection.log.isTraceEnabled()) {
                    Collection.log.trace((Object)(localDebugHeader + "utf8Document: length=" + documentBytes.length + " document=<" + new String(documentBytes, "utf-8") + ">"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new DBException(90, "utf-8 encoding not supported", e);
            }
        }
lbl26:
        // 3 sources

        this.flushSymbolTable();
        oldDoc = this.getDocument(key);
        if (oldDoc != null) {
            this.indexManager.removeDocument(key, oldDoc);
        }
        this.indexManager.addDocument(key, document);
        if (this.inlineMetaService == null) {
            value = new Value(documentBytes);
        } else {
            map = this.inlineMetaService.getEmptyMap();
            map.put("type", ResourceTypeReader.XML);
            value = this.inlineMetaService.createValue(map, documentBytes, 0, documentBytes.length);
        }
        this.filer.writeRecord(key, value);
        if (this.documentCache != null) {
            if (this.compressed) {
                this.documentCache.putDocument(this, key, documentBytes);
            } else {
                this.documentCache.putDocument(this, key, document);
            }
        }
        this.updateDocumentMeta(key.toString());
        DBObserver.getInstance().putDocument(this, key, document, oldDoc == null);
    }

    private void putObject(Key key, XMLSerializable obj) throws DBException {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.debugHeader() + "putObject: key=<" + key + "> class=<" + obj.getClass().getName() + ">"));
        }
        DocumentImpl doc = new DocumentImpl();
        ProcessingInstruction pi = doc.createProcessingInstruction(CLASSNAME, obj.getClass().getName());
        doc.appendChild(pi);
        Element elem = obj.streamToXML(doc);
        doc.appendChild(elem);
        this.putDocument(key, doc);
    }

    public final NodeSet queryCollection(String style, String query, NamespaceMap nsMap) throws DBException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.debugHeader() + "Query collection, query " + query));
        }
        return null == this.filer ? EMPTY_NODESET : this.getQueryEngine().query(this, style, query, nsMap, null);
    }

    public final NodeSet queryDocument(String style, String query, NamespaceMap nsMap, Object key) throws DBException {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.debugHeader() + "Query document " + key + ", query: " + query));
        }
        this.checkFiler(671);
        Key[] k = null;
        k = key instanceof Key[] ? (Key[])key : new Key[]{this.createNewKey(key)};
        return this.getQueryEngine().query(this, style, query, nsMap, k);
    }

    public final void remove(Object key) throws DBException {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.debugHeader() + "Remove " + key));
        }
        this.checkFiler(242);
        Key objKey = this.createNewKey(key);
        Object oldDoc = this.getEntry(objKey);
        if (oldDoc != null && oldDoc instanceof Document) {
            this.indexManager.removeDocument(objKey, (Document)oldDoc);
        }
        if (this.documentCache != null) {
            this.documentCache.removeDocument(this, objKey);
        }
        if (!this.filer.deleteRecord(objKey)) {
            throw new DBException(201, "Resource '" + objKey + "' does not exist in '" + this.getCanonicalName() + "'");
        }
        this.updateCollectionMeta();
        if (this.isMetaEnabled()) {
            this.getMetaSystemCollection().dropDocumentMeta(this, objKey.toString());
        }
        DBObserver.getInstance().dropDocument(this, objKey);
    }

    protected final void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        this.collectionId = Math.abs(canonicalName.hashCode());
        StringBuffer sb = new StringBuffer("00000000000000000000000000000000");
        String host = Integer.toString(host_id, 16);
        String collection = Integer.toString(this.collectionId, 16);
        sb.insert(8 - host.length(), host);
        sb.insert(16 - collection.length(), collection);
        sb.setLength(32);
        this.oidTemplate = sb.toString();
    }

    public void setCollectionMeta(MetaData meta) throws DBException {
        if (!this.isMetaEnabled()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Meta information requested but not enabled in config!");
            }
            return;
        }
        if (null != meta) {
            if (meta.getType() != 1) {
                throw new DBException(0, "Mismatch type of meta data for collection " + this.getCanonicalName());
            }
            MetaSystemCollection metacol = this.getMetaSystemCollection();
            MetaData current = metacol.getCollectionMeta(this);
            current.copyDataFrom(meta);
            metacol.setCollectionMeta(this, current);
        }
    }

    protected final void setCollectionRoot(File collectionRoot) {
        this.collectionRoot = collectionRoot;
        if (!collectionRoot.exists()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating directories: " + collectionRoot));
            }
            collectionRoot.mkdirs();
        }
    }

    public void setConfig(Configuration config) throws XindiceException {
        block24: {
            Configuration filerConfig;
            this.name = config.getAttribute(NAME);
            this.compressed = config.getBooleanAttribute(COMPRESSED, true);
            if (config.getBooleanAttribute(INLINE_METADATA, false)) {
                this.inlineMetaService = new InlineMetaService();
            }
            String localDebugHeader = this.debugHeader() + "setConfig: ";
            if (this.parent != null) {
                this.setCanonicalName(this.parent.getCanonicalName() + '/' + this.name);
                this.setCollectionRoot(new File(this.parent.getCollectionRoot(), this.name));
                if (log.isDebugEnabled()) {
                    log.debug((Object)(localDebugHeader + "Root=<" + this.getCollectionRoot() + ">"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(localDebugHeader + (this.compressed ? "Compressed" : "NOT Compressed") + ", " + (this.inlineMetaService == null ? "Inline metadata DISABLED" : "Inline metadata ENABLED")));
            }
            if (config.getBooleanAttribute(CACHE, true)) {
                this.documentCache = this.getDatabase().getDocumentCache();
            }
            if ((filerConfig = config.getChild(FILER)) != null) {
                block23: {
                    block22: {
                        Configuration symConfig;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(localDebugHeader + "Have filer config..."));
                        }
                        boolean bl = this.internalSymbols = (symConfig = config.getChild(SYMBOLS)) != null;
                        if (this.internalSymbols) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(localDebugHeader + "Internal symbols=<" + TextWriter.toString(symConfig.getElement()) + ">"));
                            }
                            try {
                                this.symbols = new SymbolTable(symConfig.getElement());
                            }
                            catch (Exception e) {
                                if (log.isWarnEnabled()) {
                                    log.warn((Object)(localDebugHeader + "Error building symbol table from internal symbols"), (Throwable)e);
                                }
                                break block22;
                            }
                        }
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(localDebugHeader + "No internal symbols..."));
                        }
                        try {
                            this.symbols = this.getSystemCollection().loadSymbols(this);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(localDebugHeader + "Loaded symbols=<" + TextWriter.toString(this.symbols.streamToXML(new DocumentImpl())) + ">"));
                            }
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block22;
                            log.warn((Object)(localDebugHeader + "Error building symbol table from system collection"), (Throwable)e);
                        }
                    }
                    String className = filerConfig.getAttribute(CLASS);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(localDebugHeader + "Filer class=<" + className + ">"));
                    }
                    try {
                        this.filer = (Filer)Class.forName(className).newInstance();
                        this.filer.setLocation(this.getCollectionRoot(), this.getName());
                        this.filer.setConfig(filerConfig);
                        if (!this.filer.exists()) {
                            this.filer.create();
                        }
                        this.filer.open();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block23;
                        log.warn((Object)("Filer '" + className + "' is not available"), (Throwable)e);
                    }
                }
                try {
                    this.indexManager = new IndexManager(this);
                    Configuration idxConfig = config.getChild(INDEXES, true);
                    this.indexManager.setConfig(idxConfig);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block24;
                    log.warn((Object)"Failed to initialize indexer", (Throwable)e);
                }
            }
        }
        super.setConfig(config);
        DBObserver.getInstance().setCollectionConfig(this, config);
    }

    public final void setDocument(Object docKey, Document document) throws DBException {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.debugHeader() + "Set document " + docKey));
        }
        this.putDocument(this.createNewKey(docKey), document);
    }

    public void setDocumentMeta(String id, MetaData meta) throws DBException {
        if (!this.isMetaEnabled()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Meta information requested but not enabled in config!");
            }
            return;
        }
        Object obj = this.getEntry(id);
        if (null == obj) {
            throw new DBException(201, "Resource '" + id + "' does not exist in '" + this.getCanonicalName() + "'");
        }
        if (null != meta) {
            if (meta.getType() == 0 || meta.getType() == 1) {
                throw new DBException(0, "Mismatch type of meta data for document " + this.getCanonicalDocumentName(id));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(this.debugHeader() + "Set document meta " + id));
            }
            MetaSystemCollection metacol = this.getMetaSystemCollection();
            MetaData current = metacol.getDocumentMeta(this, id);
            current.copyDataFrom(meta);
            metacol.setDocumentMeta(this, id, current);
        }
    }

    protected void setName(String string) {
        this.name = string;
    }

    public final void setObject(Object key, XMLSerializable obj) throws DBException {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.debugHeader() + "Set object " + key));
        }
        this.putObject(this.createNewKey(key), obj);
    }

    protected void updateCollectionMeta() {
        if (this.isMetaEnabled()) {
            MetaSystemCollection metacol = this.getMetaSystemCollection();
            MetaData meta = null;
            try {
                meta = metacol.getCollectionMeta(this);
            }
            catch (DBException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Error fetching meta for collection '" + this.getCanonicalName() + "'"), (Throwable)e);
                }
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(this.debugHeader() + "Updating modified time for collection"));
            }
            long now = System.currentTimeMillis();
            if (null == meta) {
                meta = new MetaData(1, this.getCanonicalName(), now, now);
            } else if (!meta.hasContext()) {
                meta.setContext(now, now);
            } else {
                meta.setContext(0L, now);
            }
            try {
                metacol.setCollectionMeta(this, meta);
            }
            catch (DBException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Error setting meta for collection '" + this.getCanonicalName() + "'"), (Throwable)e);
                }
                return;
            }
        }
    }

    protected void updateDocumentMeta(String id) throws DBException {
        if (!this.isMetaEnabled()) {
            return;
        }
        Object obj = this.getEntry(id);
        if (null == obj) {
            throw new DBException(201, "Resource '" + id + "' does not exist in '" + this.getCanonicalName() + "'");
        }
        MetaSystemCollection metacol = this.getMetaSystemCollection();
        MetaData meta = metacol.getDocumentMeta(this, id);
        String path = this.getCanonicalDocumentName(id);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.debugHeader() + "Updating modified time for document '" + id + "'"));
        }
        long now = System.currentTimeMillis();
        if (null == meta) {
            meta = new MetaData(2, path, now, now);
        } else if (!meta.hasContext()) {
            meta.setContext(now, now);
        } else {
            meta.setContext(0L, now);
        }
        metacol.setDocumentMeta(this, id, meta);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            log = LogFactory.getLog((Class)(class$org$apache$xindice$core$Collection == null ? (class$org$apache$xindice$core$Collection = Collection.class$("org.apache.xindice.core.Collection")) : class$org$apache$xindice$core$Collection));
            EMPTY_DOCUMENTSET = new EmptyDocumentSet();
            EMPTY_NODESET = new EmptyNodeSet();
            EMPTY_STRING_ARRAY = new String[0];
            try {
                InetAddress a = InetAddress.getLocalHost();
                byte[] b = a.getAddress();
                host_id = 0;
                host_id += b[0];
                host_id += b[1] << 8;
                host_id += b[2] << 16;
                host_id += b[3] << 24;
                host_id = Math.abs(host_id);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    private class ColDocumentSet
    implements DocumentSet {
        private RecordSet set;

        public ColDocumentSet(RecordSet set) {
            this.set = set;
        }

        public Container getNextContainer() throws DBException {
            block5: {
                if (this.set.hasMoreRecords()) {
                    Record rec = this.set.getNextRecord();
                    Key key = rec.getKey();
                    Value val = rec.getValue();
                    if (val.getLength() > 0) {
                        try {
                            if (Collection.this.compressed) {
                                DocumentImpl doc = new DocumentImpl(val.getData(), Collection.this.symbols, new NodeSource(Collection.this, key));
                                return new ColContainer(key, doc);
                            }
                            return new ColContainer(key, DOMParser.toDocument(val));
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block5;
                            log.warn((Object)"ignored exception", (Throwable)e);
                        }
                    }
                }
            }
            return null;
        }

        public Document getNextDocument() throws DBException {
            Container c = this.getNextContainer();
            if (c != null) {
                return c.getDocument();
            }
            return null;
        }

        public boolean hasMoreDocuments() throws DBException {
            return this.set.hasMoreRecords();
        }
    }

    private class ColContainer
    implements Container {
        private Document document;
        private Key key;

        public ColContainer(Key key, Document document) {
            this.key = key;
            this.document = document;
        }

        public void commit() throws DBException {
            Collection.this.putDocument(this.key, this.document);
        }

        public void commit(Document doc) throws DBException {
            this.document = doc;
            this.commit();
        }

        public String getCanonicalName() throws DBException {
            return Collection.this.getCanonicalDocumentName(this.key);
        }

        public Collection getCollection() {
            return Collection.this;
        }

        public Document getDocument() {
            return this.document;
        }

        public Key getKey() {
            return this.key;
        }

        public void remove() throws DBException {
            Collection.this.remove(this.key);
        }

        public Document rollback() throws DBException {
            this.document = Collection.this.getDocument(this.key);
            return this.document;
        }
    }
}

