/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xindice.client.xmldb.CommonConfigurable;
import org.apache.xindice.client.xmldb.resources.BinaryResourceImpl;
import org.apache.xindice.client.xmldb.resources.XMLResourceImpl;
import org.apache.xindice.client.xmldb.services.CollectionManagementServiceImpl;
import org.apache.xindice.client.xmldb.services.MetaService;
import org.apache.xindice.client.xmldb.services.XPathQueryServiceImpl;
import org.apache.xindice.client.xmldb.services.XUpdateQueryServiceImpl;
import org.apache.xindice.core.FaultCodes;
import org.apache.xindice.core.meta.MetaData;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public abstract class XindiceCollection
extends CommonConfigurable
implements Collection {
    public static final String QUERY_NS = "http://xml.apache.org/xindice/Query";
    protected final Hashtable services = new Hashtable();
    protected final String collPath;

    public XindiceCollection(String collPath) throws XMLDBException {
        this.collPath = collPath.endsWith("/") ? collPath.substring(0, collPath.length() - 1) : collPath;
        XPathQueryServiceImpl xpath = new XPathQueryServiceImpl();
        xpath.setCollection(this);
        this.registerService(xpath);
        XUpdateQueryServiceImpl xupdate = new XUpdateQueryServiceImpl();
        xupdate.setCollection(this);
        this.registerService(xupdate);
        MetaService meta = new MetaService();
        meta.setCollection(this);
        this.registerService(meta);
        try {
            CollectionManagementServiceImpl manager = new CollectionManagementServiceImpl();
            manager.setCollection(this);
            this.registerService((Service)manager);
            this.services.put("CollectionManager" + manager.getVersion(), manager);
            this.services.put("DatabaseInstanceManager" + manager.getVersion(), manager);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public Service[] getServices() throws XMLDBException {
        this.checkOpen();
        Enumeration e = this.services.elements();
        Service[] result = new Service[this.services.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            result[i] = (Service)e.nextElement();
            ++i;
        }
        return result;
    }

    public Service getService(String name, String version) throws XMLDBException {
        this.checkOpen();
        Service result = (Service)this.services.get(name + version);
        return result;
    }

    public void registerService(Service service) throws XMLDBException {
        service.setCollection((Collection)this);
        this.services.put(service.getName() + service.getVersion(), service);
    }

    public abstract boolean isOpen();

    protected void checkOpen() throws XMLDBException {
        if (!this.isOpen()) {
            throw new XMLDBException(202);
        }
    }

    public String getName() {
        return this.collPath.substring(this.collPath.lastIndexOf(47) + 1);
    }

    public String getCanonicalName() {
        return this.collPath;
    }

    public abstract String getURI();

    public Resource createResource(String name, String type) throws XMLDBException {
        if (!"XMLResource".equals(type) && !"BinaryResource".equals(type)) {
            throw new XMLDBException(302, "Only XMLResource and BinaryResource supported");
        }
        if (name == null || name.length() == 0) {
            name = this.createId();
        } else if (name.indexOf(47) != -1) {
            throw new XMLDBException(301, "Name cannot contain '/'");
        }
        if ("XMLResource".equals(type)) {
            return new XMLResourceImpl(name, this);
        }
        return new BinaryResourceImpl(name, this, null);
    }

    public ResourceSet query(String queryLang, String query, Hashtable nsMap) throws XMLDBException {
        return this.query(null, queryLang, query, nsMap);
    }

    public abstract ResourceSet query(String var1, String var2, String var3, Hashtable var4) throws XMLDBException;

    public abstract Collection createCollection(String var1) throws XMLDBException;

    public abstract Collection createCollection(String var1, Document var2) throws XMLDBException;

    public abstract void removeCollection(String var1) throws XMLDBException;

    public abstract String[] listIndexers() throws XMLDBException;

    public abstract void createIndexer(Document var1) throws XMLDBException;

    public abstract void dropIndexer(String var1) throws XMLDBException;

    public abstract void shutdown() throws XMLDBException;

    public abstract MetaData getMetaData(String var1) throws XMLDBException;

    public abstract void setMetaData(String var1, MetaData var2) throws XMLDBException;
}

