/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.unittests;

import junit.framework.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;

public class XhiveNodeMatcher {
    protected static String nodeTypeToString(int n) {
        switch (n) {
            case 1: {
                return "ELEMENT_NODE";
            }
            case 2: {
                return "ATTRIBUTE_NODE";
            }
            case 3: {
                return "TEXT_NODE";
            }
            case 4: {
                return "CDATA_SECTION_NODE";
            }
            case 5: {
                return "ENTITY_REFERENCE_NODE";
            }
            case 6: {
                return "ENTITY_NODE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_NODE";
            }
            case 8: {
                return "COMMENT_NODE";
            }
            case 9: {
                return "DOCUMENT_NODE";
            }
            case 10: {
                return "DOCUMENT_TYPE_NODE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT_NODE";
            }
            case 12: {
                return "NOTATION_NODE";
            }
        }
        return "UNKNOWN NODE TYPE";
    }

    public static void compareNodes(Node node, Node node2, boolean bl, boolean bl2) {
        if (node != null || node2 != null) {
            if (node != null) {
                Assert.assertNotNull((String)("NodeMatcher : Missing node, origin tagname : " + node.getNodeName()), (Object)node2);
            } else {
                Assert.assertNull((String)("NodeMatcher : extra node: " + (node2 != null ? node2.getNodeName() : "")), (Object)node2);
            }
            Assert.assertEquals((String)"NodeMatcher : node types do not match", (Object)XhiveNodeMatcher.nodeTypeToString(node.getNodeType()), (Object)XhiveNodeMatcher.nodeTypeToString(node2.getNodeType()));
            Assert.assertEquals((String)"NodeMatcher : node names do not match.", (Object)node.getNodeName(), (Object)node2.getNodeName());
            Assert.assertEquals((String)"NodeMatcher : node values do not match.", (Object)node.getNodeValue(), (Object)node2.getNodeValue());
            Assert.assertEquals((String)"NodeMatcher : local names do not match.", (Object)node.getLocalName(), (Object)node2.getLocalName());
            Assert.assertEquals((String)("NodeMatcher : namespace URI's do not match (localName=" + node.getLocalName() + ")."), (Object)node.getNamespaceURI(), (Object)node2.getNamespaceURI());
            Assert.assertEquals((String)"NodeMatcher : prefixes do not match.", (Object)node.getPrefix(), (Object)node2.getPrefix());
            if (node.hasAttributes()) {
                Assert.assertTrue((String)("NodeMatcher : hasAttributes() should return true for node with name " + node.getNodeName()), (boolean)node2.hasAttributes());
            }
            if ((bl || node.getNodeType() != 5) && node.hasChildNodes() && bl2) {
                Assert.assertTrue((String)("NodeMatcher : hasChildren() should return true for node with name " + node.getNodeName()), (boolean)node2.hasChildNodes());
            }
            if (node.getNodeType() == 1) {
                XhiveNodeMatcher.compareNamedNodeMaps(node.getAttributes(), node2.getAttributes(), bl, bl2);
            }
            if (node.getNodeType() == 2) {
                XhiveNodeMatcher.compareAttrs((Attr)node, (Attr)node2, bl, bl2);
            }
            if (node.getNodeType() == 6) {
                XhiveNodeMatcher.compareEntities((Entity)node, (Entity)node2);
            }
            if (node.getNodeType() == 7) {
                XhiveNodeMatcher.comparePIs((ProcessingInstruction)node, (ProcessingInstruction)node2);
            }
            if (node.getNodeType() == 12) {
                XhiveNodeMatcher.compareNotations((Notation)node, (Notation)node2);
            }
            if (node.getNodeType() == 9) {
                XhiveNodeMatcher.compareDocuments((Document)node, (Document)node2, bl, bl2);
            }
            if (bl2 && (bl || node.getNodeType() != 5)) {
                Node node3 = node.getFirstChild();
                Node node4 = node2.getFirstChild();
                while (node3 != null) {
                    Assert.assertNotNull((String)("NodeMatcher : Child list for node does not match, missing node " + node3.getNodeName()), (Object)node4);
                    XhiveNodeMatcher.compareNodes(node3, node4, bl, bl2);
                    node3 = node3.getNextSibling();
                    node4 = node4.getNextSibling();
                }
                if (node4 != null && node3 == null) {
                    Assert.fail((String)("NodeMatcher : Child list does not match, node should not be there :" + node4.getNodeName() + ", " + node4.getNodeValue()));
                }
            }
        }
    }

    public static void compareNodeLists(NodeList nodeList, NodeList nodeList2, boolean bl, boolean bl2) {
        if (nodeList != null) {
            Assert.assertNotNull((String)"NodeMatcher : expected nodelist not found", (Object)nodeList2);
            Assert.assertEquals((String)"NodeMatcher : nodelist item count does not match.", (int)nodeList.getLength(), (int)nodeList2.getLength());
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                Node node2 = nodeList2.item(n);
                XhiveNodeMatcher.compareNodes(node, node2, bl, bl2);
                ++n;
            }
        } else {
            Assert.assertNull((String)"NodeMatcher : unexpected nodelist found", (Object)nodeList2);
        }
    }

    public static void compareNamedNodeMaps(NamedNodeMap namedNodeMap, NamedNodeMap namedNodeMap2, boolean bl, boolean bl2) {
        if (namedNodeMap != null) {
            Assert.assertNotNull((String)"NodeMatcher : expected namednodemap not found", (Object)namedNodeMap2);
            Assert.assertEquals((String)"NodeMatcher : nodemap item count does not match.", (int)namedNodeMap.getLength(), (int)namedNodeMap2.getLength());
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node = namedNodeMap.item(n);
                Node node2 = XhiveNodeMatcher.lookupTargetNode(namedNodeMap2, node);
                XhiveNodeMatcher.compareNodes(node, node2, bl, bl2);
                ++n;
            }
        } else {
            Assert.assertNull((String)"NodeMatcher : unexpected namednodemap found", (Object)namedNodeMap2);
        }
    }

    private static Node lookupTargetNode(NamedNodeMap namedNodeMap, Node node) {
        if (node.getLocalName() == null) {
            return namedNodeMap.getNamedItem(node.getNodeName());
        }
        return namedNodeMap.getNamedItemNS(node.getNamespaceURI(), node.getLocalName());
    }

    protected static void compareAttrs(Attr attr, Attr attr2, boolean bl, boolean bl2) {
        if (bl && attr.getSpecified()) {
            Assert.assertTrue((String)"NodeMatcher : attribute specified does not match", (boolean)attr2.getSpecified());
        }
    }

    protected static void compareEntities(Entity entity, Entity entity2) {
        Assert.assertEquals((String)"NodeMatcher : entity public id's do not match.", (Object)entity.getPublicId(), (Object)entity2.getPublicId());
        Assert.assertEquals((String)"NodeMatcher : entity system id's do not match.", (Object)entity.getSystemId(), (Object)entity2.getSystemId());
        Assert.assertEquals((String)"NodeMatcher : entity notation names do not match.", (Object)entity.getNotationName(), (Object)entity2.getNotationName());
    }

    protected static void comparePIs(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        Assert.assertEquals((String)"NodeMatcher : processing instruction targets do not match.", (Object)processingInstruction.getTarget(), (Object)processingInstruction2.getTarget());
        Assert.assertEquals((String)"NodeMatcher : processing instruction data does not match.", (Object)processingInstruction.getData(), (Object)processingInstruction2.getData());
    }

    protected static void compareNotations(Notation notation, Notation notation2) {
        Assert.assertEquals((String)"NodeMatcher : notation public id's do not match.", (Object)notation.getPublicId(), (Object)notation2.getPublicId());
        Assert.assertEquals((String)"NodeMatcher : notation system id's do not match.", (Object)notation.getSystemId(), (Object)notation2.getSystemId());
    }

    public static void compareDocTypes(DocumentType documentType, DocumentType documentType2, boolean bl, boolean bl2) {
        if (documentType == null) {
            Assert.assertNull((String)"NodeMatcher: One doctype is null and one is not", (Object)documentType2);
        } else {
            Assert.assertNotNull((String)"NodeMatcher: One doctype is null and one is not", (Object)documentType2);
        }
        Assert.assertEquals((String)"NodeMatcher : document type public id's do not match.", (Object)documentType.getPublicId(), (Object)documentType2.getPublicId());
        Assert.assertEquals((String)"NodeMatcher : document type system id's do not match.", (Object)documentType.getSystemId(), (Object)documentType2.getSystemId());
        Assert.assertEquals((String)"NodeMatcher : document type names do not match.", (Object)documentType.getName(), (Object)documentType2.getName());
        XhiveNodeMatcher.compareNamedNodeMaps(documentType.getEntities(), documentType2.getEntities(), bl, bl2);
        XhiveNodeMatcher.compareNamedNodeMaps(documentType.getNotations(), documentType2.getNotations(), bl, bl2);
    }

    protected static void compareDocuments(Document document, Document document2, boolean bl, boolean bl2) {
        DocumentType documentType = document.getDoctype();
        DocumentType documentType2 = document2.getDoctype();
        XhiveNodeMatcher.compareNodes(documentType, documentType2, bl, bl2);
    }
}

