/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus.commands;

import java.util.Hashtable;
import org.w3c.dom.Node;
import org.xmldb.xupdate.lexus.commands.AppendCommand;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.InsertAfterCommand;
import org.xmldb.xupdate.lexus.commands.InsertBeforeCommand;
import org.xmldb.xupdate.lexus.commands.RemoveCommand;
import org.xmldb.xupdate.lexus.commands.RenameCommand;
import org.xmldb.xupdate.lexus.commands.TempTree;
import org.xmldb.xupdate.lexus.commands.UpdateCommand;
import org.xmldb.xupdate.lexus.commands.VariableCommand;

public class CommandConstants {
    public static final int ROOT_ELEMENT = 0;
    public static final int COMMAND_COUNT = 7;
    public static final int COMMAND_REMOVE = 1;
    public static final int COMMAND_RENAME = 2;
    public static final int COMMAND_UPDATE = 3;
    public static final int COMMAND_VARIABLE = 4;
    public static final int COMMAND_APPEND = 5;
    public static final int COMMAND_INSERT_BEFORE = 6;
    public static final int COMMAND_INSERT_AFTER = 7;
    protected static final int FIRST_INSTRUCTION = 100;
    public static final int INSTRUCTION_ELEMENT = 101;
    public static final int INSTRUCTION_ATTRIBUTE = 102;
    public static final int INSTRUCTION_COMMENT = 103;
    public static final int INSTRUCTION_TEXT = 104;
    public static final int INSTRUCTION_CDATA = 105;
    public static final int INSTRUCTION_PROCESSING_INSTRUCTION = 106;
    public static final int INSTRUCTION_VALUE_OF = 107;
    protected static final int LAST_INSTRUCTION = 200;
    public static final int ATTRIBUTES = 200;
    public static final int CHARACTERS = 300;
    private Hashtable ids = null;
    protected CommandObject[] command = null;
    public static TempTree tempTree = null;

    public CommandConstants() {
        tempTree = new TempTree();
        this.initTable();
    }

    public int idForString(String string) {
        Integer n = (Integer)this.ids.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public CommandObject commandForID(int n) {
        switch (n) {
            case 1: {
                return this.command[0];
            }
            case 2: {
                return this.command[1];
            }
            case 3: {
                return this.command[2];
            }
            case 4: {
                return this.command[3];
            }
            case 5: {
                return this.command[4];
            }
            case 6: {
                return this.command[5];
            }
            case 7: {
                return this.command[6];
            }
        }
        return null;
    }

    public void setContextNode(Node node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("context node must not be null !");
        }
        this.command = new CommandObject[7];
        this.command[0] = new RemoveCommand(node);
        this.command[1] = new RenameCommand(node);
        this.command[2] = new UpdateCommand(node);
        this.command[3] = new VariableCommand(node);
        this.command[4] = new AppendCommand(node);
        this.command[5] = new InsertBeforeCommand(node);
        this.command[6] = new InsertAfterCommand(node);
    }

    public boolean isInsertOperation(int n) {
        return n == 6 || n == 7 || n == 5;
    }

    public boolean isInstruction(int n) {
        return 100 < n && n < 200;
    }

    protected void initTable() {
        this.ids = new Hashtable();
        this.ids.put("modifications", new Integer(0));
        this.ids.put("remove", new Integer(1));
        this.ids.put("rename", new Integer(2));
        this.ids.put("update", new Integer(3));
        this.ids.put("variable", new Integer(4));
        this.ids.put("append", new Integer(5));
        this.ids.put("insert-before", new Integer(6));
        this.ids.put("insert-after", new Integer(7));
        this.ids.put("element", new Integer(101));
        this.ids.put("attribute", new Integer(102));
        this.ids.put("comment", new Integer(103));
        this.ids.put("text", new Integer(104));
        this.ids.put("cdata", new Integer(105));
        this.ids.put("value-of", new Integer(107));
        this.ids.put("processing-instruction", new Integer(106));
    }
}

