/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class SystemMenuFastView
extends Action
implements ISelfUpdatingAction {
    private PresentablePart viewPane;
    private IStackPresentationSite site;

    public SystemMenuFastView(IStackPresentationSite site) {
        this.site = site;
        this.setText(WorkbenchMessages.ViewPane_fastView);
        this.update();
    }

    public void setPane(PresentablePart newPane) {
        this.viewPane = newPane;
        this.update();
    }

    public void update() {
        IViewReference viewRef = this.getReference();
        if (viewRef == null || !this.site.isPartMoveable(this.viewPane)) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.setChecked(this.viewPane.getPane().getPage().getActivePerspective().isFastView(viewRef));
        }
    }

    private IViewReference getReference() {
        IWorkbenchPartReference ref;
        IViewReference viewRef = null;
        if (this.viewPane != null && (ref = this.viewPane.getPane().getPartReference()) instanceof IViewReference) {
            viewRef = (IViewReference)ref;
        }
        return viewRef;
    }

    public boolean shouldBeVisible() {
        if (this.viewPane == null || this.viewPane.getPane().getPage() == null) {
            return false;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.viewPane.getPane().getPage().getWorkbenchWindow();
        return workbenchWindow.getShowFastViewBars() && this.viewPane != null && this.site.isPartMoveable(this.viewPane);
    }

    public void dispose() {
        this.viewPane = null;
    }

    public void run() {
        if (this.viewPane.getPane() instanceof ViewPane) {
            ViewPane pane = (ViewPane)this.viewPane.getPane();
            if (!this.isChecked()) {
                pane.doMakeFast();
            } else {
                pane.doRemoveFast();
            }
        }
    }
}

