/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.LogUtils;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class XmlParser
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(XmlParser.class.getName());
    private static SAXParserFactory parserFactory;
    public static final String SAX_PARSER_PROPERTY = "com.google.gdata.SAXParserFactory";
    private static final String JDK_PARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    ElementHandler rootHandler;
    String rootNamespace;
    String rootElementName;
    ElementHandler curHandler;
    int unrecognizedElements = 0;
    Locator locator;
    HashMap<String, Stack<XmlWriter.Namespace>> namespaceMap = new HashMap();
    ArrayList<XmlWriter.Namespace> namespaceDecls = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXException {
        String string = System.getProperty(SAX_PARSER_PROPERTY);
        if (string == null) {
            return SAXParserFactory.newInstance();
        }
        String string2 = System.getProperty(JDK_PARSER_PROPERTY);
        try {
            System.setProperty(JDK_PARSER_PROPERTY, string);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            return sAXParserFactory;
        }
        finally {
            if (string2 == null) {
                System.clearProperty(JDK_PARSER_PROPERTY);
            } else {
                System.setProperty(JDK_PARSER_PROPERTY, string2);
            }
        }
    }

    public void parse(Reader reader, ElementHandler elementHandler, String string, String string2) throws IOException, ParseException {
        InputSource inputSource = new InputSource(reader);
        this.rootHandler = elementHandler;
        this.rootNamespace = string;
        this.rootElementName = string2;
        this.parse(inputSource);
    }

    public void parse(InputStream inputStream, ElementHandler elementHandler, String string, String string2) throws IOException, ParseException {
        InputSource inputSource = new InputSource(inputStream);
        this.rootHandler = elementHandler;
        this.rootNamespace = string;
        this.rootElementName = string2;
        this.parse(inputSource);
    }

    protected void parse(InputSource inputSource) throws IOException, ParseException {
        try {
            if (parserFactory == null) {
                parserFactory = XmlParser.getSAXParserFactory();
            }
            SAXParser sAXParser = parserFactory.newSAXParser();
            ParserAdapter parserAdapter = new ParserAdapter(sAXParser.getParser());
            parserAdapter.setContentHandler(this);
            parserAdapter.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof ParseException) {
                this.throwParseException((ParseException)exception);
            }
            if (exception instanceof IOException) {
                LogUtils.logException(logger, Level.WARNING, null, sAXException);
                throw (IOException)exception;
            }
            LogUtils.logException(logger, Level.WARNING, null, sAXException);
            throw new ParseException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogUtils.logException(logger, Level.WARNING, null, parserConfigurationException);
            throw new ParseException(parserConfigurationException);
        }
    }

    private void throwParseException(ParseException parseException) throws ParseException {
        if (this.locator != null) {
            String string = "";
            if (this.curHandler != null) {
                string = string + ", element " + this.curHandler.qName;
            }
            String string2 = "[Line " + String.valueOf(this.locator.getLineNumber()) + ", Column " + String.valueOf(this.locator.getColumnNumber()) + string + "] ";
            LogUtils.logException(logger, Level.WARNING, string2, parseException);
            throw new ParseException(string2 + parseException.getMessage());
        }
        LogUtils.logException(logger, Level.WARNING, null, parseException);
        throw parseException;
    }

    static String getCumulativeXmlBase(String string, String string2) throws URISyntaxException {
        URI uRI = new URI(string2);
        if (string == null || string.equals("")) {
            if (!uRI.isAbsolute()) {
                throw new URISyntaxException(string2, "No xml:base established--need an absolute URI.");
            }
            return string2;
        }
        URI uRI2 = new URI(string);
        URI uRI3 = uRI2.resolve(uRI);
        assert (uRI3.isAbsolute());
        return uRI3.toString();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.fine("Start element " + string3);
        ElementHandler elementHandler = this.curHandler;
        if (this.curHandler == null && string.equals(this.rootNamespace) && string2.equals(this.rootElementName)) {
            this.curHandler = this.rootHandler;
        } else if (this.curHandler != null && this.unrecognizedElements == 0) {
            try {
                this.curHandler = this.curHandler.getChildHandler(string, string2, attributes);
            }
            catch (ParseException parseException) {
                throw new SAXException(parseException);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.curHandler != null && this.unrecognizedElements == 0) {
            this.curHandler.parent = elementHandler;
            this.curHandler.qName = string3;
            if (elementHandler != null) {
                this.curHandler.xmlLang = elementHandler.xmlLang;
                this.curHandler.xmlBase = elementHandler.xmlBase;
            }
            try {
                String string4;
                String string5;
                String string6;
                int n;
                for (n = attributes.getLength() - 1; n >= 0; --n) {
                    string6 = attributes.getURI(n);
                    string5 = attributes.getLocalName(n);
                    string4 = attributes.getValue(n);
                    if (!string6.equals("http://www.w3.org/XML/1998/namespace")) continue;
                    if (string5.equals("lang")) {
                        this.curHandler.xmlLang = string4;
                        logger.finer("xml:lang=" + string4);
                        continue;
                    }
                    if (!string5.equals("base")) continue;
                    this.curHandler.xmlBase = XmlParser.getCumulativeXmlBase(this.curHandler.xmlBase, string4);
                    logger.finer("xml:base=" + this.curHandler.xmlBase);
                }
                for (n = attributes.getLength() - 1; n >= 0; --n) {
                    string6 = attributes.getURI(n);
                    string5 = attributes.getLocalName(n);
                    string4 = attributes.getValue(n);
                    logger.finer("Attribute " + string5 + "='" + string4 + "'");
                    this.curHandler.processAttribute(string6, string5, string4);
                }
            }
            catch (ParseException parseException) {
                throw new SAXException(parseException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new SAXException(new ParseException(uRISyntaxException.getMessage()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException(new ParseException("Invalid integer format. " + numberFormatException.getMessage()));
            }
            this.curHandler.okToInitializeXmlBlob = false;
            if (this.curHandler.xmlBlob != null) {
                if (this.curHandler.xmlLang != null) {
                    this.curHandler.xmlBlob.setLang(this.curHandler.xmlLang);
                }
                if (this.curHandler.xmlBase != null) {
                    this.curHandler.xmlBlob.setBase(this.curHandler.xmlBase);
                }
            }
        } else {
            ++this.unrecognizedElements;
            if (this.curHandler == null) {
                this.curHandler = elementHandler;
            }
            if (this.curHandler != null && this.curHandler.innerXml != null) {
                ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(attributes.getLength());
                for (int i = attributes.getLength() - 1; i >= 0; --i) {
                    String string7 = attributes.getQName(i);
                    this.ensureBlobNamespace(this.curHandler, string7);
                    String string8 = attributes.getValue(i);
                    XmlWriter.Attribute attribute = new XmlWriter.Attribute(string7, string8);
                    arrayList.add(attribute);
                    if (!this.curHandler.fullTextIndex) continue;
                    this.curHandler.fullTextIndexWriter.write(string8);
                    this.curHandler.fullTextIndexWriter.write(" ");
                }
                try {
                    this.ensureBlobNamespace(this.curHandler, string3);
                    this.curHandler.innerXml.startElement(null, string3, arrayList, this.namespaceDecls);
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.namespaceDecls.clear();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        logger.fine("End element " + string3);
        if (this.unrecognizedElements > 0) {
            --this.unrecognizedElements;
            if (this.curHandler != null && this.curHandler.innerXml != null) {
                try {
                    this.curHandler.innerXml.endElement();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        } else if (this.curHandler != null) {
            if (this.curHandler.xmlBlob != null) {
                this.curHandler.xmlBlob.setBlob(this.curHandler.innerXmlStringWriter.toString());
                if (this.curHandler.fullTextIndex) {
                    this.curHandler.xmlBlob.setFullText(this.curHandler.fullTextIndexWriter.toString());
                }
            }
            try {
                this.curHandler.processEndElement();
            }
            catch (ParseException parseException) {
                throw new SAXException(parseException);
            }
            this.curHandler = this.curHandler.parent;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.curHandler != null) {
            if (this.unrecognizedElements == 0) {
                if (this.curHandler.value == null) {
                    this.curHandler.value = new String();
                }
                this.curHandler.value = this.curHandler.value + new String(cArray, n, n2);
            }
            if (this.curHandler.innerXml != null && (this.curHandler.mixedContent || this.unrecognizedElements > 0)) {
                if (this.curHandler.fullTextIndex) {
                    this.curHandler.fullTextIndexWriter.write(cArray, n, n2);
                    this.curHandler.fullTextIndexWriter.write("\n");
                }
                try {
                    this.curHandler.innerXml.characters(new String(cArray, n, n2));
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.curHandler != null && this.curHandler.innerXml != null && (this.curHandler.mixedContent || this.unrecognizedElements > 0)) {
            try {
                this.curHandler.innerXml.writeUnescaped(new String(cArray, n, n2));
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String string, String string2) {
        Stack<XmlWriter.Namespace> stack = this.namespaceMap.get(string);
        if (stack == null) {
            stack = new Stack();
            this.namespaceMap.put(string, stack);
        }
        XmlWriter.Namespace namespace = new XmlWriter.Namespace(string, string2);
        stack.push(namespace);
        this.namespaceDecls.add(namespace);
    }

    public void endPrefixMapping(String string) {
        this.namespaceMap.get(string).pop();
    }

    private void ensureBlobNamespace(ElementHandler elementHandler, String string) {
        XmlWriter.Namespace namespace = null;
        String string2 = string.substring(0, Math.max(0, string.indexOf(":")));
        if (string2.equals("xml")) {
            return;
        }
        Stack<XmlWriter.Namespace> stack = this.namespaceMap.get(string2);
        if (stack != null) {
            namespace = stack.peek();
        }
        assert (string2.length() == 0 || namespace != null) : "Namespace alias '" + string2 + "' should be mapped in 'namespaceMap'.";
        if (namespace != null && !elementHandler.blobNamespaces.contains(string2)) {
            elementHandler.blobNamespaces.add(string2);
            elementHandler.xmlBlob.namespaces.add(new XmlNamespace(string2, namespace.getUri()));
        }
    }

    public static class ElementHandler {
        public String qName;
        public String value;
        public String xmlLang;
        public String xmlBase;
        ElementHandler parent;
        XmlBlob xmlBlob = null;
        boolean okToInitializeXmlBlob = true;
        boolean mixedContent = false;
        boolean fullTextIndex = false;
        XmlWriter innerXml;
        HashSet blobNamespaces = new HashSet();
        StringWriter innerXmlStringWriter;
        StringWriter fullTextIndexWriter;

        public ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (this.xmlBlob == null) {
                throw new ParseException("Unrecognized element '" + string2 + "'.");
            }
            logger.info("No child handler for " + string2 + ". Treating as an extension element.");
            return null;
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
        }

        public void processEndElement() throws ParseException {
            if (this.value != null && !this.value.trim().equals("") && !this.mixedContent) {
                throw new ParseException("This element must not have any text() data.");
            }
        }

        public void initializeXmlBlob(XmlBlob xmlBlob, boolean bl, boolean bl2) throws IOException {
            assert (this.okToInitializeXmlBlob);
            this.xmlBlob = xmlBlob;
            this.mixedContent = bl;
            this.innerXmlStringWriter = new StringWriter();
            this.innerXml = new XmlWriter(this.innerXmlStringWriter);
            this.fullTextIndex = bl2;
            if (bl2) {
                this.fullTextIndexWriter = new StringWriter();
            }
        }

        public String getAbsoluteUri(String string) throws ParseException {
            try {
                return XmlParser.getCumulativeXmlBase(this.xmlBase, string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParseException(uRISyntaxException.getMessage());
            }
        }

        public Boolean getBooleanAttribute(Attributes attributes, String string) throws ParseException {
            String string2 = attributes.getValue("", string);
            if (string2 == null) {
                return null;
            }
            if (string2.equals("false") || string2.equals("0")) {
                return Boolean.FALSE;
            }
            if (string2.equals("true") || string2.equals("1")) {
                return Boolean.TRUE;
            }
            throw new ParseException("Invalid value for " + string + " attribute: " + string2);
        }
    }
}

