/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;

public class RedirectRequiredException
extends ServiceException {
    private static final String LOCATION = "Location";

    public RedirectRequiredException(int n, String string) {
        super("Redirect Required");
        this.setHttpErrorCodeOverride(n);
        this.getHttpHeaders().put(LOCATION, Collections.singletonList(string));
    }

    public RedirectRequiredException(HttpURLConnection httpURLConnection) throws IOException {
        super(httpURLConnection);
        this.setHttpErrorCodeOverride(httpURLConnection.getResponseCode());
    }

    public String getRedirectLocation() {
        List<String> list = this.getHttpHeaders().get(LOCATION);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

