/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentType {
    private static String TOKEN = "[\\p{ASCII}&&[^\\p{Cntrl} ;/=\\[\\]\\(\\)\\<\\>\\@\\,\\:\\\"\\?\\=]]+";
    private static Pattern TOKEN_PATTERN = Pattern.compile("^" + TOKEN + "$");
    private static Pattern TYPE_PATTERN = Pattern.compile("(" + TOKEN + ")" + "/" + "(" + TOKEN + ")" + "\\s*(.*)\\s*");
    private static Pattern ATTR_PATTERN = Pattern.compile("\\s*;\\s*(" + TOKEN + ")" + "\\s*=\\s*" + "(?:" + "\"([^\"]*)\"" + "|" + "(" + TOKEN + ")?" + ")");
    public static final String ATTR_CHARSET = "charset";
    private static final String STAR = "*";
    private String type;
    private String subType;
    private HashMap<String, String> attributes = new HashMap();

    public ContentType() {
        this(null);
    }

    public ContentType(String string) {
        if (string == null) {
            this.type = "application";
            this.subType = "octet-stream";
            this.attributes.put(ATTR_CHARSET, "iso-8859-1");
            return;
        }
        Matcher matcher = TYPE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid media type:" + string);
        }
        this.type = matcher.group(1).toLowerCase();
        this.subType = matcher.group(2).toLowerCase();
        if (matcher.groupCount() < 3) {
            return;
        }
        Matcher matcher2 = ATTR_PATTERN.matcher(matcher.group(3));
        while (matcher2.find()) {
            String string2 = matcher2.group(2);
            if (string2 == null && (string2 = matcher2.group(3)) == null) {
                string2 = "";
            }
            this.attributes.put(matcher2.group(1).toLowerCase(), string2);
        }
        if (!this.attributes.containsKey(ATTR_CHARSET)) {
            if (this.subType.endsWith("xml")) {
                if (this.type.equals("application")) {
                    this.attributes.put(ATTR_CHARSET, "utf-8");
                } else {
                    this.attributes.put(ATTR_CHARSET, "us-ascii");
                }
            } else if (this.subType.equals("json")) {
                this.attributes.put(ATTR_CHARSET, "utf-8");
            } else {
                this.attributes.put(ATTR_CHARSET, "iso-8859-1");
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String string) {
        this.subType = string;
    }

    public String getMediaType() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append("/");
        stringBuffer.append(this.subType);
        return stringBuffer.toString();
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String getCharset() {
        return this.attributes.get(ATTR_CHARSET);
    }

    public boolean match(ContentType contentType) {
        String string = contentType.getType();
        String string2 = contentType.getSubType();
        return STAR.equals(string) || this.type.equals(string) && (STAR.equals(string2) || this.subType.equals(string2));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append("/");
        stringBuffer.append(this.subType);
        for (String string : this.attributes.keySet()) {
            stringBuffer.append(";");
            stringBuffer.append(string);
            stringBuffer.append("=");
            String string2 = this.attributes.get(string);
            Matcher matcher = TOKEN_PATTERN.matcher(string2);
            if (matcher.matches()) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append("\"" + string2 + "\"");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContentType contentType = (ContentType)object;
        return this.type.equals(contentType.type) && this.subType.equals(contentType.subType) && this.attributes.equals(contentType.attributes);
    }

    public int hashCode() {
        return (this.type.hashCode() * 31 + this.subType.hashCode()) * 31 + this.attributes.hashCode();
    }
}

