/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.batch.BatchId;
import com.google.gdata.data.batch.BatchInterrupted;
import com.google.gdata.data.batch.BatchOperation;
import com.google.gdata.data.batch.BatchOperationType;
import com.google.gdata.data.batch.BatchStatus;
import com.google.gdata.util.Namespaces;

public class BatchUtils {
    public static void declareExtensions(ExtensionProfile extensionProfile) {
        extensionProfile.declareAdditionalNamespace(Namespaces.batchNs);
        BatchUtils.declareEntryExtensions(extensionProfile);
        BatchUtils.declareFeedExtensions(extensionProfile);
    }

    public static void declareFeedExtensions(ExtensionProfile extensionProfile) {
        extensionProfile.declareFeedExtension(BatchOperation.getDefaultDescription());
    }

    public static void declareEntryExtensions(ExtensionProfile extensionProfile) {
        extensionProfile.declareEntryExtension(BatchId.getDefaultDescription());
        extensionProfile.declareEntryExtension(BatchOperation.getDefaultDescription());
        extensionProfile.declareEntryExtension(BatchInterrupted.getDefaultDescription());
        extensionProfile.declareEntryExtension(BatchStatus.getDefaultDescription());
    }

    public static String getBatchId(BaseEntry baseEntry) {
        return BatchId.getIdFrom(baseEntry);
    }

    public static void setBatchId(BaseEntry baseEntry, String string) {
        if (string == null) {
            baseEntry.removeExtension(BatchId.class);
        } else {
            baseEntry.setExtension(new BatchId(string));
        }
    }

    public static BatchOperationType getBatchOperationType(BaseEntry baseEntry) {
        return BatchUtils.getBatchOperationType((ExtensionPoint)baseEntry);
    }

    public static void setBatchOperationType(BaseEntry baseEntry, BatchOperationType batchOperationType) {
        BatchUtils.setBatchOperationType((ExtensionPoint)baseEntry, batchOperationType);
    }

    public static BatchOperationType getBatchOperationType(BaseFeed baseFeed) {
        return BatchUtils.getBatchOperationType((ExtensionPoint)baseFeed);
    }

    public static void setBatchOperationType(BaseFeed baseFeed, BatchOperationType batchOperationType) {
        BatchUtils.setBatchOperationType((ExtensionPoint)baseFeed, batchOperationType);
    }

    private static BatchOperationType getBatchOperationType(ExtensionPoint extensionPoint) {
        BatchOperation batchOperation = extensionPoint.getExtension(BatchOperation.class);
        return batchOperation == null ? null : batchOperation.getType();
    }

    private static void setBatchOperationType(ExtensionPoint extensionPoint, BatchOperationType batchOperationType) {
        if (batchOperationType == null) {
            extensionPoint.removeExtension(BatchOperation.class);
        } else {
            extensionPoint.setExtension(new BatchOperation(batchOperationType));
        }
    }

    public static BatchInterrupted getBatchInterrupted(BaseEntry baseEntry) {
        return baseEntry.getExtension(BatchInterrupted.class);
    }

    public static BatchStatus getBatchStatus(BaseEntry baseEntry) {
        return baseEntry.getExtension(BatchStatus.class);
    }

    public static boolean isSuccess(BaseEntry baseEntry) {
        int n = BatchUtils.getRequiredBatchStatusCode(baseEntry);
        return n >= 200 && n < 300;
    }

    public static boolean isFailure(BaseEntry baseEntry) {
        return !BatchUtils.isSuccess(baseEntry);
    }

    private static int getRequiredBatchStatusCode(BaseEntry baseEntry) {
        BatchStatus batchStatus = BatchUtils.getBatchStatus(baseEntry);
        if (batchStatus == null) {
            throw new IllegalArgumentException("Not a batch response entry; Missing BatchStatus extension.");
        }
        return batchStatus.getCode();
    }
}

