/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.http;

import com.google.gdata.client.Service;
import com.google.gdata.data.DateTime;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.InvalidEntryException;
import com.google.gdata.util.NotImplementedException;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.ResourceNotFoundException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.ServiceForbiddenException;
import com.google.gdata.util.VersionConflictException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpGDataRequest
implements Service.GDataRequest {
    private static final Logger logger = Logger.getLogger(HttpGDataRequest.class.getName());
    public static final String METHOD_OVERRIDE_PROPERTY = "com.google.gdata.UseMethodOverride";
    public static final String METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override";
    protected HttpURLConnection httpConn;
    protected URL requestUrl;
    protected Service.GDataRequest.RequestType type;
    protected boolean executed = false;
    protected boolean expectsInput;
    protected boolean hasOutput;
    protected DateTime ifModifiedCondition;
    protected int connectTimeout = -1;
    protected int readTimeout = -1;

    protected HttpGDataRequest(Service.GDataRequest.RequestType requestType, URL uRL, ContentType contentType, AuthToken authToken, Map<String, String> map, Map<String, String> map2) throws IOException {
        this.type = requestType;
        this.requestUrl = uRL;
        this.httpConn = this.getRequestConnection(uRL);
        switch (requestType) {
            case QUERY: {
                this.hasOutput = true;
                break;
            }
            case INSERT: 
            case BATCH: {
                this.expectsInput = true;
                this.hasOutput = true;
                this.setMethod("POST");
                this.setHeader("Content-Type", contentType.toString());
                break;
            }
            case UPDATE: {
                this.expectsInput = true;
                this.hasOutput = true;
                if (Boolean.getBoolean(METHOD_OVERRIDE_PROPERTY)) {
                    this.setMethod("POST");
                    this.setHeader(METHOD_OVERRIDE_HEADER, "PUT");
                } else {
                    this.setMethod("PUT");
                }
                this.setHeader("Content-Type", contentType.toString());
                break;
            }
            case DELETE: {
                if (Boolean.getBoolean(METHOD_OVERRIDE_PROPERTY)) {
                    this.setMethod("POST");
                    this.setHeader(METHOD_OVERRIDE_HEADER, "DELETE");
                } else {
                    this.setMethod("DELETE");
                }
                this.setHeader("Content-Length", "0");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown request type:" + (Object)((Object)requestType));
            }
        }
        if (authToken != null) {
            Iterator<String> iterator = authToken.getAuthorizationHeader(uRL, this.httpConn.getRequestMethod());
            this.setPrivateHeader("Authorization", (String)((Object)iterator));
        }
        if (map != null) {
            for (String string : map.keySet()) {
                this.setHeader(string, map.get(string));
            }
        }
        if (map2 != null) {
            for (String string : map2.keySet()) {
                this.setPrivateHeader(string, map2.get(string));
            }
        }
        this.httpConn.setDoOutput(this.expectsInput);
    }

    protected HttpURLConnection getRequestConnection(URL uRL) throws IOException {
        if (!uRL.getProtocol().startsWith("http")) {
            throw new UnsupportedOperationException("Unsupported scheme:" + uRL.getProtocol());
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setInstanceFollowRedirects(true);
        return httpURLConnection;
    }

    @Override
    public void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        this.connectTimeout = n;
    }

    @Override
    public void setReadTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        this.readTimeout = n;
    }

    @Override
    public void setIfModifiedSince(DateTime dateTime) {
        this.ifModifiedCondition = dateTime;
    }

    @Override
    public OutputStream getRequestStream() throws IOException {
        if (!this.expectsInput) {
            throw new IllegalStateException("Request doesn't accept input");
        }
        return this.httpConn.getOutputStream();
    }

    private void setMethod(String string) throws ProtocolException {
        this.httpConn.setRequestMethod(string);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(string + " " + this.httpConn.getURL().toExternalForm());
        }
    }

    private void setHeader(String string, String string2) {
        this.httpConn.setRequestProperty(string, string2);
        logger.finer(string + ": " + string2);
    }

    public void setPrivateHeader(String string, String string2) {
        this.httpConn.setRequestProperty(string, string2);
        logger.finer(string + ": <Not Logged>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServiceException {
        if (this.connectTimeout >= 0) {
            this.httpConn.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            this.httpConn.setReadTimeout(this.readTimeout);
        }
        if (this.ifModifiedCondition != null) {
            this.setHeader("If-Modified-Since", this.ifModifiedCondition.toStringRfc822());
        }
        String string = System.getProperty("http.strictPostRedirect");
        try {
            System.setProperty("http.strictPostRedirect", "true");
            this.httpConn.connect();
            if (logger.isLoggable(Level.FINE)) {
                if (!this.httpConn.getURL().equals(this.requestUrl)) {
                    logger.fine("Redirected to:" + this.httpConn.getURL().toExternalForm());
                }
                logger.fine(this.httpConn.getResponseCode() + " " + this.httpConn.getResponseMessage());
                if (logger.isLoggable(Level.FINER)) {
                    Map<String, List<String>> map = this.httpConn.getHeaderFields();
                    for (String string2 : map.keySet()) {
                        for (String string3 : map.get(string2)) {
                            logger.finer(string2 + ": " + string3);
                        }
                    }
                }
            }
            this.checkResponse();
        }
        finally {
            if (string == null) {
                System.clearProperty("http.strictPostRedirect");
            } else {
                System.setProperty("http.strictPostRedirect", string);
            }
        }
        this.executed = true;
    }

    protected void checkResponse() throws IOException, ServiceException {
        if (this.httpConn.getResponseCode() >= 300) {
            this.handleErrorResponse();
        }
    }

    protected void handleErrorResponse() throws ServiceException, IOException {
        switch (this.httpConn.getResponseCode()) {
            case 404: {
                throw new ResourceNotFoundException(this.httpConn);
            }
            case 400: {
                throw new InvalidEntryException(this.httpConn);
            }
            case 403: {
                throw new ServiceForbiddenException(this.httpConn);
            }
            case 401: {
                throw new AuthenticationException(this.httpConn);
            }
            case 304: {
                throw new NotModifiedException(this.httpConn);
            }
            case 501: {
                throw new NotImplementedException(this.httpConn);
            }
            case 409: {
                throw new VersionConflictException(this.httpConn);
            }
        }
        throw new ServiceException(this.httpConn);
    }

    @Override
    public InputStream getResponseStream() throws IOException {
        if (!this.executed) {
            throw new IllegalStateException("Must call execute() before attempting to read response");
        }
        if (!this.hasOutput) {
            throw new IllegalStateException("Request doesn't have response data");
        }
        return this.httpConn.getInputStream();
    }

    public HttpURLConnection getConnection() {
        return this.httpConn;
    }

    static {
        if (System.getProperty(METHOD_OVERRIDE_PROPERTY) == null) {
            System.setProperty(METHOD_OVERRIDE_PROPERTY, "true");
        }
    }

    public static interface AuthToken {
        public String getAuthorizationHeader(URL var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements Service.GDataRequestFactory {
        protected AuthToken authToken;
        protected Map<String, String> headerMap = new LinkedHashMap<String, String>();
        protected Map<String, String> privateHeaderMap = new LinkedHashMap<String, String>();

        public void setAuthToken(AuthToken authToken) {
            this.authToken = authToken;
        }

        private void extendHeaderMap(Map<String, String> map, String string, String string2) {
            String string3 = map.get(string);
            string3 = string3 != null ? string3 + "; " + string2 : string2;
            map.put(string, string3);
        }

        @Override
        public void setHeader(String string, String string2) {
            this.extendHeaderMap(this.headerMap, string, string2);
        }

        @Override
        public void setPrivateHeader(String string, String string2) {
            this.extendHeaderMap(this.privateHeaderMap, string, string2);
        }

        @Override
        public Service.GDataRequest getRequest(Service.GDataRequest.RequestType requestType, URL uRL, ContentType contentType) throws IOException, ServiceException {
            return new HttpGDataRequest(requestType, uRL, contentType, this.authToken, this.headerMap, this.privateHeaderMap);
        }
    }
}

