/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.client.Service;
import com.google.gdata.client.http.AuthSubUtil;
import com.google.gdata.client.http.GoogleGDataRequest;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.DateTime;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.RedirectRequiredException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleService
extends Service {
    private String applicationName;
    private String serviceName;
    private String username;
    private String password;
    private String domainName;
    private String loginProtocol;
    public static final String GOOGLE_ACCOUNTS_PATH = "/accounts";
    public static final String GOOGLE_LOGIN_PATH = "/accounts/ClientLogin";
    protected Set<GoogleGDataRequest.GoogleCookie> cookies = new HashSet<GoogleGDataRequest.GoogleCookie>();
    protected boolean handlesCookies = true;

    public GoogleService(String string, String string2) {
        this(string, string2, "https", "www.google.com");
    }

    public GoogleService(String string, String string2, String string3, String string4) {
        this.serviceName = string;
        this.applicationName = string2;
        this.domainName = string4;
        this.loginProtocol = string3;
        this.requestFactory = new GoogleGDataRequest.Factory();
        if (string2 != null) {
            this.requestFactory.setHeader("User-Agent", string2 + " " + this.getServiceVersion());
        } else {
            this.requestFactory.setHeader("User-Agent", this.getServiceVersion());
        }
    }

    public void setUserCredentials(String string, String string2) throws AuthenticationException {
        this.setUserCredentials(string, string2, null, null);
    }

    public void setUserCredentials(String string, String string2, String string3, String string4) throws AuthenticationException {
        this.username = string;
        this.password = string2;
        String string5 = this.getAuthToken(string, string2, string3, string4, this.serviceName, this.applicationName);
        GoogleGDataRequest.Factory factory = (GoogleGDataRequest.Factory)this.requestFactory;
        factory.setAuthToken(new UserToken(string5));
        this.cookies.clear();
    }

    public void setAuthSubToken(String string) {
        this.setAuthSubToken(string, null);
    }

    public void setAuthSubToken(String string, PrivateKey privateKey) {
        GoogleGDataRequest.Factory factory = (GoogleGDataRequest.Factory)this.requestFactory;
        factory.setAuthToken(new AuthSubToken(string, privateKey));
        this.cookies.clear();
    }

    public String getAuthToken(String string, String string2, String string3, String string4, String string5, String string6) throws AuthenticationException {
        String string7;
        Serializable serializable;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Email", string);
        hashMap.put("Passwd", string2);
        hashMap.put("source", string6);
        hashMap.put("service", string5);
        hashMap.put("accountType", "HOSTED_OR_GOOGLE");
        if (string3 != null) {
            hashMap.put("logintoken", string3);
        }
        if (string4 != null) {
            hashMap.put("logincaptcha", string4);
        }
        try {
            serializable = new URL(this.loginProtocol + "://" + this.domainName + GOOGLE_LOGIN_PATH);
            string7 = GoogleService.makePostRequest((URL)serializable, hashMap);
        }
        catch (IOException iOException) {
            AuthenticationException authenticationException = new AuthenticationException("Error connecting with login URI");
            authenticationException.initCause(iOException);
            throw authenticationException;
        }
        serializable = StringUtil.string2Map(string7.trim(), "\n", "=", true);
        String string8 = (String)serializable.get("Auth");
        if (string8 == null) {
            throw this.getAuthException((Map<String, String>)((Object)serializable));
        }
        return string8;
    }

    /*
     * WARNING - void declaration
     */
    public static String makePostRequest(URL uRL, Map<String, String> map) throws IOException {
        void var6_10;
        String string;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String object2 : map.keySet()) {
            string = map.get(object2);
            if (!bl) {
                stringBuilder.append("&");
            }
            stringBuilder.append(URLEncoder.encode(object2)).append("=");
            stringBuilder.append(URLEncoder.encode(string));
            bl = false;
        }
        httpURLConnection.getOutputStream().write(stringBuilder.toString().getBytes("utf-8"));
        httpURLConnection.getOutputStream().flush();
        httpURLConnection.getOutputStream().close();
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            InputStream inputStream = httpURLConnection.getInputStream();
        } else {
            InputStream inputStream = httpURLConnection.getErrorStream();
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (var6_10 != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)var6_10));
            while (null != (string = bufferedReader.readLine())) {
                stringBuilder2.append(string).append('\n');
            }
        }
        return stringBuilder2.toString();
    }

    private AuthenticationException getAuthException(Map<String, String> map) {
        String string = map.get("Error");
        if ("BadAuthentication".equals(string)) {
            return new InvalidCredentialsException("Invalid credentials");
        }
        if ("AccountDeleted".equals(string)) {
            return new AccountDeletedException("Account deleted");
        }
        if ("AccountDisabled".equals(string)) {
            return new AccountDisabledException("Account disabled");
        }
        if ("NotVerified".equals(string)) {
            return new NotVerifiedException("Not verified");
        }
        if ("TermsNotAgreed".equals(string)) {
            return new TermsNotAgreedException("Terms not agreed");
        }
        if ("ServiceUnavailable".equals(string)) {
            return new ServiceUnavailableException("Service unavailable");
        }
        if ("CaptchaRequired".equals(string)) {
            String string2 = map.get("CaptchaUrl");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.loginProtocol).append("://").append(this.domainName).append(GOOGLE_ACCOUNTS_PATH).append('/').append(string2);
            return new CaptchaRequiredException("Captcha required", stringBuilder.toString(), map.get("CaptchaToken"));
        }
        return new AuthenticationException("Error authenticating (check service name)");
    }

    public void setHandlesCookies(boolean bl) {
        this.handlesCookies = bl;
    }

    public boolean handlesCookies() {
        return this.handlesCookies;
    }

    public void addCookie(GoogleGDataRequest.GoogleCookie googleCookie) {
        assert (this.handlesCookies);
        this.cookies.add(googleCookie);
    }

    public Set<GoogleGDataRequest.GoogleCookie> getCookies() {
        Iterator<GoogleGDataRequest.GoogleCookie> iterator = this.cookies.iterator();
        while (iterator.hasNext()) {
            GoogleGDataRequest.GoogleCookie googleCookie = iterator.next();
            if (!googleCookie.hasExpired()) continue;
            iterator.remove();
        }
        return this.cookies;
    }

    @Override
    public void setRequestFactory(Service.GDataRequestFactory gDataRequestFactory) {
        if (!(gDataRequestFactory instanceof GoogleGDataRequest.Factory)) {
            throw new IllegalArgumentException("Invalid factory");
        }
        this.requestFactory = gDataRequestFactory;
    }

    @Override
    public Service.GDataRequest createRequest(Service.GDataRequest.RequestType requestType, URL uRL, ContentType contentType) throws IOException, ServiceException {
        GoogleGDataRequest googleGDataRequest = (GoogleGDataRequest)super.createRequest(requestType, uRL, contentType);
        googleGDataRequest.setService(this);
        return googleGDataRequest;
    }

    @Override
    public <E extends BaseEntry> E getEntry(URL uRL, Class<E> clazz, DateTime dateTime) throws IOException, ServiceException {
        try {
            return super.getEntry(uRL, clazz, dateTime);
        }
        catch (RedirectRequiredException redirectRequiredException) {
            uRL = this.handleRedirectException(redirectRequiredException);
        }
        catch (SessionExpiredException sessionExpiredException) {
            this.handleSessionExpiredException(sessionExpiredException);
        }
        return super.getEntry(uRL, clazz, dateTime);
    }

    @Override
    public <E extends BaseEntry> E update(URL uRL, E e) throws IOException, ServiceException {
        try {
            return super.update(uRL, e);
        }
        catch (RedirectRequiredException redirectRequiredException) {
            uRL = this.handleRedirectException(redirectRequiredException);
        }
        catch (SessionExpiredException sessionExpiredException) {
            this.handleSessionExpiredException(sessionExpiredException);
        }
        return super.update(uRL, e);
    }

    @Override
    public <E extends BaseEntry> E insert(URL uRL, E e) throws IOException, ServiceException {
        try {
            return super.insert(uRL, e);
        }
        catch (RedirectRequiredException redirectRequiredException) {
            uRL = this.handleRedirectException(redirectRequiredException);
        }
        catch (SessionExpiredException sessionExpiredException) {
            this.handleSessionExpiredException(sessionExpiredException);
        }
        return super.insert(uRL, e);
    }

    @Override
    public <F extends BaseFeed> F getFeed(URL uRL, Class<F> clazz, DateTime dateTime) throws IOException, ServiceException {
        try {
            return super.getFeed(uRL, clazz, dateTime);
        }
        catch (RedirectRequiredException redirectRequiredException) {
            uRL = this.handleRedirectException(redirectRequiredException);
        }
        catch (SessionExpiredException sessionExpiredException) {
            this.handleSessionExpiredException(sessionExpiredException);
        }
        return super.getFeed(uRL, clazz, dateTime);
    }

    @Override
    public void delete(URL uRL) throws IOException, ServiceException {
        try {
            super.delete(uRL);
            return;
        }
        catch (RedirectRequiredException redirectRequiredException) {
            uRL = this.handleRedirectException(redirectRequiredException);
        }
        catch (SessionExpiredException sessionExpiredException) {
            this.handleSessionExpiredException(sessionExpiredException);
        }
        super.delete(uRL);
    }

    private void handleSessionExpiredException(SessionExpiredException sessionExpiredException) throws SessionExpiredException, AuthenticationException {
        if (this.username == null || this.password == null) {
            throw sessionExpiredException;
        }
        String string = this.getAuthToken(this.username, this.password, null, null, this.serviceName, this.applicationName);
        GoogleGDataRequest.Factory factory = (GoogleGDataRequest.Factory)this.requestFactory;
        factory.setAuthToken(new UserToken(string));
    }

    private URL handleRedirectException(RedirectRequiredException redirectRequiredException) throws ServiceException {
        try {
            return new URL(redirectRequiredException.getRedirectLocation());
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServiceException("Invalid redirected-to URL - " + redirectRequiredException.getRedirectLocation());
        }
    }

    public static class AuthSubToken
    implements HttpGDataRequest.AuthToken {
        private String token;
        private PrivateKey key;

        public AuthSubToken(String string, PrivateKey privateKey) {
            this.token = string;
            this.key = privateKey;
        }

        public String getAuthorizationHeader(URL uRL, String string) {
            try {
                return AuthSubUtil.formAuthorizationHeader(this.token, this.key, uRL, string);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException(generalSecurityException.getMessage());
            }
        }
    }

    public static class UserToken
    implements HttpGDataRequest.AuthToken {
        private String token;

        public UserToken(String string) {
            this.token = string;
        }

        public String getAuthorizationHeader(URL uRL, String string) {
            return "GoogleLogin auth=" + this.token;
        }
    }

    public static class SessionExpiredException
    extends AuthenticationException {
        public SessionExpiredException(String string) {
            super(string);
        }
    }

    public static class CaptchaRequiredException
    extends AuthenticationException {
        private String captchaUrl;
        private String captchaToken;

        public CaptchaRequiredException(String string, String string2, String string3) {
            super(string);
            this.captchaToken = string3;
            this.captchaUrl = string2;
        }

        public String getCaptchaToken() {
            return this.captchaToken;
        }

        public String getCaptchaUrl() {
            return this.captchaUrl;
        }
    }

    public static class ServiceUnavailableException
    extends AuthenticationException {
        public ServiceUnavailableException(String string) {
            super(string);
        }
    }

    public static class TermsNotAgreedException
    extends AuthenticationException {
        public TermsNotAgreedException(String string) {
            super(string);
        }
    }

    public static class NotVerifiedException
    extends AuthenticationException {
        public NotVerifiedException(String string) {
            super(string);
        }
    }

    public static class AccountDisabledException
    extends AuthenticationException {
        public AccountDisabledException(String string) {
            super(string);
        }
    }

    public static class AccountDeletedException
    extends AuthenticationException {
        public AccountDeletedException(String string) {
            super(string);
        }
    }

    public static class InvalidCredentialsException
    extends AuthenticationException {
        public InvalidCredentialsException(String string) {
            super(string);
        }
    }
}

