/*
 * Decompiled with CFR 0.152.
 */
package hayashi.yuu.register;

import hayashi.yuu.pasori.felica.Felica;
import hayashi.yuu.pasori.felica.FelicaException;
import hayashi.yuu.register.CardRegister;
import hayashi.yuu.register.CollectData;
import hayashi.yuu.register.DeviceData;
import hayashi.yuu.tools.PlaySound;
import hayashi.yuu.tools.SpeedMail;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.FutureTask;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeviceProcess
extends Thread {
    public static boolean doing = true;
    static final byte CTRL_STX = -2;
    static final byte CTRL_ETX = 3;
    static final byte CTRL_NAK = 21;
    static final byte CTRL_ACK = 6;
    boolean telegram = false;
    PlaySound sound = null;

    public DeviceProcess() throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        this.init();
    }

    @Override
    public void run() {
        String zenkai = null;
        Felica task = null;
        try {
            try {
                task = new Felica();
                while (doing) {
                    try {
                        String result = task.getID((short)255);
                        if (zenkai == null || !zenkai.equals(result)) {
                            System.out.println(result);
                            this.command(result);
                            zenkai = new String(result);
                        }
                    }
                    catch (FelicaException e) {
                        zenkai = null;
                    }
                    if (!doing) {
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (task != null) {
                    task.close();
                    task = null;
                }
            }
        }
        finally {
            if (task != null) {
                task.close();
                task = null;
            }
        }
    }

    public void disable() {
        doing = false;
    }

    public void init() throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        doing = true;
        CardRegister.device = new DeviceData();
        this.sound = new PlaySound();
    }

    void command(String rcvStr) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        this.sound.start();
        CardRegister.textArea.append(String.valueOf(rcvStr) + "\n");
        CollectData rec = new CollectData(new Date(), rcvStr, null, null);
        CardRegister.dataStore.add(rec);
        CardRegister.tmodel.addRow(rec.getRecordStrs());
        if (CardRegister.isMail()) {
            try {
                StringBuffer contentSbuf = new StringBuffer("\u25cb\u25cb\u5c0f\u5b66\u6821\u767b\u4e0b\u6821\u901a\u77e5\u30b7\u30b9\u30c6\u30e0\u304b\u3089\u306e\u304a\u77e5\u3089\u305b\u3002\n");
                contentSbuf.append("\n");
                String[] recitem = rec.getRecordStrs();
                contentSbuf.append("\u3000\u65e5\u3000\u6642:\t" + recitem[0] + "\n");
                contentSbuf.append("\u3000\u30ab\u30fc\u30c9:\t" + recitem[1] + "\n");
                contentSbuf.append("\u3000\u9001\u4fe1\u5148:\t" + recitem[2] + "\n");
                contentSbuf.append("\u3000\u306a\u307e\u3048:\t" + recitem[3] + "\n");
                SpeedMail mail = new SpeedMail(CardRegister.settingDialog.getPropertiesFilename());
                mail.setSubject(String.valueOf(recitem[3]) + "\u3061\u3083\u3093\u3001\u767b\u6821\u3057\u307e\u3057\u305f\u3002");
                mail.setContent(contentSbuf.toString());
                if (!recitem[2].equals("")) {
                    mail.setTo(recitem[2]);
                }
                FutureTask<Object> task = new FutureTask<Object>(mail);
                new Thread(task).start();
            }
            catch (Exception e) {
                e.printStackTrace();
                CardRegister.logger.warning("\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                JOptionPane.showMessageDialog(CardRegister.mainFrame, "\u30e1\u30fc\u30eb\u9001\u4fe1\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30a8\u30e9\u30fc", 0);
            }
        }
        if (CardRegister.isXMLout()) {
            try {
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
                Document document = docbuilder.newDocument();
                Element root = document.createElement("collect");
                document.appendChild(root);
                Calendar now = Calendar.getInstance();
                root.setAttribute("datetime", new SimpleDateFormat("yyyy/MM/dd'-'HH:mm:ss").format(now.getTime()));
                Element device = CardRegister.device.getXmlElement(document);
                root.appendChild(device);
                Element point = rec.getXmlElement(document);
                root.appendChild(point);
                TransformerFactory tfactory = TransformerFactory.newInstance();
                Transformer transformer = tfactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                File outfile = new File("data_" + new SimpleDateFormat("yyyyMMddHHmmss").format(now.getTime()) + ".xml");
                transformer.transform(new DOMSource(document), new StreamResult(outfile));
                CardRegister.logger.info("XML\u30d5\u30a1\u30a4\u30eb\u306b\u3057\u3066\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                CardRegister.logger.warning("XML\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u5931\u6557\uff01 (ParserConfigurationException)");
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                CardRegister.logger.warning("XML\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u5931\u6557\uff01 (TransformerConfigurationException)");
            }
            catch (TransformerException e) {
                e.printStackTrace();
                CardRegister.logger.warning("XML\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u5931\u6557\uff01 (TransformerException)");
            }
        }
        CardRegister.dataStore = new Vector();
        this.init();
    }
}

