//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.form;

//===========================================================================
// import
//===========================================================================
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.*;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.ValidatorForm;
import java.io.UnsupportedEncodingException;

import java.util.*;

import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.bug.*;
/**
 *<PRE>
 * ReportFormNX
 *
 *</PRE>
 * @author k@
 * @version 1.0.0
 */

public class ReportForm extends ValidatorForm {
//===========================================================================
// attributes
//===========================================================================
	/**
	 * action
	 */
	private String m_action;
	/**
	 * ReportType
	 */
	private String m_reportType;
	/**
	 * sfrom
	 */
	private String m_fromDate;
	/**
	 * sto
	 */
	private String m_toDate;
	/**
	 * Ȉԍ
	 */
	private String m_choiceBno;
	/**
	 * H
	 */
	private String[] m_processName;
	/**
	 * Ώ@
	 */
	private String[] m_resolution;
	/**
	 * S
	 */
	private String[] m_dispach;
	/**
	 * ̏x
	 */
	private String[] m_severity;
	/**
	 * subsystem
	 */
	private String[] m_subsystem;
	/**
	 * @\
	 */
	private String[] m_function;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//======================================
// other
//======================================
	/**
	 * where
	 */
	private StringBuffer m_where = new StringBuffer();
	/**
	 * params
	 */
	private ArrayList m_params = new ArrayList();
	/**
	 * qbg
	 */
	private int m_count;
//===========================================================================
// methods
//===========================================================================
	/**
	 * ANV̎擾
	 * 
	 * @return ANV
	 */
	public String getAction()
	{
		return m_action;
	}
	/**
	 * ANṼZbg
	 * 
	 * @param action ANV
	 */
	public void setAction(String action)
	{
		m_action = action;
	}
	/**
	 * ReportType̎擾
	 * 
	 * @return ReportType
	 */
	public String getReportType()
	{
		return m_reportType;
	}
	/**
	 * ReportTypẽZbg
	 * 
	 * @param ReportType ReportType
	 */
	public void setReportType(String reportType)
	{
		m_reportType = reportType;
	}
	/**
	 * sfrom̎擾
	 * 
	 * @return sfrom
	 */
	public String getFromDate()
	{
		return m_fromDate;
	}
	/**
	 * sfrom̃Zbg
	 * 
	 * @param fromDate sfrom
	 */
	public void setFromDate(String fromDate)
	{
		m_fromDate = fromDate;
	}
	/**
	 * sto̎擾
	 * 
	 * @return sto
	 */
	public String getToDate()
	{
		return m_toDate;
	}
	/**
	 * stõZbg
	 * 
	 * @param toDate sto
	 */
	public void setToDate(String toDate)
	{
		m_toDate = toDate;
	}
	/**
	 * Ȉԍ̎擾
	 * 
	 * @return Ȉԍ
	 */
	public String getChoiceBno()
	{
		return m_choiceBno;
	}
	/**
	 * Ȉԍ̃Zbg
	 * 
	 * @param choiceBno Ȉԍ
	 */
	public void setChoiceBno(String choiceBno)
	{
		m_choiceBno = choiceBno;
	}
	/**
	 * H̎擾
	 * 
	 * @return H
	 */
	public String[] getProcessName()
	{
		return m_processName;
	}
	/**
	 * H̃Zbg
	 * 
	 * @param processName H
	 */
	public void setProcessName(String[] processName)
	{
		m_processName = processName;
	}
	/**
	 * Ώ@̎擾
	 * 
	 * @return Ώ@
	 */
	public String[] getResolution()
	{
		return m_resolution;
	}
	/**
	 * Ώ@̃Zbg
	 * 
	 * @param resolution Ώ@
	 */
	public void setResolution(String[] resolution)
	{
		m_resolution = resolution;
	}
	/**
	 * S҂̎擾
	 * 
	 * @return S
	 */
	public String[] getDispach()
	{
		return m_dispach;
	}
	/**
	 * S҂̃Zbg
	 * 
	 * @param dispach S
	 */
	public void setDispach(String[] dispach)
	{
		m_dispach = dispach;
	}
	/**
	 * ̏x̎擾
	 * 
	 * @return ̏x
	 */
	public String[] getSeverity()
	{
		return m_severity;
	}
	/**
	 * ̏x̃Zbg
	 * 
	 * @param severity ̏x
	 */
	public void setSeverity(String[] severity)
	{
		m_severity = severity;
	}
	/**
	 * @\̎擾
	 * 
	 * @return @\
	 */
	public String[] getFunction()
	{
		return m_function;
	}
	/**
	 * @\̃Zbg
	 * 
	 * @param function @\
	 */
	public void setFunction(String[] function)
	{
		m_function = function;
	}
	/**
	 * TuVXe̎擾
	 * 
	 * @return TuVXe
	 */
	public String[] getSubsystem()
	{
		return m_subsystem;
	}
	/**
	 * TuVXẽZbg
	 * 
	 * @param subsystem TuVXe
	 */
	public void setSubsystem(String[] subsystem)
	{
		m_subsystem = subsystem;
	}
//======================================
// other
//======================================
	/**
	 * where̎擾
	 * 
	 * @return where
	 */
	public StringBuffer getWhere()
	{
		return m_where;
	}
	/**
	 * wherẽZbg
	 * 
	 * @param where where
	 */
	public void setWhere(StringBuffer where)
	{
		m_where = where;
	}
	/**
	 * p[^Q̎擾
	 * 
	 * @return p[^Q
	 */
	public ArrayList getParams()
	{
		return m_params;
	}
	/**
	 * p[^Q̃Zbg
	 * 
	 * @param params p[^Q
	 */
	public void setParams(ArrayList params)
	{
		m_params = params;
	}
	/**
	 * qbg̎擾
	 * 
	 * @return qbg
	 */
	public int getCount()
	{
		return m_count;
	}
	/**
	 * qbg̃Zbg
	 * 
	 * @param count qbg
	 */
	public void setCount(int count)
	{
		m_count = count;
	}
//===========================================================================
// Public Methods
//===========================================================================
	/**
	* Reset all properties to their default values.
	*
	* @param mapping The mapping used to select this instance
	* @param request The servlet request we are processing
	*/
	public void reset(ActionMapping mapping, HttpServletRequest request) {
	
		//debug
		log.debug("reset");
		//encodeing Zbg
		try {
			request.setCharacterEncoding("SJIS");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		
		m_action = null;
		m_reportType = null;
		m_fromDate = null;
		m_toDate = null;
		m_choiceBno = null;
		//ftHgl̓ANVZbĝŁAł͏邾
		m_processName = null;
		
		m_resolution = null;
		m_dispach = null;
		m_severity = null;
		m_function = null;
		//other 
		m_where = new StringBuffer();
		m_params = new ArrayList();
	}
	/**
	* Validate the properties that have been set from this HTTP request,
	* and return an <code>ActionErrors</code> object that encapsulates any
	* validation errors that have been found.  If no errors are found, return
	* <code>null</code> or an <code>ActionErrors</code> object with no
	* recorded error messages.
	*
	* @param mapping The mapping used to select this instance
	* @param request The servlet request we are processing
	*/
	public ActionErrors validate(ActionMapping mapping,
								 HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		//debug
		log.debug("validate");
		
		//ANV
		if (Varidater.checkRequired(m_action, "action", errors)) {
			
			if (Varidater.checkRequired(m_reportType, "reportType", errors)) {
				//fromDate/toDate
				//ǂ炩w肳Ă邩H
				if ((Varidater.isInput(m_fromDate)) || (Varidater.isInput(m_toDate))) {
					//w肠
					parseDateSpan(m_fromDate, m_toDate, "issuDate", errors);
				}
				//IoOԍ
				if (Varidater.isInput(m_choiceBno)) {
					parseChoiceBno("choiceBno", errors);
				}
				//H
				parseSelection(m_processName, "issuPno", errors);
				//resolution
				parseSelection(m_resolution, "resolution", errors);
				//dispach
				parseSelection(m_dispach, "analyst", errors);
				//severity
				parseSelection(m_severity, "severity", errors);
				//milestone
				parseSelection(m_function, "functionName", errors);
				//subsystem
				parseSelection(m_subsystem, "subsystem", errors);
				
/*---------------------------
				//Ȃɂw肳ꂢȂ΃G[Ƃ
				if (m_where.length() == 0) {
					Varidater.addErrors(Varidater.REQUIRED_MSG, "serchParam", errors);
				}
---------------------------*/
				
				
			}
		}
		
		return errors;
	}
//===========================================================================
// parser Methods
//===========================================================================
	/**
	 * ̏ԍ̉
	 * 
	 * @return ̏ԍ
	 */
	private void parseChoiceBno(String name, ActionErrors errors) {
		
		StringBuffer where = new StringBuffer();
		
		//J}ŕȂA͂Ă
		StringTokenizer st = new StringTokenizer(m_choiceBno, ",");
		while (st.hasMoreTokens()) {
			String token = st.nextToken();
			//token͋󂩁H
			if ((token != null) && (token.length() > 0)) {
				//łȂ
				
				//͈͎w`FbN
				int offset = token.indexOf("-");
				//͈͎wł͂Ȃ
				if (offset == -1) {
					//l`FbN
					if (Varidater.checkNumeric(token, name, errors)) {
						//where̐
						appendOR(where, "A.bno = ?");
						m_params.add(new Integer(token));
					}
				//͈͎wł
				} else {
					String from = token.substring(0,offset).trim();
					String to = token.substring(offset+1).trim();
					//fromw/tow肠
					if ((from.length() > 0) && ((to.length() > 0))) {
						
						//where̐
						appendOR(where, "(A.bno >= ? AND bno <= ?)");
						if (Varidater.checkNumeric(from, name, errors)) {
							m_params.add(new Integer(from));
						}
						if (Varidater.checkNumeric(to, name, errors)) {
							m_params.add(new Integer(to));
						}
					//fromŵ
					} else if (from.length() > 0) {
						appendOR(where, "A.bno >= ? ");
						
						if (Varidater.checkNumeric(from, name, errors)) {
							m_params.add(new Integer(from));
						}
					//toŵ
					} else {
						appendOR(where, "A.bno <= ? ");
						if (Varidater.checkNumeric(to, name, errors)) {
							m_params.add(new Integer(to));
						}
					}
				}
			}
		}
		
		//̊ʂ
		termWhere(where);
		
		//debug
		log.debug("parseChoiceBno:where = " + where);
		
		//̏ANDŌ
		appendAND(m_where, where);
		
	}
	/**
	 * Iڂ̉
	 * 
	 */
	private void parseSelection(String[] target, String name, ActionErrors errors) {
		
		//w薳̏ꍇ͂ȂɂȂ
		if ((target == null) || (target.length == 0)) {
			return;
		}
		
		StringBuffer where = new StringBuffer();
		
		for(int i = 0; i < target.length; i++) {
			//_~[IĂȂ
			if (! target.equals("00")) {
				//whereɒǉ
				if (name.equals("analyst")) {
					//analyst͐lȂ̂IntegerɕϊKvB
					appendOR(where, "A." + name + " = ?");
					m_params.add(new Integer(target[i]));
				} else {
					appendOR(where, "A." + name + " = ?");
					m_params.add(target[i]);
				}
			}
		}
		
		//̊ʂ
		termWhere(where);
		
		//debug
		log.debug("parseSelection:where = " + where);
		
		//̏ANDŌ
		appendAND(m_where, where);
		
	}
	/**
	 * tԊủ
	 * 
	 */
	private void parseDateSpan(String from, String to, String name, ActionErrors errors) {
		
		StringBuffer where = new StringBuffer();
		boolean err = false;
		Date fromDate = null;
		Date toDate = null;
		
		//from̃`FbN
		if (Varidater.isInput(from)) {	//w肠
			if (Varidater.checkDate(from, name+"From", Converter.SHORT_DATE_PATTAN, errors)) {
				//G[łȂ
				fromDate = Varidater.parseDate(from, Converter.SHORT_DATE_PATTAN);
			} else {
				err = true;		//G[
			}
		}
		//tỏ
		if (Varidater.isInput(from)) {	//w肠
			if (Varidater.checkDate(from, name+"To", Converter.SHORT_DATE_PATTAN, errors)) {
				//G[łȂ
				toDate = Varidater.parseDate(to, Converter.SHORT_DATE_PATTAN);
			} else {
				err = true;		//G[
			}
		}
		
		//܂łŃG[ΐi߂Ȃ
		if (err) {
			return;
		}
		
		//debug
		log.debug("fromDate = " + fromDate + " toDate =" + toDate);
		
		//r
		if ((fromDate != null) && (toDate != null)) {		//w
			//fromtoOH
			if (! fromDate.before(toDate)) {
				//łȂ΁AG[
				Varidater.addErrors(Varidater.INVALID_DATE_MSG, name+"From", errors);
				return;	//܂
				
			} else {
				//where̐
				where.append("(? <= A." + name + " AND A." + name + " <= ?)");
				m_params.add(fromDate);
				m_params.add(toDate);
			}
		} else if (fromDate != null) {
			//fromw̐
			where.append("(? <= A." + name + ")");
			m_params.add(fromDate);
		} else {
			//tow̐
			where.append("(A." + name + " <= ?)");
			m_params.add(toDate);
		}
		//debug
		log.debug("parseDateSpan:where = " + where);
		
		//̏ANDŌ
		appendAND(m_where, where);
		
	}
//===========================================================================
// private Methods
//===========================================================================
	/**
	 * OR̒ǉ
	 */
	private void appendOR(StringBuffer where, String s) {
		
		if (where.length() == 0) {
			//ŏwhereȂ΁AʂŎn߂
			where.append("(");
		} else {
			//ŏwherełȂorŌ
			where.append(" OR ");
		}
		where.append(s);
	}
	/**
	 * whereǉȉIj
	 */
	private void termWhere(StringBuffer where) {
		
		if (where.length() != 0) {
			//Ίʂ
			where.append(")");
		}
	}
	/**
	 * AND̒ǉ
	 */
	private void appendAND(StringBuffer where, StringBuffer s) {
		
		//ŏwherełȂandŌ
		if (s.length() > 0) {
			if (where.length() > 0) {
				where.append(" AND ");
			}
			where.append(s);
		}
	}
}