//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * CcNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Cc implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	oOԍ
	 */
	private int m_bno = 0;
	/**
	 *	[Uԍ
	 */
	private int m_uno = 0;
	/**
	 *	[Uíj
	 */
	private String m_nickname = null;
	/**
	 *	[AhX
	 */
	private String m_email = null;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"bno", "uno"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"bno","uno",
									"updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public Cc()
	{
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.insert(this);
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new Cc());
	}
	/**
	 *	Cc̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static Collection getCc(int bno)
	{
		String sql = 
		"SELECT" +
		" A.bno as bno," +
		" A.uno as uno," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate," +
		" B.nickname as nickname," +
		" B.email as email" +
		" FROM Cc AS A" +
		" LEFT JOIN UserInfo AS B ON A.uno = B.uno" +
		" WHERE A.bno = ?" +
		" ORDER BY A.bno,B.nickname";
		
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		return( DAO.find(new Cc(), sql, params));
	}
	/**
	 *	Cc̐
	 *
	 * @return	
	 */
	public static Cc createCc(int bno, int uno)
	{
		Cc cc = new Cc();
		cc.setBno(bno);
		cc.setUno(uno);
		UserInfo user = UserInfo.getUser(uno);
		cc.setNickname(user.getNickname());
		cc.setEmail(user.getEmail());
		
		return cc;
		
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("uno", new Integer(m_uno));
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * oOԍ̎擾
	 * 
	 * @return oOԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOԍ̃Zbg
	 * 
	 * @param bno oOԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * [Uԍ̎擾
	 * 
	 * @return [Uԍ
	 */
	public int getUno()
	{
		return m_uno;
	}
	/**
	 * [Uԍ̃Zbg
	 * 
	 * @param uno [Uԍ
	 */
	public void setUno(int uno)
	{
		m_uno = uno;
	}
	/**
	 * [Uíj̎擾
	 * 
	 * @return [Uíj
	 */
	public String getNickname()
	{
		return m_nickname;
	}
	/**
	 * [Uíj̃Zbg
	 * 
	 * @param nickname [Uíj
	 */
	public void setNickname(String nickname)
	{
		m_nickname = nickname;
	}
	/**
	 * [AhX̎擾
	 * 
	 * @return [AhX
	 */
	public String getEmail()
	{
		return m_email;
	}
	/**
	 * [AhX̃Zbg
	 * 
	 * @param email [AhX
	 */
	public void setEmail(String email)
	{
		m_email = email;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		return Converter.getDateString(m_updateDate, Converter.DATE_TIME);
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [Cc] --- \n");
		sb.append("bno       : " + m_bno + "\n");
		sb.append("uno       : " + m_uno + "\n");
		sb.append("nickname  : " + m_nickname + "\n");
		sb.append("email     : " + m_email + "\n");
		sb.append("updateUno : " + m_updateUno + "\n");
		sb.append("updateDate: " + getUpdateDateString() + "\n");
		sb.append("--- [Cc] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << Cc Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		unitTest2();	//폜eXg
		unitTest3();	//R[hwRXgNgeXg
		
		System.out.println("------- << Cc Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//l̃Zbg
		Cc cc = new Cc();
		
		for(int i = 0; i < 10; i++) {
			cc.setBno(2);
			cc.setUno(i+1);
			cc.insert(0);	//ǉ
		}
		
		//\
		display(Cc.getCc(2));
		
	}
	/**
	 *	unitTest2
	 *
	 * [U폜eXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		Collection ccs = Cc.getCc(2);
		if (ccs == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		Iterator ite = ccs.iterator();
		while(ite.hasNext()) {
			Cc cc = (Cc)ite.next();
			cc.delete(2);		//폜
		}
		
		//݃`FbN
		ccs = Cc.getCc(2);
		if (ccs != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
	/**
	 *	unitTest3
	 *
	 * R[hw茟
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		display(Cc.getCc(1));
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			Cc Cc = (Cc)ite.next();
			
			System.out.println(Cc.toString());
		}
	}
}