//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * BugNumberNX
 * 
 * AddTextȂǊOe[u܂߂sꍇɌbnôݒo
 * ܂bnobuge[ũׂoOԍNXB
 * FrameWorkIɌʂ͑SăNX̌`ŕԋp邽߁A
 * 킪KvɂȂB
 * 
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class BugNumber implements ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	oOԍ
	 */
	private int m_bno;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * PK 
	 */
	private static final String[] PK = {"bno"};
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public BugNumber()
	{
		
	}
//======================================
// Db Interface
//======================================
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
//======================================
// Property
//======================================
	/**
	 * oOԍ̎擾
	 * 
	 * @return oOԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOԍ̃Zbg
	 * 
	 * @param bno oOԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
//======================================
// Property
//======================================
	/**
	 * where̐
	 * 
	 * @param bno oOԍ
	 */
	public static String getWhere(Collection list) {
		
		if (list == null) {
			return new String();	//̕ԋp
		}
			
		Iterator ite = list.iterator();
		StringBuffer sb = new StringBuffer();
		
		while(ite.hasNext()) {
			BugNumber bugNumber = (BugNumber)ite.next();
			if (sb.length() == 0) {
				//ŏ
				sb.append(" WHERE(");
			} else {
				//ȍ~
				sb.append(" OR ");
			}
			sb.append("A.bno = " + bugNumber.getBno());
		}
		
		if (sb.length() > 0) {
			sb.append(")");
		}
		return new String(sb);
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [BugNumber] --- \n");
		sb.append("bno       : " + m_bno + "\n");
		sb.append("--- [BugNumber] --- \n");
		return sb.toString();
	}
	/**
	 * debug
	 */
	private static void debug(String s) {
		 
		 System.out.println("[BugNumber]" + s);
		 
	}
}