//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * BugFinderNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class BugFinder
{
	/**
	 * v^Cv
	 */
	public static final int STYPE_ERROR_TYPE = 1;
	public static final int STYPE_ERROR_CAUSE = 2;
	public static final int STYPE_ERROR_POINT = 3;
	public static final int STYPE_ISSU_PNO = 4;
	public static final int STYPE_TRAIN_PNO = 5;
	public static final int STYPE_SHOULD_FIND_PNO = 6;
	public static final int STYPE_ERROR_DELAY_REASON = 7;
	/**
	 * Log
	 */
	private static Log log =  LogFactory.getLog(BugFinder.class.getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	}CoǑ
	 *
	 * @return	
	 */
	public static Collection findMyBug(int uno)
	{
		String sql =
					"SELECT" +
					" A.bno as bno," +
					" A.title as title," +
					" A.status as status," +
					" A.issuDate as issuDate," +
					" A.issuer as issuer," +
					" A.auther as auther," +
					" A.analyst as analyst," +
					" A.updater as updater," +
					" A.comfirmer as comfirmer," +
					" B.shortName as severityString," +
					" C.shortName as milestoneString," +
					" D.shortName as priorityString" +
					" FROM   bug AS A" +
					" LEFT JOIN severity AS B ON A.severity = B.code " +
					" LEFT JOIN milestone AS C ON A.milestone = C.code" +
					" LEFT JOIN priority AS D ON A.priority = D.code" +
					" where A.dispatch = ? and" +
					" (A.status <> 7 and" +
					" A.status <> 8)" +
					" ORDER BY A.bno";
		ArrayList params = new ArrayList();
		params.add(new Integer(uno));				//dispatch
		
		return(DAO.find(new Bug(), sql, params));
	}
	/**
	 *	̊ւoO
	 *
	 * @return	
	 */
	public static Collection findDispatchBug(int uno)
	{
		String sql =
					"SELECT" +
					" A.bno as bno," +
					" A.title as title," +
					" A.status as status," +
					" A.issuDate as issuDate," +
					" A.issuer as issuer," +
					" A.auther as auther," +
					" A.analyst as analyst," +
					" A.updater as updater," +
					" A.comfirmer as comfirmer," +
					" B.shortName as severityString," +
					" C.shortName as milestoneString," +
					" D.shortName as priorityString" +
					" FROM   bug AS A" +
					" LEFT JOIN severity AS B ON A.severity = B.code " +
					" LEFT JOIN milestone AS C ON A.milestone = C.code" +
					" LEFT JOIN priority AS D ON A.priority = D.code" +
					" where (A.issuer = ? or" +
					" A.auther = ? or" +
					" A.analyst = ? or" +
					" A.updater = ? or" +
					" A.comfirmer = ? ) and" +
					" (A.status <> 7 and" +
					" A.status <> 8)" +
					" ORDER BY A.bno";
		ArrayList params = new ArrayList();
		params.add(new Integer(uno));	//issuer
		params.add(new Integer(uno));	//auther
		params.add(new Integer(uno));	//analyst
		params.add(new Integer(uno));	//updater
		params.add(new Integer(uno));	//comfirmer
		
		return(DAO.find(new Bug(), sql, params));
	}
	/**
	 *	IoOԍ̌
	 *
	 * @return	
	 */
	public static Collection findChoiceBug(String where, ArrayList params)
	{
		String sql =
					"SELECT" +
					" A.issuDate as issuDate," +
					" A.releaseSchDate as releaseSchDate," +
					" A.bno as bno," +
					" A.title as title," +
					" B.name as functionLabel," +
					" A.status as status," +
					" A.statusWhitebord as statusWhitebord," +
					" A.cpid1 as cpid1," +
					" A.cpid2 as cpid2," +
					" A.cpid3 as cpid3," +
					" A.cpid4 as cpid4," +
					" A.cpid5 as cpid5" +
					" FROM bug AS A" +
					" LEFT JOIN functionName AS B ON A.functionName = B.code " +
					" WHERE " +
					where +
					" ORDER BY A.bno";
		
		return(DAO.find(new ChoiceBug(), sql, params));
	}
	/**
	 *	oȌڍ׌
	 *
	 * @return	
	 */
	public static Collection findSerchBug(String where, ArrayList params)
	{
		String sql =
					"SELECT" +
					" A.bno as bno" +
					" FROM bug AS A" +
					" LEFT JOIN addtext AS B ON A.bno = B.bno " +
					" WHERE " +
					where +
					" GROUP BY A.bno";
					
		return DAO.find(new BugNumber(), sql, params);
	}
	/**
	 *	oOԍoO߂
	 *
	 * @return	
	 */
	public static Collection getBugs(Collection bugs)
	{
		
		ArrayList params2 = new ArrayList();
		String sql2 =
					"SELECT" +
					" A.bno as bno," +
					" C.shortName as severityString," +
					" D.shortName as resolutionString," +
					" A.status as status," +
					" A.issuer as issuer," +
					" A.auther as auther," +
					" A.analyst as analyst," +
					" A.updater as updater," +
					" A.comfirmer as comfirmer," +
					" A.title as title," +
					" B.shortName as functionString," +
					" A.issuDate as issuDate," +
					" A.bugUpdateDate as bugUpdateDate," +
					" A.comfirmDate as comfirmDate," +
					" A.statusWhitebord as statusWhitebord" +
/*------------------------------------------
					" A.cpid1 as cpid1," +
					" A.cpid2 as cpid2," +
					" A.cpid3 as cpid3," +
					" A.cpid4 as cpid4," +
					" A.cpid5 as cpid5" +
------------------------------------------*/
					" FROM bug AS A" +
					" LEFT JOIN functionName AS B ON A.functionName = B.code " +
					" LEFT JOIN severity AS C ON A.severity = C.code " +
					" LEFT JOIN resolution AS D ON A.resolution = D.code " +
					BugNumber.getWhere(bugs) +
					" GROUP BY A.bno" + 
					" ORDER BY A.bno";
		
		return(DAO.find(new ChoiceBug(), sql2, params2));
	}
	/**
	 *	O񃍃OItȍ~̃oǑ
	 *
	 * @return	
	 */
	public static Collection findUpdateBug(Date date)
	{
		String sql =
					"SELECT" +
					" A.bno as bno," +
					" A.title as title," +
					" A.status as status," +
					" B.shortName as severityString," +
					" A.updateDate as updateDate," +
					" A.cpid1 as cpid1," +
					" A.cpid2 as cpid2," +
					" A.cpid3 as cpid3," +
					" A.cpid4 as cpid4," +
					" A.cpid5 as cpid5," +
					" A.issuer as issuer," +
					" A.auther as auther," +
					" A.analyst as analyst," +
					" A.updater as updater," +
					" A.comfirmer as comfirmer," +
					" C.shortName as functionLabel" +
					" FROM bug A" +
					" LEFT JOIN severity AS B ON A.severity = B.code " +
					" LEFT JOIN functionName AS C ON A.functionName = C.code " +
					" WHERE " +
					" A.updateDate >= ? " +
					" ORDER BY A.updateDate  DESC";
		ArrayList params = new ArrayList();
		params.add(date);
		
		return(DAO.find(new InfoBug(), sql, params));
	}
	/**
	 *	Sʕ\poO
	 *
	 * @return	
	 */
	public static Collection findFullBug(int bno) {
		
		BugNumber b = new BugNumber();
		b.setBno(bno);
		
		ArrayList list = new ArrayList();
		list.add(b);
		
		return findFullBug(list);
		
	
	}
	/**
	 *	Sʕ\poO
	 *
	 * @return	
	 */
	public static Collection findFullBug(Collection bugs)
	{
		String sql =
					"SELECT" +
					" A.bno as bno," +
					" A.bid as bid," +
					" A.title as title," +
					" A.location as location," +
					" B.shortName as locationString," +
					" A.subsystem as subsystem," +
					" Z.shortName as subsystemString," +
					" A.functionName as functionName," +
					" C.shortName as functionNameString," +
					" A.screen as screen," +
					" A.browser as browser," +
					" D.shortName as browserString," +
					" A.os as os," +
					" E.shortName as osString," +
					" A.tid as tid," +
					" A.appVersion as appVersion," +
					" F.shortName as appVersionString," +
					" A.dbVersion as dbVersion," +
					" G.shortName as dbVersionString," +
					" A.htmlVersion as htmlVersion," +
					" H.shortName as htmlVersionString," +
					" A.specVersion as specVersion," +
					" I.shortName as specVersionString," +
					" A.issuer as issuer," +
					" J.nickName as issuerName," +
					" A.issuDate as issuDate," +
					" A.registDate as registDate," +
					" A.severity as severity," +
					" K.shortName as severityString," +
					" A.priority as priority," +
					" L.shortName as priorityString," +
					" A.status as status," +
					" A.statusWhitebord as statusWhitebord," +
					" A.resolution as resolution," +
					" M.shortName as resolutionString," +
					" A.milestone as milestone," +
					" N.shortName as milestoneString," +
					" A.keyword1 as keyword1," +
					" A.keyword2 as keyword2," +
					" A.keyword3 as keyword3," +
					" A.cpid1 as cpid1," +
					" A.cpid2 as cpid2," +
					" A.cpid3 as cpid3," +
					" A.cpid4 as cpid4," +
					" A.cpid5 as cpid5," +
					" A.reletedDoc as reletedDoc," +
					" A.auther as auther," +
					" O.nickName as autherName," +
					" A.authDate as authDate," +
					" A.errorType as errorType," +
					" P.shortName as errorTypeString," +
					" A.errorCause as errorCause," +
					" Q.shortName as errorCauseString," +
					" A.issuPno as issuPno," +
					" R.shortName as issuPnoString," +
					" A.trainPno as trainPno," +
					" S.shortName as trainPnoString," +
					" A.shouldFindPno as shouldFindPno," +
					" T.shortName as shouldFindPnoString," +
					" A.errorDelayReason as errorDelayReason," +
					" U.shortName as errorDelayReasonString," +
					" A.releaseSchDate as releaseSchDate," +
					" A.analyst as analyst," +
					" V.nickName as analystName," +
					" A.analizeDate as analizeDate," +
					" A.updateSrc as updateSrc," +
					" A.updateDoc as updateDoc," +
					" A.updater as updater," +
					" W.nickName as updaterName," +
					" A.bugUpdateDate as bugUpdateDate," +
					" A.releaseDate as releaseDate," +
					" A.comfirmer as comfirmer," +
					" X.nickName as comfirmerName," +
					" A.comfirmDate as comfirmDate," +
					" A.updateUno as updateUno," +
					" Y.nickName as updateUnoName," +
					" A.updateDate as updateDate" +
					" FROM   bug AS A" +
					" LEFT JOIN location AS B ON A.location = B.code " +
					" LEFT JOIN functionName AS C ON A.functionName = C.code " +
					" LEFT JOIN browser AS D ON A.browser = D.code " +
					" LEFT JOIN os AS E ON A.os = E.code " +
					" LEFT JOIN appVersion AS F ON A.appVersion = F.code " +
					" LEFT JOIN dbVersion AS G ON A.dbVersion = G.code " +
					" LEFT JOIN htmlVersion AS H ON A.htmlVersion = H.code " +
					" LEFT JOIN specVersion AS I ON A.specVersion = I.code " +
					" LEFT JOIN UserInfo AS J ON A.issuer = J.uno " +
					" LEFT JOIN severity AS K ON A.severity = K.code " +
					" LEFT JOIN priority AS L ON A.priority = L.code " +
					" LEFT JOIN resolution AS M ON A.resolution = M.code " +
					" LEFT JOIN milestone AS N ON A.milestone = N.code " +
					" LEFT JOIN userinfo AS O ON A.auther = O.uno " +
					" LEFT JOIN errorType AS P ON A.errorType = P.code " +
					" LEFT JOIN errorCause AS Q ON A.errorCause = Q.code " +
					" LEFT JOIN processName AS R ON A.issuPno = R.code " +
					" LEFT JOIN processName AS S ON A.trainPno = S.code " +
					" LEFT JOIN processName AS T ON A.shouldFindPno = T.code " +
					" LEFT JOIN errorDelayReason AS U ON A.errorDelayReason = U.code " +
					" LEFT JOIN userinfo AS V ON A.analyst = V.uno " +
					" LEFT JOIN userinfo AS W ON A.updater = W.uno " +
					" LEFT JOIN userinfo AS X ON A.comfirmer = X.uno " +
					" LEFT JOIN userinfo AS Y ON A.updateUno = Y.uno " +
					" LEFT JOIN subsystem AS Z ON A.subsystem = Z.code " +
					BugNumber.getWhere(bugs) +
					" GROUP BY A.bno" + 
					" ORDER BY A.bno";
					
		ArrayList params = new ArrayList();
//		params.add(new Integer(bno));	//issuer
		
		return(DAO.find(new FullBug(), sql, params));
	}
	/**
	 *	ŏIXV̎擾
	 *
	 * @return	
	 */
	public static Date getUpdateDate(int bno)
	{
		String sql =
					"SELECT" +
					" A.updateDate as updateDate" +
					" FROM bug A" +
					" WHERE " +
					" A.bno = ? ";
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));			//issuer
		
		Collection list = DAO.find(new Bug(), sql, params);
		
		Date date = null;
		if((list != null) && (list.size() != 0)) {
			Bug bug = (Bug)list.iterator().next();
			date = bug.getUpdateDate();
		}
		return date;
	}
	/**
	 *	oO̎擾
	 *
	 * @return	
	 */
	public static BugCount countBug()
	{
		String sql =
					"SELECT" +
					" count(*) as count" +
					" FROM bug A";
		ArrayList params = new ArrayList();
		
		Collection list = DAO.find(new BugCount(), sql, params);
		
		BugCount count = (BugCount)list.iterator().next();
		
		return count;
	}
	/**
	 *	敪Wv
	 *
	 * @return	
	 */
	public static Collection getSelectionStatistics(int sType, String where, ArrayList params)
	{
		
		String whereStr = null;
		String sql = null;
		switch (sType) {
		//ErrorTypeWv
		case STYPE_ERROR_TYPE :
			if (where.length() == 0) {
				whereStr = " WHERE A.errorType <> '00' ";
			} else {
				whereStr = " WHERE(" + where + " AND A.errorType <> '00') ";
			}
			sql =		"SELECT" +
						" count(A.errorType) as count," +
						" B.code as code," +
						" B.name as name" +
						" FROM bug AS A" +
						" LEFT OUTER JOIN errorType AS B ON A.errorType = B.code " +
						whereStr +
						" GROUP BY A.errorType " +
						" ORDER BY A.errorType";
			break;
		//ErrorCauseWv
		case STYPE_ERROR_CAUSE :
			if (where.length() == 0) {
				whereStr = " WHERE A.errorCause <> '00' ";
			} else {
				whereStr = " WHERE(" + where + " AND A.errorCause <> '00') ";
			}
			sql =		"SELECT" +
						" count(A.errorCause) as count," +
						" B.code as code," +
						" B.name as name" +
						" FROM bug AS A" +
						" LEFT OUTER JOIN errorCause AS B ON A.errorCause = B.code " +
						whereStr +
						" GROUP BY A.errorCause " +
						" ORDER BY A.errorCause";
			break;
		//ErrorPontWv
		case STYPE_ERROR_POINT :
			if (where.length() == 0) {
				whereStr = " WHERE A.errorPoint <> '00' ";
			} else {
				whereStr = " WHERE(" + where + " AND A.errorPoint <> '00') ";
			}
			sql =		"SELECT" +
						" count(A.errorPoint) as count," +
						" B.code as code," +
						" B.name as name" +
						" FROM bug AS A" +
						" LEFT OUTER JOIN errorPoint AS B ON A.errorPoint = B.code " +
						whereStr +
						" GROUP BY A.errorPoint " +
						" ORDER BY A.errorPoint";
			break;
		//IssuPnoWv
		case STYPE_ISSU_PNO :
			if (where.length() == 0) {
				whereStr = " WHERE A.issuPno <> '00' ";
			} else {
				whereStr = " WHERE(" + where + " AND A.issuPno <> '00') ";
			}
			sql =		"SELECT" +
						" count(A.issuPno) as count," +
						" B.code as code," +
						" B.name as name" +
						" FROM bug AS A" +
						" LEFT JOIN ProcessName AS B ON A.issuPno = B.code " +
						whereStr +
						" GROUP BY A.issuPno " +
						" ORDER BY A.issuPno";
			break;
		//TrainPnoWv
		case STYPE_TRAIN_PNO :
			if (where.length() == 0) {
				whereStr = " WHERE A.trainPno <> '00' ";
			} else {
				whereStr = " WHERE(" + where + " AND A.trainPno <> '00') ";
			}
			sql =		"SELECT" +
						" count(A.trainPno) as count," +
						" B.code as code," +
						" B.name as name" +
						" FROM bug AS A" +
						" LEFT JOIN ProcessName AS B ON A.trainPno = B.code " +
						whereStr +
						" GROUP BY A.trainPno " +
						" ORDER BY A.trainPno";
			break;
		//ShouldFindPnoWv
		case STYPE_SHOULD_FIND_PNO :
			if (where.length() == 0) {
				whereStr = " WHERE (A.shouldFindPno <> '00'  AND A.shouldFindPno <> A.issuPno)";
			} else {
				whereStr = " WHERE(" + where + " AND (A.shouldFindPno <> '00' AND A.shouldFindPno <> A.issuPno)) ";
			}
			sql =		"SELECT" +
						" count(A.shouldFindPno) as count," +
						" B.code as code," +
						" B.name as name" +
						" FROM bug AS A" +
						" LEFT OUTER JOIN processName AS B ON A.shouldFindPno = B.code " +
						whereStr +
						" GROUP BY A.shouldFindPno " +
						" ORDER BY A.shouldFindPno";
			break;
		//ErrorDelayReasonWv
		case STYPE_ERROR_DELAY_REASON :
			if (where.length() == 0) {
				whereStr = " WHERE A.errorDelayReason <> '00' ";
			} else {
				whereStr = " WHERE(" + where + " AND A.errorDelayReason <> '00') ";
			}
			sql =		"SELECT" +
						" count(A.errorDelayReason) as count," +
						" B.code as code," +
						" B.name as name" +
						" FROM bug AS A" +
						" LEFT OUTER JOIN errorDelayReason AS B ON A.errorDelayReason = B.code " +
						whereStr +
						" GROUP BY A.errorDelayReason " +
						" ORDER BY A.errorDelayReason";
			break;
		}
		
		Collection list = DAO.find(new Statistics(), sql, params);
		
		if (list == null) {
			list = new ArrayList();
		} else {
			
			//Ŝ̏Wv
			int total = 0;
			Iterator ite = list.iterator();
			while(ite.hasNext()) {
				Statistics st = (Statistics)ite.next();
				total += st.getCount();
				
			}
			//ŠZbgĂ
			ite = list.iterator();
			while(ite.hasNext()) {
				Statistics st = (Statistics)ite.next();
				st.setTotal(total);
			}
		}
		return list;
	}
	/**
	 *	s`sWv
	 *
	 * @return	
	 */
	public static Collection getTatStatistics(String where, ArrayList params)
	{
		String whereStr = null;
		if (where.length() == 0) {
			whereStr = "";
		} else {
			whereStr = " WHERE" + where;
		}
		
		String sql =
					"SELECT  " +
					" TO_DAYS(" +
					"    CASE A.status " +
					"      WHEN 0 THEN now()" +
					"      WHEN 1 THEN now()" +
					"      WHEN 2 THEN now()" +
					"      WHEN 3 THEN now()" +
					"      WHEN 4 THEN now()" +
					"      WHEN 5 THEN (IFNULL(A.bugUpdateDate, NOW()))" +
					"      WHEN 6 THEN now()" +
					"      WHEN 8 THEN (IFNULL(A.comfirmDate, NOW()))" +
					"      ELSE NOW()" +
					"    END" +
					"   )" +
					"  - TO_DAYS(A.issuDate) AS tat," +
					"  A.bno," +
					"  A.status," +
					"  A.issuDate," +
					"  B.nickName AS name," +
					"  A.title" +
					"  FROM Bug AS A" +
					"  LEFT JOIN UserInfo AS B ON A.dispatch = B.uno" +
					whereStr +
					"  HAVING TAT > 6 AND A.status <> 8" +
					"  ORDER BY  TAT DESC, A.bno;";
					
		Collection list = DAO.find(new TatStatistics(), sql, params);
		
		if (list == null) {
			list = new ArrayList();
		}
		return list;
	}
	/**
	 *	SҕʏWv
	 *
	 * @return	
	 */
	public static Collection getDispatchStatistics(String where, ArrayList params)
	{
		String whereStr = null;
		if (where.length() == 0) {
			whereStr = "";
		} else {
			whereStr = " WHERE " + where;
		}
		
		String sql =
					"SELECT  " +
					" IFNULL(B.nickname,'()') as name," +
					" A.status as status," +
					" A.bno as bno," +
					" A.title as title" +
					" FROM Bug AS A" +
					" LEFT JOIN UserInfo AS B ON A.dispatch = B.uno" +
					whereStr +
					" ORDER BY B.nickname,A.status,A.bno;";
					

		Collection memberList = DAO.find(new MemberStatistics(), sql, params);
		
		Collection bugList = new ArrayList();
		String name = null;
		BugListStatistics bug = null;
		
		if (memberList != null) {
			Iterator ite = memberList.iterator();
			while(ite.hasNext()) {
				
				MemberStatistics men = (MemberStatistics)ite.next();
				//̂u[Nꍇ
				if (! men.getName().equals(name)) {
					bug = new BugListStatistics();
					bugList.add(bug);
					name = men.getName();
				}
				
				bug.setMemberStatistics(men);
				
			}
			
		}
		
		return bugList;
	}
	/**
	 *	sҕʏWv
	 *
	 * @return	
	 */
	public static Collection getIssuerStatistics(String where, ArrayList params)
	{
		String whereStr = null;
		if (where.length() == 0) {
			whereStr = "";
		} else {
			whereStr = " WHERE " + where;
		}
		
		String sql =
					"SELECT  " +
					" IFNULL(B.nickname,'(s)') as name," +
					" A.status as status," +
					" A.bno as bno," +
					" A.title as title" +
					" FROM Bug AS A" +
					" LEFT JOIN UserInfo AS B ON A.issuer = B.uno" +
					whereStr +
					" ORDER BY B.nickname,A.status,A.bno;";
					

		Collection memberList = DAO.find(new MemberStatistics(), sql, params);
		
		Collection bugList = new ArrayList();
		String name = null;
		BugListStatistics bug = null;
		
		if (memberList != null) {
			Iterator ite = memberList.iterator();
			while(ite.hasNext()) {
				
				MemberStatistics men = (MemberStatistics)ite.next();
				//̂u[Nꍇ
				if (! men.getName().equals(name)) {
					bug = new BugListStatistics();
					bugList.add(bug);
					name = men.getName();
				}
				
				bug.setMemberStatistics(men);
				
			}
			
		}
		
		return bugList;
	}
//===========================================================================
// debug code
//===========================================================================
//===========================================================================
// test code
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << BugFinder Test Start >> -----------");
		
//		unitTest1();	//}CoǑ
		unitTest2();	//sҕʏWv
		
		System.out.println("------- << BugFinder Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * }CoǑ
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		Collection bugs = BugFinder.findMyBug(1);
		
		Iterator ite = bugs.iterator();
		
		while(ite.hasNext()) {
			Bug bug = (Bug)ite.next();
			
			System.out.println("bno   :" + bug.getBno());
			System.out.println("sev   :" + bug.getSeverityString());
			System.out.println("title :" + bug.getTitle());
			System.out.println("status:" + bug.getStatusString());
			System.out.println("role  :" + bug.getRole(1));
			System.out.println("miles :" + bug.getMilestoneString());
		}
	}
	/**
	 *	unitTest2
	 *
	 * sҕʏWv
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		String where = "";
		ArrayList params = new ArrayList();
		Collection bugs = BugFinder.getIssuerStatistics(where, params);
		
		Iterator ite = bugs.iterator();
		
		while(ite.hasNext()) {
			BugListStatistics bug = (BugListStatistics)ite.next();
			
			System.out.println(bug);
		}
	}
}