//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.selections.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * AddTextNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class AddText implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	oOԍ
	 */
	private int m_bno = 0;
	/**
	 *	
	 */
	private Date m_entryDate = new Date();
	/**
	 *	Ҕԍ
	 */
	private int m_entryUno = 0;
	/**
	 *	Җ
	 */
	private String m_entryUname = null;
	/**
	 *	҃[AhX
	 */
	private String m_entryUmail = null;
	/**
	 *	eLXg^Cv
	 */
	private byte m_textType = TYPE_TROUBLE;
	/**
	 *	e
	 */
	private String m_content = null;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// 萔`
//=====================================
	/**
	 * Xe[^X
	 */
	public static final byte TYPE_TROUBLE = 1;		//̏e
	public static final byte TYPE_PRINCIPAL = 2;	//Ώj^SҘA
	public static final byte TYPE_CAUSE = 3;		//̏ጴ
	public static final byte TYPE_UPDATE = 4;		//ue
	public static final byte TYPE_CONFIRM = 5;		//mFe
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"bno", "entryDate"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"bno","entryDate","entryUno",
									"textType","content",
									"updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public AddText()
	{
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setEntryUno(updateUno);
		setUpdateUno(updateUno);
		DAO.insert(this);
//		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setEntryUno(updateUno);
		setUpdateUno(updateUno);
		DAO.update(this);
//		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setEntryUno(updateUno);
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new AddText());
	}
	/**
	 *	AddText̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static Collection getAddText(int bno)
	{
		String sql = 
		"SELECT  A.bno as bno," +
		" A.entryDate as entryDate," +
		" A.entryUno as entryUno," +
		" B.nickname as entryUname," +
		" B.email as entryUmail," +
		" A.textType as textType," +
		" A.content as content," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate" +
		" FROM AddText AS A" +
		" LEFT JOIN UserInfo AS B ON A.entryUno = B.uno" +
		" where A.bno = ? " +
		" ORDER BY A.bno,A.entryDate";
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		return (DAO.find(new AddText(), sql, params));
		
	}
	/**
	 *	AddText̎擾ioOԍw,^Cvwj
	 *
	 * @return	
	 */
	public static Collection getAddText(int bno, byte textType)
	{
		
		String sql = 
		"SELECT  A.bno as bno," +
		" A.entryDate as entryDate," +
		" A.entryUno as entryUno," +
		" B.nickname as entryUname," +
		" B.email as entryUmail," +
		" A.textType as textType," +
		" A.content as content," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate" +
		" FROM AddText AS A" +
		" LEFT JOIN UserInfo AS B ON A.entryUno = B.uno" +
		" where A.bno = ? AND" +
		" A.textType = ?" +
		" ORDER BY A.bno,A.entryDate";
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		params.add(new Byte(textType));
		
		return (DAO.find(new AddText(), sql, params));
		
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// Property
//======================================
	/**
	 * oOhc̎擾
	 * 
	 * @return oOhc
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOhc̃Zbg
	 * 
	 * @param bno oOhc
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public Date getEntryDate()
	{
		return m_entryDate;
	}
	/**
	 * ̎擾()
	 * 
	 * @return 
	 */
	public String getEntryDateString()
	{
		return Converter.getDateString(m_entryDate);
	}
	/**
	 * ̃Zbg
	 * 
	 * @param entryDate 
	 */
	public void setEntryDate(Date entryDate)
	{
		m_entryDate = entryDate;
	}
	/**
	 * Ҕԍ̎擾
	 * 
	 * @return Ҕԍ
	 */
	public int getEntryUno()
	{
		return m_entryUno;
	}
	/**
	 * Ҕԍ̃Zbg
	 * 
	 * @param entryUno Ҕԍ
	 */
	public void setEntryUno(int entryUno)
	{
		m_entryUno = entryUno;
	}
	/**
	 * Җ̎擾
	 * 
	 * @return Җ
	 */
	public String getEntryUname()
	{
		return m_entryUname;
	}
	/**
	 * Җ̃Zbg
	 * 
	 * @param entryUname Җ
	 */
	public void setEntryUname(String entryUname)
	{
		m_entryUname = entryUname;
	}
	/**
	 * ҃[AhX̎擾
	 * 
	 * @return ҃[AhX
	 */
	public String getEntryUmail()
	{
		return m_entryUmail;
	}
	/**
	 * ҃[AhX̃Zbg
	 * 
	 * @param entryUmail ҃[AhX
	 */
	public void setEntryUmail(String entryUmail)
	{
		m_entryUmail = entryUmail;
	}
	/**
	 * eLXg^Cv̎擾
	 * 
	 * @return eLXg^Cv
	 */
	public byte getTextType()
	{
		return m_textType;
	}
	/**
	 * eLXg^Cv̎擾()
	 * 
	 * @return eLXg^Cv
	 */
	public String getTextTypeString()
	{
		String s = null;
		switch(m_textType) {
		case TYPE_TROUBLE :
			s = "̏e";
			break;
		case TYPE_PRINCIPAL :
			s = "Ώj";
			break;
		case TYPE_CAUSE :
			s = "̏ጴ";
			break;
		case TYPE_UPDATE :
			s = "ue";
			break;
		case TYPE_CONFIRM :
			s = "mFe";
			break;
		default :
			s = "(unknown):" + m_textType;
			break;
		}
		return s;
	}
	/**
	 * eLXg^CṽZbg
	 * 
	 * @param textType eLXg^Cv
	 */
	public void setTextType(byte textType)
	{
		m_textType = textType;
	}
	/**
	 * e̎擾
	 * 
	 * @return e
	 */
	public String getContent()
	{
		return m_content;
	}
	/**
	 * e̎擾()
	 * 
	 * @return e
	 */
	public String getContentString()
	{
		return Converter.StringToHtml2(m_content);
	}
	/**
	 * ẽZbg
	 * 
	 * @param content e
	 */
	public void setContent(String content)
	{
		m_content = content;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		return Converter.getDateString(m_updateDate);
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
	
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [AddText] --- \n");
		sb.append("bno       : " + m_bno + "\n");
		sb.append("entryDate : " + getEntryDateString() + "\n");
		sb.append("entryUno  : " + m_entryUno + "\n");
		sb.append("entryDname: " + m_entryUname + "\n");
		sb.append("entryDmail: " + m_entryUmail + "\n");
		sb.append("textType  : " + getTextTypeString() + "\n");
		sb.append("updateUno : " + m_updateUno + "\n");
		sb.append("updateDat : " + getUpdateDateString() + "\n");
		sb.append("--- [AddText] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << AddText Test Start >> -----------");
		unitTest1();	//ǉeXg
		
		System.out.println("------- << AddText Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		System.out.println("insert start");
		//̏e𐶐
		AddText addText = null;
		for (int i = 0; i < 5; i++) {
			addText = new AddText();
			addText.setBno(2);
			addText.setTextType(AddText.TYPE_TROUBLE);
			addText.setContent("̏e" + i);
			addText.insert(i);	//ǉ
			sleep();
		}
		
		//
		addText = new AddText();
		addText.setBno(2);
		addText.setTextType(AddText.TYPE_PRINCIPAL);
		addText.setContent("Ώj^SҘA");
		addText.insert(7);	//ǉ
		//
		addText = new AddText();
		addText.setBno(2);
		addText.setTextType(AddText.TYPE_CAUSE);
		addText.setContent("̏ጴ");
		addText.insert(7);	//ǉ
		//
		addText = new AddText();
		addText.setBno(2);
		addText.setTextType(AddText.TYPE_UPDATE);
		addText.setContent("ue");
		addText.insert(7);	//ǉ
		//
		addText = new AddText();
		addText.setBno(2);
		addText.setTextType(AddText.TYPE_CONFIRM);
		addText.setContent("mFe");
		addText.insert(7);	//ǉ
		
		
		Collection list = null;
		
		//oOԍ
		System.out.println("find bug#2 all types");
		list = AddText.getAddText(2);
		display(list);
		
		//oOԍA^Cv
		System.out.println("find bug#2 TROUBLE types");
		list = AddText.getAddText(2, AddText.TYPE_TROUBLE);
		display(list);
		
		//oOԍA^Cv
		System.out.println("find bug#2 CONFIRM types");
		list = AddText.getAddText(2, AddText.TYPE_CONFIRM);
		display(list);
	}
	/**
	 * Sleep
	 */
	private static void sleep() {
		try {
			Thread.sleep(1000);
		} catch (Exception e) {
			
		}
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			AddText AddText = (AddText)ite.next();
			
			System.out.println(AddText.toString());
		}
	}
}