//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.form.*;
/**
 *<PRE>
 * 
 * UserEditActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class UserEditAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
			
		/*  
		 */
		HttpSession session = getSession(request);	//sessio̎擾
		UserInfo logonUser = (UserInfo)getAttribute(session,"UserInfo");	//OC[U̎擾
		ActionForward forward = null;
		UserEditForm myForm = (UserEditForm)form;	//form̎擾
		
		UserInfo user = (UserInfo)getAttribute(session,"EditUser");	//ҏW[U̎擾
		int uno = user.getUno();
		String uid = user.getUid();
		//f[^`FbN
		myForm.setUno(uno);		//VKǂ𔻒f邽߂unoZbg
		ActionErrors errors = myForm.validate(mapping, request);
		if (!errors.empty()) {
			saveErrors(request, errors);
			return (new ActionForward(mapping.getInput()));
		}
		
		String oldPassword = myForm.getOldPassword();
		String newPassword = myForm.getNewPassword();
		
		//VK
		if (uno == 0) {
			//͏Zbg
			PropertyUtils.copyProperties(user, myForm);
			user.setPassword(newPassword);	//pX[h
		//XV
		} else {
			//pX[hw肳Ăꍇ
			if ((oldPassword != null) && (oldPassword.length() > 0)) {
				//pX[hv`FbN
				if (! oldPassword.equals(user.getPassword())) {
					errors.add("oldPassword", new ActionError("error.oldPassword.unmatch"));
					saveErrors(request, errors);
					return (new ActionForward(mapping.getInput()));
				}
			}
			/*
			 * pX[hύXĂformɓ̃vpeB邽
			 * ɃRs[Ă܂ApX[hɂȂoOB
			 * ŃIWiҔ
			 */
			newPassword = user.getPassword();
			//͏Zbg
			PropertyUtils.copyProperties(user, myForm);
			user.setUid(uid);	//uid
			user.setPassword(newPassword);
		}
		//p[~bVZbg
		int permission = 0;
		permission += myForm.getUserPermission() ? UserInfo.USER : 0;
		permission += myForm.getTesterPermission() ? UserInfo.TESTER : 0;
		permission += myForm.getDeveloperPermission() ? UserInfo.DEVELOPER : 0;
		permission += myForm.getProjectManagerPermission() ? UserInfo.PROJECT_MANAGER : 0;
		permission += myForm.getSystemManagerPermission() ? UserInfo.SYSTEM_MANAGER : 0;
		user.setPermission(permission);
		
		//[w
		int subscriprion = 0;
		subscriprion += myForm.getSubscriprion0() ? UserInfo.MAIL_DETAIL0 : 0;
		subscriprion += myForm.getSubscriprion1() ? UserInfo.MAIL_DETAIL1 : 0;
		subscriprion += myForm.getSubscriprion2() ? UserInfo.MAIL_DETAIL2 : 0;
		subscriprion += myForm.getSubscriprion3() ? UserInfo.MAIL_DETAIL3 : 0;
		subscriprion += myForm.getSubscriprion4() ? UserInfo.MAIL_DETAIL4 : 0;
		subscriprion += myForm.getSubscriprion5() ? UserInfo.MAIL_DETAIL5 : 0;
		user.setMailSubscription(subscriprion);
		
		if (user.getUno() == 0) {
			//ǉ
			user.insert(logonUser.getUno());
			
		} else {
			//XV
			user.update(logonUser.getUno());
			
		}
		
		// Forward control to the specified success URI
		return mapping.findForward("success");
		
	}
//=====================================
// debug
//=====================================
	/**
	 */
	public void debug(String s) {
		System.out.println("[UserEditAction]" + s);
	}
}
