//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.form.*;
/**
 *<PRE>
 * 
 * UserChoiceActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class UserChoiceAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		/*  
		 */
		HttpSession session = getSession(request);	//sessio̎擾
		UserInfo logonUser = (UserInfo)getAttribute(session,"UserInfo");	//OC[U̎擾
		ActionForward forward = null;
		UserChoiceForm myForm = (UserChoiceForm)form;
		
		//f[^`FbN
		ActionErrors errors = myForm.validate(mapping, request);
		if (!errors.empty()) {
			saveErrors(request, errors);
			return (new ActionForward(mapping.getInput()));
		}
		
		UserInfo user = null;
		//ǉ̏ʕ\
		if (myForm.getUno() == 0) {
			
			user = new UserInfo();
			session.setAttribute("EditUser", user);
		//XV̏ʕ\
		} else {
			//ΏۂƂȂ郆[U߂
			user = UserInfo.getUser(myForm.getUno());
			//ʂ̃tH[𐶐
			UserEditForm nextForm = new UserEditForm();
			
			PropertyUtils.copyProperties(nextForm, user);
			
			nextForm.setUserPermission(user.isForgiven(UserInfo.USER));
			nextForm.setTesterPermission(user.isForgiven(UserInfo.TESTER));
			nextForm.setDeveloperPermission(user.isForgiven(UserInfo.DEVELOPER));
			nextForm.setProjectManagerPermission(user.isForgiven(UserInfo.PROJECT_MANAGER));
			nextForm.setSystemManagerPermission(user.isForgiven(UserInfo.SYSTEM_MANAGER));
			
			//[w
			nextForm.setSubscriprion0(user.isSubscription(UserInfo.MAIL_DETAIL0));
			nextForm.setSubscriprion1(user.isSubscription(UserInfo.MAIL_DETAIL1));
			nextForm.setSubscriprion2(user.isSubscription(UserInfo.MAIL_DETAIL2));
			nextForm.setSubscriprion3(user.isSubscription(UserInfo.MAIL_DETAIL3));
			nextForm.setSubscriprion4(user.isSubscription(UserInfo.MAIL_DETAIL4));
			nextForm.setSubscriprion5(user.isSubscription(UserInfo.MAIL_DETAIL5));
			
			session.setAttribute("EditUser", user);
			request.setAttribute("userEditForm", nextForm);
			
		}
		
		return mapping.findForward("success");
		
	}
}
