//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.system.*;
/**
 *<PRE>
 * 
 * FogotPasswordActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class ForgotPasswordAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		
		/*  
		 */
		HttpSession session = getSession(request);	//sessio̎擾
		ActionForward forward = null;
		ForgotPasswordForm myForm = (ForgotPasswordForm)form;
		
		//debug
		log.debug("action = " + myForm.getAction());
		
		//\
		if (myForm.getAction().equals("show")) {
			forward = (mapping.findForward("show"));
			
		//[M˗
		} else {
			//G[`FbN
			ActionErrors errors = myForm.validate(mapping, request);
			if (!errors.empty()) {
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			//[AhX̌
			String email = myForm.getEmail();
			
			//debug
			log.debug("email = " + email);
			
			UserInfo user = UserInfo.getUserForEmail(email);
			if (user == null) {
				//G[
				errors.add("email", new ActionError("error.email.invalid", "email"));
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			
			MailElements me = new MailElements();
			me.setSubject("[bugslife]o^AJEĝ点");
			me.addTo(user);
			StringBuffer sb = new StringBuffer();
			sb.append("\n");
			sb.append("o^AJEgm点܂\n");
			sb.append("\n");
			sb.append("AJEgF" + user.getUid() + "\n");
			sb.append("pX[hF" + user.getPassword() + "\n");
			sb.append("\n");
			sb.append("---\n");
			sb.append( me.getFrom() + "\n");
			me.setBody(new String(sb));
			try {
				MailSender.send(me);
			} catch(Exception e) {
				//MG[
				throw new BLRuntimeException("mail send error",e);
			}
			
			myForm.setResult("<ul><li>AJEgƃpX[h𑗐M܂B</li></ul>");
			
			forward = (mapping.findForward("success"));
		}
		// Forward control to the specified success URI
		return forward;
	}
}
