delete from tmpst1;
delete from tmpst2;
delete from tmpst3;
delete from tmpst4;
delete from tmpst5;

INSERT INTO tmpst1
SELECT  
 DATE_FORMAT(A.issuDate,'%m/%d') as date,
 count(A.issuDate) as count
 FROM Bug AS A
 GROUP BY DATE_FORMAT(A.issuDate,'%y%m%d')
 ORDER BY A.issuDate;

INSERT INTO tmpst2
SELECT  
 DATE_FORMAT(A.issuDate,'%m/%d') as date,
 count(A.issuDate) as count
 FROM Bug AS A
 WHERE A.resolution > 0 and A.resolution < 10
 GROUP BY DATE_FORMAT(A.issuDate,'%y%m%d')
 ORDER BY A.issuDate;

INSERT INTO tmpst3
SELECT  
 DATE_FORMAT(A.analizeDate,'%m/%d') as date,
 count(A.analizeDate) as count
 FROM Bug AS A
 WHERE 
 (A.resolution > 0 and A.resolution < 10) and 
 (A.analizeDate IS NOT NULL)
 GROUP BY DATE_FORMAT(A.analizeDate,'%y%m%d')
 ORDER BY A.analizeDate;

INSERT INTO tmpst4
SELECT  
 DATE_FORMAT(A.bugUpdateDate,'%m/%d') as date,
 count(A.bugUpdateDate) as count
 FROM Bug AS A
 WHERE 
 (A.resolution > 0 and A.resolution < 10) and 
 (A.bugUpdateDate IS NOT NULL)
 GROUP BY DATE_FORMAT(A.bugUpdateDate,'%y%m%d')
 ORDER BY A.bugUpdateDate;

INSERT INTO tmpst5
SELECT  
 DATE_FORMAT(A.comfirmDate,'%m/%d') as date,
 count(A.comfirmDate) as count
 FROM Bug AS A
 WHERE 
 (A.resolution > 0 and A.resolution < 10) and 
 (A.comfirmDate IS NOT NULL)
 GROUP BY DATE_FORMAT(A.comfirmDate,'%y%m%d')
 ORDER BY A.comfirmDate;

SELECT 
 A.cDate as cDate,
 IFNULL(A.count,0) as issuCount,
 IFNULL(B.count,0) as bugCount,
 IFNULL(C.count,0) as analizeCount,
 IFNULL(D.count,0) as updateCount,
 IFNULL(E.count,0) as comfirmCount
 FROM tmpst1 AS A
 LEFT OUTER JOIN tmpst2 B ON B.cDate = A.cDate
 LEFT OUTER JOIN tmpst3 C ON C.cDate = A.cDate
 LEFT OUTER JOIN tmpst4 D ON D.cDate = A.cDate
 LEFT OUTER JOIN tmpst5 E ON E.cDate = A.cDate
 ORDER BY A.cDate;

